/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.dss.client.api.gui;

import ch.systemsx.cisd.openbis.dss.client.api.gui.AbstractEntityPickerDialog;
import ch.systemsx.cisd.openbis.dss.client.api.gui.DataSetUploadClientModel;
import ch.systemsx.cisd.openbis.dss.client.api.gui.UploadClientSortingUtils;
import ch.systemsx.cisd.openbis.dss.client.api.gui.tree.FilterableMutableTreeNode;
import ch.systemsx.cisd.openbis.generic.shared.api.v1.dto.Experiment;
import ch.systemsx.cisd.openbis.generic.shared.api.v1.dto.Sample;
import java.awt.Point;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Collections;
import java.util.List;
import java.util.TimerTask;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeWillExpandListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.ExpandVetoException;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SamplePickerDialog
extends AbstractEntityPickerDialog
implements TreeWillExpandListener {
    private static final long serialVersionUID = 1L;
    private final JTree tree = new JTree();
    private final JTextField filterField;
    private final JOptionPane optionPane;

    public SamplePickerDialog(JFrame mainWindow, DataSetUploadClientModel clientModel) {
        super(mainWindow, "Pick a sample", clientModel);
        this.tree.setModel(new DefaultTreeModel(null));
        this.tree.addTreeWillExpandListener(this);
        this.tree.getSelectionModel().setSelectionMode(1);
        this.filterField = this.createFilterField();
        JPanel northPanel = SamplePickerDialog.createFilterAndRefreshButtonPanel(this.filterField, this.refreshButton);
        this.optionPane = SamplePickerDialog.createOptionPane(this.tree, northPanel, this);
        this.addTreeSelectionListener();
        this.setDialogData();
        this.setContentPane(this.optionPane);
    }

    @Override
    protected void setDialogData() {
        FilterableMutableTreeNode top = new FilterableMutableTreeNode("Experiments");
        List<String> projectIdentifiers = this.clientModel.getProjectIdentifiers();
        List<Experiment> experiments = this.clientModel.getOpenBISService().listExperimentsHavingSamplesForProjects(projectIdentifiers);
        SamplePickerDialog.createNodes(top, experiments);
        DefaultTreeModel treeModel = (DefaultTreeModel)this.tree.getModel();
        treeModel.setRoot(top);
        this.updateTreeSelection();
    }

    private void addTreeSelectionListener() {
        this.tree.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent e) {
                if (e.getClickCount() > 1) {
                    SamplePickerDialog.this.optionPane.setValue(0);
                }
            }
        });
    }

    private static JOptionPane createOptionPane(JTree tree, JPanel northPanel, SamplePickerDialog parent) {
        JScrollPane scrollPane = new JScrollPane(tree);
        Object[] objects = new Object[]{"Filter experiments: ", northPanel, "Select Sample:", scrollPane};
        JOptionPane theOptionPane = new JOptionPane(objects, -1, 2);
        theOptionPane.addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                if (!evt.getPropertyName().equals("value") || evt.getNewValue() == null) {
                    return;
                }
                if (this.isCancelClicked(evt)) {
                    SamplePickerDialog.this.setVisible(false);
                    return;
                }
                if (this.isOkClicked(evt)) {
                    SamplePickerDialog.this.acceptCurrentSelectionOrNotify();
                }
            }

            private boolean isOkClicked(PropertyChangeEvent evt) {
                return (Integer)evt.getNewValue() == 0;
            }

            private boolean isCancelClicked(PropertyChangeEvent evt) {
                return !this.isOkClicked(evt);
            }
        });
        return theOptionPane;
    }

    private void acceptCurrentSelectionOrNotify() {
        if (this.tree.getSelectionPath() == null) {
            JOptionPane.showMessageDialog(this, "Sample needs to be selected!", "No sample selected!", 2);
            this.optionPane.setValue(this.optionPane.getInitialValue());
        } else if (this.tree.getSelectionPath().getPath().length < 3) {
            JOptionPane.showMessageDialog(this, "Sample should be selected, not experiment!", "No sample selected!", 2);
            this.optionPane.setValue(this.optionPane.getInitialValue());
        } else {
            this.setVisible(false);
        }
    }

    private static void createNodes(FilterableMutableTreeNode top, List<Experiment> experiments) {
        UploadClientSortingUtils.sortExperimentsByIdentifier(experiments);
        for (Experiment experiment : experiments) {
            DefaultMutableTreeNode category = new DefaultMutableTreeNode(experiment.getIdentifier(), true);
            category.add(new DefaultMutableTreeNode("dummy child"));
            top.add(category);
        }
    }

    private JTextField createFilterField() {
        JTextField textField = new JTextField();
        textField.setEditable(true);
        textField.getDocument().addDocumentListener(new DocumentListener(){

            public void removeUpdate(DocumentEvent e) {
                SamplePickerDialog.this.updateTreeSelection();
            }

            public void insertUpdate(DocumentEvent e) {
                SamplePickerDialog.this.updateTreeSelection();
            }

            public void changedUpdate(DocumentEvent e) {
                SamplePickerDialog.this.updateTreeSelection();
            }
        });
        return textField;
    }

    private void updateTreeSelection() {
        DefaultTreeModel treeModel = (DefaultTreeModel)this.tree.getModel();
        FilterableMutableTreeNode rootNode = (FilterableMutableTreeNode)treeModel.getRoot();
        if (rootNode != null) {
            rootNode.filter(this.filterField.getText());
        }
        treeModel.reload();
    }

    public String pickSample() {
        this.pack();
        int height = this.getHeight() > 500 ? 500 : this.getHeight();
        int width = this.getWidth() > 600 ? 600 : this.getWidth();
        this.setSize(width, height);
        Point mwLocation = this.mainWindow.getLocationOnScreen();
        int x = mwLocation.x + this.mainWindow.getWidth() / 2 - this.getWidth() / 2;
        int y = mwLocation.y + this.mainWindow.getHeight() / 2 - this.getHeight() / 2;
        this.setLocation(x > 0 ? x : 0, y > 0 ? y : 0);
        this.setVisible(true);
        Object value = this.optionPane.getValue();
        this.optionPane.setValue(this.optionPane.getInitialValue());
        if (value == null || (Integer)value == 2) {
            return null;
        }
        TreePath treePath = this.tree.getSelectionPath();
        if (treePath == null) {
            return null;
        }
        return treePath.getLastPathComponent().toString();
    }

    @Override
    public void treeWillExpand(TreeExpansionEvent event) throws ExpandVetoException {
        if (((TreeNode)event.getPath().getLastPathComponent()).getParent() == null) {
            return;
        }
        List<Sample> samples = this.listSortedSamples(event);
        final DefaultMutableTreeNode node = (DefaultMutableTreeNode)event.getPath().getLastPathComponent();
        node.removeAllChildren();
        for (Sample s : samples) {
            node.add(new DefaultMutableTreeNode(s.getIdentifier()));
        }
        if (node.getChildCount() == 0) {
            scheduler.schedule(new TimerTask(){

                public void run() {
                    SamplePickerDialog.this.tree.collapsePath(new TreePath(node.getPath()));
                }
            }, 1500L);
        }
    }

    protected List<Sample> listSortedSamples(TreeExpansionEvent event) {
        List<String> experimentId = Collections.singletonList(event.getPath().getLastPathComponent().toString());
        List<Sample> samples = this.clientModel.getOpenBISService().listSamplesForExperiments(experimentId);
        UploadClientSortingUtils.sortSamplesByIdentifier(samples);
        return samples;
    }

    @Override
    public void treeWillCollapse(TreeExpansionEvent event) throws ExpandVetoException {
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)event.getPath().getLastPathComponent();
        node.removeAllChildren();
        node.add(new DefaultMutableTreeNode("dummy child"));
    }
}

