/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.dss.client.api.v1.impl;

import ch.systemsx.cisd.common.api.IRpcService;
import ch.systemsx.cisd.common.api.IncompatibleAPIVersionsException;
import ch.systemsx.cisd.common.spring.HttpInvokerUtils;
import ch.systemsx.cisd.openbis.dss.client.api.v1.impl.DssServiceRpcFactory;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ServiceProxyBuilder<T extends IRpcService> {
    private final String serviceURL;
    private final Class<?> clazz;
    private final long serverTimeoutMillis;
    private final int apiClientVersion;

    ServiceProxyBuilder(String serviceURL, Class<?> clazz, long serverTimeoutMillis, int apiClientVersion) {
        this.serviceURL = serviceURL;
        this.clazz = clazz;
        this.serverTimeoutMillis = serverTimeoutMillis;
        this.apiClientVersion = apiClientVersion;
    }

    T getServiceInterface() throws IncompatibleAPIVersionsException {
        T service = this.getRawServiceProxy();
        int apiServerVersion = (service = this.wrapProxyInServiceInvocationHandler(service)).getMajorVersion();
        if (this.apiClientVersion != apiServerVersion) {
            throw new IncompatibleAPIVersionsException(this.apiClientVersion, apiServerVersion);
        }
        return service;
    }

    private T getRawServiceProxy() {
        return (T)((IRpcService)HttpInvokerUtils.createStreamSupportingServiceStub(this.clazz, this.serviceURL, this.serverTimeoutMillis));
    }

    private T wrapProxyInServiceInvocationHandler(T service) {
        ClassLoader classLoader = DssServiceRpcFactory.class.getClassLoader();
        ServiceInvocationHandler invocationHandler = new ServiceInvocationHandler((IRpcService)service);
        IRpcService proxy = (IRpcService)Proxy.newProxyInstance(classLoader, new Class[]{this.clazz}, (InvocationHandler)invocationHandler);
        return (T)proxy;
    }

    private static final class ServiceInvocationHandler
    implements InvocationHandler {
        private final IRpcService service;

        private ServiceInvocationHandler(IRpcService service) {
            this.service = service;
        }

        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            try {
                return method.invoke((Object)this.service, args);
            }
            catch (InvocationTargetException ex) {
                throw ex.getCause();
            }
        }
    }
}

