/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.dss.generic.shared.utils;

import ch.rinn.restrictions.Private;
import ch.systemsx.cisd.common.exceptions.ConfigurationFailureException;
import ch.systemsx.cisd.common.filesystem.FileOperations;
import ch.systemsx.cisd.common.filesystem.FileUtilities;
import ch.systemsx.cisd.common.filesystem.IFileOperations;
import ch.systemsx.cisd.common.utilities.ExtendedProperties;
import ch.systemsx.cisd.common.utilities.PropertyUtils;
import ch.systemsx.cisd.common.utilities.Template;
import ch.systemsx.cisd.openbis.dss.generic.shared.utils.CorePluginsInjector;
import java.io.File;
import java.util.Map;
import java.util.Properties;
import java.util.Set;

public class DssPropertyParametersUtil {
    public static final String OPENBIS_DSS_SYSTEM_PROPERTIES_PREFIX = "openbis.dss.";
    public static final String DSS_CODE_KEY = "data-store-server-code";
    public static final String STOREROOT_DIR_KEY = "storeroot-dir";
    public static final String DOWNLOAD_URL_KEY = "download-url";
    public static final String SERVER_URL_KEY = "server-url";
    static final String DSS_TEMP_DIR_PATH = "dss-temp-dir";
    @Private
    static final File EMPTY_TEST_FILE = new File("an-empty-test-file");
    public static final String DSS_REGISTRATION_LOG_DIR_PATH = "dss-registration-log-dir";
    public static final String SERVICE_PROPERTIES_FILE = "etc/service.properties";
    private static final String EXPLANATION = "Please make sure this directory exists on the local file system and is writable by the data store server or provide such a directory by the configuration parameter '${path-key}'.";
    private static final Template NON_EXISTING_DIR_TEMPLATE = new Template("Could not create ${dir-description} at path: ${path}. Please make sure this directory exists on the local file system and is writable by the data store server or provide such a directory by the configuration parameter '${path-key}'.");
    private static final Template NON_LOCAL_DIR_TEMPLATE = new Template("Directory at path '${path}' is not on the local file system. Please make sure this directory exists on the local file system and is writable by the data store server or provide such a directory by the configuration parameter '${path-key}'.");

    public static ExtendedProperties loadServiceProperties() {
        ExtendedProperties serviceProperties = DssPropertyParametersUtil.loadProperties(SERVICE_PROPERTIES_FILE);
        new CorePluginsInjector().injectCorePlugins(serviceProperties);
        return serviceProperties;
    }

    public static ExtendedProperties loadProperties(String filePath) {
        Properties properties = PropertyUtils.loadProperties(filePath);
        Properties systemProperties = System.getProperties();
        ExtendedProperties dssSystemProperties = ExtendedProperties.getSubset(systemProperties, OPENBIS_DSS_SYSTEM_PROPERTIES_PREFIX, true);
        Set<Map.Entry<Object, Object>> entrySet = dssSystemProperties.entrySet();
        for (Map.Entry<Object, Object> entry : entrySet) {
            properties.put(entry.getKey(), entry.getValue());
        }
        return ExtendedProperties.createWith(properties);
    }

    public static String getDataStoreCode(Properties serviceProperties) {
        return PropertyUtils.getMandatoryProperty(serviceProperties, DSS_CODE_KEY).toUpperCase();
    }

    public static final File getStoreRootDir(Properties properties) {
        return FileUtilities.normalizeFile(new File(PropertyUtils.getMandatoryProperty(properties, STOREROOT_DIR_KEY)));
    }

    public static String getOpenBisServerUrl(Properties serviceProperties) {
        return PropertyUtils.getMandatoryProperty(serviceProperties, SERVER_URL_KEY);
    }

    public static String getDownloadUrl(Properties serviceProperties) {
        return PropertyUtils.getMandatoryProperty(serviceProperties, DOWNLOAD_URL_KEY);
    }

    public static File getDssInternalTempDir(Properties properties) {
        return DssPropertyParametersUtil.getDssInternalTempDir(FileOperations.getInstance(), properties);
    }

    @Private
    static File getDssInternalTempDir(IFileOperations fileOperations, Properties properties) {
        return DssPropertyParametersUtil.getDir(fileOperations, properties, "dss-tmp", "an internal temp directory for the data store server", DSS_TEMP_DIR_PATH);
    }

    public static File getDssRegistrationLogDir(Properties properties) {
        return DssPropertyParametersUtil.getDssRegistrationLogDir(FileOperations.getInstance(), properties);
    }

    @Private
    static File getDssRegistrationLogDir(IFileOperations fileOperations, Properties properties) {
        return DssPropertyParametersUtil.getDir(fileOperations, properties, "log-registrations", "a directory for storing registration logs", DSS_REGISTRATION_LOG_DIR_PATH);
    }

    private static File getDir(IFileOperations fileOperations, Properties properties, String defaultDirName, String dirDescription, String pathKey) {
        String defaultRegistrationLogDirPath = new File(System.getProperty("user.dir"), defaultDirName).getAbsolutePath();
        String registrationLogDirPath = PropertyUtils.getProperty(properties, pathKey, defaultRegistrationLogDirPath);
        File registrationLogDir = new File(registrationLogDirPath);
        fileOperations.mkdirs(registrationLogDir);
        DssPropertyParametersUtil.assertDirExistsAndIsLocal(fileOperations, registrationLogDir, dirDescription, pathKey);
        return registrationLogDir;
    }

    private static void assertDirExistsAndIsLocal(IFileOperations fileOperations, File dir, String dirDescription, String pathKey) {
        DssPropertyParametersUtil.assertDirExists(fileOperations, dir, dirDescription, pathKey);
        File emptyTestFileInDir = new File(dir, EMPTY_TEST_FILE.getName());
        try {
            fileOperations.createNewFile(EMPTY_TEST_FILE);
            if (!fileOperations.rename(EMPTY_TEST_FILE, emptyTestFileInDir)) {
                throw DssPropertyParametersUtil.createException(NON_LOCAL_DIR_TEMPLATE.createFreshCopy(), dir, dirDescription, pathKey);
            }
        }
        finally {
            fileOperations.delete(EMPTY_TEST_FILE);
            fileOperations.delete(emptyTestFileInDir);
        }
    }

    private static void assertDirExists(IFileOperations fileOperations, File dir, String dirDescription, String pathKey) {
        if (!fileOperations.exists(dir)) {
            throw DssPropertyParametersUtil.createException(NON_EXISTING_DIR_TEMPLATE.createFreshCopy(), dir, dirDescription, pathKey);
        }
    }

    private static ConfigurationFailureException createException(Template template, File dir, String dirName, String pathKey) {
        template.attemptToBind("dir-description", dirName);
        template.bind("path", dir.getPath());
        template.bind("path-key", pathKey);
        ConfigurationFailureException e = new ConfigurationFailureException(template.createText());
        return e;
    }
}

