/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.shared.authorization.predicate;

import ch.systemsx.cisd.common.exceptions.Status;
import ch.systemsx.cisd.openbis.generic.shared.authorization.IAuthorizationDataProvider;
import ch.systemsx.cisd.openbis.generic.shared.authorization.RoleWithIdentifier;
import ch.systemsx.cisd.openbis.generic.shared.authorization.predicate.AbstractDatabaseInstancePredicate;
import ch.systemsx.cisd.openbis.generic.shared.authorization.predicate.SampleOwnerIdentifierPredicate;
import ch.systemsx.cisd.openbis.generic.shared.dto.PermId;
import ch.systemsx.cisd.openbis.generic.shared.dto.PersonPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.SamplePE;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SamplePermIdPredicate
extends AbstractDatabaseInstancePredicate<PermId> {
    private final SampleOwnerIdentifierPredicate sampleOwnerIdentifierPredicate;

    public SamplePermIdPredicate() {
        this(true);
    }

    public SamplePermIdPredicate(boolean isReadAccess) {
        this.sampleOwnerIdentifierPredicate = new SampleOwnerIdentifierPredicate(isReadAccess);
    }

    @Override
    public final void init(IAuthorizationDataProvider provider) {
        super.init(provider);
        this.sampleOwnerIdentifierPredicate.init(provider);
    }

    @Override
    public final String getCandidateDescription() {
        return "sample perm id";
    }

    @Override
    protected final Status doEvaluation(PersonPE person, List<RoleWithIdentifier> allowedRoles, PermId id) {
        SamplePE sample = this.authorizationDataProvider.tryGetSample(id);
        if (sample == null) {
            return Status.createError(String.format("User '%s' does not have enough privileges.", person.getUserId()));
        }
        return this.sampleOwnerIdentifierPredicate.doEvaluation(person, allowedRoles, sample.getSampleIdentifier());
    }
}

