/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.shared.basic.dto;

import ch.systemsx.cisd.openbis.generic.shared.basic.dto.DetailedSearchCriterion;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.DetailedSearchSubCriteria;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.SearchCriteriaConnection;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DetailedSearchCriteria
implements Serializable {
    private static final long serialVersionUID = 32L;
    private List<DetailedSearchCriterion> criteria;
    private SearchCriteriaConnection connection;
    private boolean useWildcardSearchMode;
    private List<DetailedSearchSubCriteria> subCriterias = new ArrayList<DetailedSearchSubCriteria>();

    public List<DetailedSearchCriterion> getCriteria() {
        return this.criteria;
    }

    public void setCriteria(List<DetailedSearchCriterion> criteria) {
        this.criteria = criteria;
    }

    public List<DetailedSearchSubCriteria> getSubCriterias() {
        return this.subCriterias;
    }

    public void setSubCriterias(List<DetailedSearchSubCriteria> subCriterias) {
        this.subCriterias = subCriterias;
    }

    public void addSubCriteria(DetailedSearchSubCriteria subCriteria) {
        this.subCriterias.add(subCriteria);
    }

    public SearchCriteriaConnection getConnection() {
        return this.connection;
    }

    public void setConnection(SearchCriteriaConnection connection) {
        this.connection = connection;
    }

    public boolean isUseWildcardSearchMode() {
        return this.useWildcardSearchMode;
    }

    public void setUseWildcardSearchMode(boolean useWildcardSearchMode) {
        this.useWildcardSearchMode = useWildcardSearchMode;
    }

    public boolean isEmpty() {
        return (this.criteria == null || this.criteria.isEmpty()) && this.subCriterias.isEmpty();
    }

    String toString(boolean withWildcardInfo) {
        StringBuilder sb = new StringBuilder();
        if (this.criteria != null) {
            for (DetailedSearchCriterion element : this.criteria) {
                if (sb.length() > 0) {
                    sb.append(" " + this.getConnection().getLabel() + " ");
                }
                sb.append(element);
            }
        }
        for (DetailedSearchSubCriteria subCriteria : this.subCriterias) {
            if (sb.length() > 0) {
                sb.append(", ");
            }
            sb.append("[" + subCriteria.toString() + "]");
        }
        if (withWildcardInfo) {
            sb.append(" (" + (this.isUseWildcardSearchMode() ? "with" : "without") + " wildcards)");
        }
        return sb.toString();
    }

    public String toString() {
        return this.toString(true);
    }
}

