/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.shared.basic.dto;

import ch.systemsx.cisd.common.annotation.BeanProperty;
import ch.systemsx.cisd.openbis.generic.shared.basic.IIdentifierHolder;
import java.io.Serializable;
import java.util.Comparator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Identifier<T extends Identifier<T>>
implements Serializable,
Comparable<T>,
IIdentifierHolder {
    private static final long serialVersionUID = 32L;
    public static final String IDENTIFIER_COLUMN = "identifier";
    public static final Comparator<IIdentifierHolder> IDENTIFIER_HOLDER_COMPARATOR = new IdentifierHolderComparator();
    private String identifier;
    private String permID;

    protected static String toUpperCase(String identifierOrNull) {
        return identifierOrNull == null ? null : identifierOrNull.toUpperCase();
    }

    public void setPermID(String permID) {
        this.permID = permID;
    }

    public String getPermID() {
        return this.permID;
    }

    @BeanProperty(label="identifier", optional=true)
    public final void setIdentifier(String identifier) {
        this.identifier = Identifier.toUpperCase(identifier);
    }

    @Override
    public final String getIdentifier() {
        return this.identifier;
    }

    @Override
    public final int compareTo(T o) {
        return IDENTIFIER_HOLDER_COMPARATOR.compare(this, (IIdentifierHolder)o);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof Identifier)) {
            return false;
        }
        Identifier that = (Identifier)obj;
        return this.getIdentifier().equals(that.getIdentifier());
    }

    public final int hashCode() {
        return this.getIdentifier().hashCode();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class IdentifierHolderComparator
    implements Comparator<IIdentifierHolder>,
    Serializable {
        private static final long serialVersionUID = 1L;

        @Override
        public int compare(IIdentifierHolder o1, IIdentifierHolder o2) {
            assert (o1 != null) : "Unspecified code provider.";
            assert (o2 != null) : "Unspecified code provider.";
            String thisIdentifier = o1.getIdentifier();
            String thatIdentifier = o2.getIdentifier();
            if (thisIdentifier == null) {
                return thatIdentifier == null ? 0 : -1;
            }
            if (thatIdentifier == null) {
                return 1;
            }
            return thisIdentifier.compareTo(thatIdentifier);
        }
    }
}

