/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.shared.basic.dto;

import ch.systemsx.cisd.openbis.generic.shared.basic.GridRowModel;
import ch.systemsx.cisd.openbis.generic.shared.basic.IColumnDefinition;
import ch.systemsx.cisd.openbis.generic.shared.basic.SimpleDateRenderer;
import ch.systemsx.cisd.openbis.generic.shared.basic.SimpleImageHtmlRenderer;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.DataTypeCode;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.DateTableCell;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.DssLinkTableCell;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.GeneratedImageTableCell;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.ISerializableComparable;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.ImageTableCell;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.TableModelColumnHeader;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.TableModelRowWithObject;
import java.io.Serializable;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TypedTableGridColumnDefinition<T extends Serializable>
implements IColumnDefinition<TableModelRowWithObject<T>> {
    protected TableModelColumnHeader header;
    private String title;
    private String downloadURL;
    private String sessionID;

    public TypedTableGridColumnDefinition(TableModelColumnHeader header, String title, String downloadURL, String sessionID) {
        this.header = header;
        this.title = title;
        this.downloadURL = downloadURL;
        this.sessionID = sessionID;
    }

    private TypedTableGridColumnDefinition() {
    }

    @Override
    public String getHeader() {
        return this.title;
    }

    @Override
    public String getIdentifier() {
        return this.header.getId();
    }

    @Override
    public DataTypeCode tryToGetDataType() {
        return this.header.getDataType();
    }

    public int getIndex() {
        return this.header.getIndex();
    }

    @Override
    public String tryToGetProperty(String key) {
        return this.header.tryToGetProperty(key);
    }

    @Override
    public String getValue(GridRowModel<TableModelRowWithObject<T>> rowModel) {
        Comparable<?> cell = this.tryGetComparableValue(rowModel);
        if (cell instanceof ImageTableCell) {
            ImageTableCell imageCell = (ImageTableCell)cell;
            int width = imageCell.getMaxThumbnailWidth();
            int height = imageCell.getMaxThumbnailHeight();
            String imagePath = imageCell.getPath();
            return SimpleImageHtmlRenderer.createEmbededDatastoreImageHtml(imagePath, width, height, this.downloadURL, this.sessionID);
        }
        if (cell instanceof DateTableCell) {
            return SimpleDateRenderer.renderDate(((DateTableCell)cell).getDateTime());
        }
        if (cell instanceof GeneratedImageTableCell) {
            return ((GeneratedImageTableCell)cell).getHTMLString(this.downloadURL, this.sessionID);
        }
        if (cell instanceof DssLinkTableCell) {
            return ((DssLinkTableCell)cell).getHtmlString(this.sessionID);
        }
        return cell.toString();
    }

    @Override
    public Comparable<?> tryGetComparableValue(GridRowModel<TableModelRowWithObject<T>> rowModel) {
        List<ISerializableComparable> values = rowModel.getOriginalObject().getValues();
        int index = this.header.getIndex();
        return index < values.size() ? values.get(index) : null;
    }
}

