/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.shared.dto;

import ch.systemsx.cisd.openbis.generic.shared.dto.DataSetTypePropertyTypePE;
import ch.systemsx.cisd.openbis.generic.shared.dto.EntityTypePE;
import ch.systemsx.cisd.openbis.generic.shared.dto.properties.EntityKind;
import java.util.HashSet;
import java.util.Set;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.OneToMany;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Transient;
import javax.persistence.UniqueConstraint;
import org.hibernate.annotations.Cascade;
import org.hibernate.validator.Length;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Entity
@Table(name="data_set_types", uniqueConstraints={@UniqueConstraint(columnNames={"code", "dbin_id"})})
public class DataSetTypePE
extends EntityTypePE {
    private static final long serialVersionUID = 32L;
    private Set<DataSetTypePropertyTypePE> dataSetTypePropertyTypes = new HashSet<DataSetTypePropertyTypePE>();
    private String mainDataSetPath;
    private String mainDataSetPattern;
    private boolean isContainerType;

    @Override
    @SequenceGenerator(name="DATA_SET_TYPE_ID_SEQ", sequenceName="DATA_SET_TYPE_ID_SEQ", allocationSize=1)
    @Id
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="DATA_SET_TYPE_ID_SEQ")
    public final Long getId() {
        return this.id;
    }

    public void addDataSetTypePropertyType(DataSetTypePropertyTypePE child) {
        DataSetTypePE parent = (DataSetTypePE)child.getEntityType();
        if (parent != null) {
            parent.getDataSetTypePropertyTypesInternal().remove(child);
        }
        child.setEntityTypeInternal(this);
        this.getDataSetTypePropertyTypesInternal().add(child);
    }

    @OneToMany(cascade={CascadeType.ALL}, fetch=FetchType.LAZY, mappedBy="entityTypeInternal")
    @Cascade(value={org.hibernate.annotations.CascadeType.DELETE_ORPHAN})
    private Set<DataSetTypePropertyTypePE> getDataSetTypePropertyTypesInternal() {
        return this.dataSetTypePropertyTypes;
    }

    private void setDataSetTypePropertyTypesInternal(Set<DataSetTypePropertyTypePE> dataSetTypePropertyTypes) {
        this.dataSetTypePropertyTypes = dataSetTypePropertyTypes;
    }

    @Transient
    public Set<DataSetTypePropertyTypePE> getDataSetTypePropertyTypes() {
        return this.getDataSetTypePropertyTypesInternal();
    }

    public final void setDataSetTypePropertyTypes(Set<DataSetTypePropertyTypePE> dataSetTypePropertyTypes) {
        this.getDataSetTypePropertyTypesInternal().clear();
        for (DataSetTypePropertyTypePE child : dataSetTypePropertyTypes) {
            this.addDataSetTypePropertyType(child);
        }
    }

    @Column(name="main_ds_path")
    @Length(min=1, max=1000, message="Given path '%s' is either too short (minimal length: {min} character) or too long (maximal length: {max} characters).")
    public String getMainDataSetPath() {
        return this.mainDataSetPath;
    }

    public void setMainDataSetPath(String mainDataSetPath) {
        this.mainDataSetPath = mainDataSetPath;
    }

    @Column(name="main_ds_pattern")
    @Length(min=1, max=300, message="Given file name pattern '%s' is either too short (minimal length: {min} character) or too long (maximal length: {max} characters).")
    public String getMainDataSetPattern() {
        return this.mainDataSetPattern;
    }

    public void setMainDataSetPattern(String mainDataSetPattern) {
        this.mainDataSetPattern = mainDataSetPattern;
    }

    @Override
    @Transient
    public EntityKind getEntityKind() {
        return EntityKind.DATA_SET;
    }

    @Column(name="is_container")
    public boolean isContainerType() {
        return this.isContainerType;
    }

    public void setContainerType(boolean isContainerType) {
        this.isContainerType = isContainerType;
    }
}

