/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.shared.dto;

import ch.rinn.restrictions.Friend;
import ch.rinn.restrictions.Private;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.DataStoreServiceKind;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.ReportingPluginType;
import ch.systemsx.cisd.openbis.generic.shared.dto.DataSetTypePE;
import ch.systemsx.cisd.openbis.generic.shared.dto.DataStorePE;
import java.io.Serializable;
import java.util.Set;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.JoinTable;
import javax.persistence.ManyToMany;
import javax.persistence.ManyToOne;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Transient;
import org.hibernate.validator.Length;
import org.hibernate.validator.NotNull;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Entity
@Table(name="data_store_services")
@Friend(toClasses={DataStorePE.class})
public class DataStoreServicePE
implements Serializable {
    private static final long serialVersionUID = 32L;
    private transient Long id;
    private String key;
    private String label;
    private DataStoreServiceKind kind;
    private ReportingPluginType reportingPluginTypeOrNull;
    private DataStorePE dataStore;
    private Set<DataSetTypePE> datasetTypes;

    @Id
    @SequenceGenerator(name="DATA_STORE_SERVICES_ID_SEQ", sequenceName="DATA_STORE_SERVICES_ID_SEQ", allocationSize=1)
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="DATA_STORE_SERVICES_ID_SEQ")
    private final Long getId() {
        return this.id;
    }

    private void setId(Long id) {
        this.id = id;
    }

    @Column(nullable=false, name="key")
    @NotNull(message="Identifier can not be null.")
    @Length(min=1, max=256, message="Given identifier '%s' is too long (maximal length: {max} characters).")
    public String getKey() {
        return this.key;
    }

    public void setKey(String key) {
        this.key = key;
    }

    @Column(nullable=false, name="label")
    @NotNull(message="Label can not be null.")
    @Length(min=1, max=256, message="Given label '%s' is too long (maximal length: {max} characters).")
    public String getLabel() {
        return this.label;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    @ManyToMany(fetch=FetchType.EAGER, cascade={CascadeType.REFRESH})
    @JoinTable(name="DATA_STORE_SERVICE_DATA_SET_TYPES", joinColumns={@JoinColumn(name="DATA_STORE_SERVICE_ID")}, inverseJoinColumns={@JoinColumn(name="DATA_SET_TYPE_ID")})
    public Set<DataSetTypePE> getDatasetTypes() {
        return this.datasetTypes;
    }

    public void setDatasetTypes(Set<DataSetTypePE> datasetTypes) {
        this.datasetTypes = datasetTypes;
    }

    @NotNull(message="Data Store Service Kind  can not be null.")
    @Column(name="kind")
    @Enumerated(value=EnumType.STRING)
    public DataStoreServiceKind getKind() {
        return this.kind;
    }

    public void setKind(DataStoreServiceKind kind) {
        this.kind = kind;
    }

    @Column(name="REPORTING_PLUGIN_TYPE")
    @Enumerated(value=EnumType.STRING)
    public ReportingPluginType getReportingPluginTypeOrNull() {
        return this.reportingPluginTypeOrNull;
    }

    public void setReportingPluginTypeOrNull(ReportingPluginType reportingPluginType) {
        this.reportingPluginTypeOrNull = reportingPluginType;
    }

    @NotNull(message="Data store can not be null.")
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="DATA_STORE_ID")
    private DataStorePE getDataStoreInternal() {
        return this.dataStore;
    }

    @Private
    void setDataStoreInternal(DataStorePE dataStore) {
        this.dataStore = dataStore;
    }

    @Transient
    public DataStorePE getDataStore() {
        return this.getDataStoreInternal();
    }

    public void setDataStore(DataStorePE dataStore) {
        assert (dataStore != null);
        dataStore.addService(this);
    }
}

