/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.shared.dto;

import ch.systemsx.cisd.openbis.generic.shared.dto.identifier.LocalExperimentIdentifier;
import ch.systemsx.cisd.openbis.generic.shared.dto.identifier.ProjectIdentifier;
import ch.systemsx.cisd.openbis.generic.shared.dto.identifier.SpaceIdentifier;
import java.io.Serializable;

public class ListSamplesByPropertyCriteria
implements Serializable {
    private static final long serialVersionUID = 32L;
    private final String samplePropertyCode;
    private final String samplePropertyValue;
    private final String spaceCode;
    private final LocalExperimentIdentifier experimentIdentifierOrNull;

    public ListSamplesByPropertyCriteria(String propertyCode, String propertyValue, String spaceCode, LocalExperimentIdentifier experimentIdentifierOrNull) {
        this.samplePropertyCode = propertyCode;
        this.samplePropertyValue = propertyValue;
        this.spaceCode = spaceCode;
        this.experimentIdentifierOrNull = experimentIdentifierOrNull;
    }

    public String getPropertyCode() {
        return this.samplePropertyCode;
    }

    public String getPropertyValue() {
        return this.samplePropertyValue;
    }

    public ProjectIdentifier getProjectIdentifier() {
        ProjectIdentifier projectIdentifier = new ProjectIdentifier(this.getSpaceIdentifier(), this.experimentIdentifierOrNull.getProjectCode());
        return projectIdentifier;
    }

    public SpaceIdentifier getSpaceIdentifier() {
        return new SpaceIdentifier(null, this.spaceCode);
    }

    public LocalExperimentIdentifier tryGetLocalExperimentIdentifier() {
        return this.experimentIdentifierOrNull;
    }

    public String toString() {
        String expDesc = this.experimentIdentifierOrNull == null ? "any experiment" : this.experimentIdentifierOrNull.toString();
        return String.format("Samples from the space '%s' with property '%s' set to '%s' in %s", this.spaceCode, this.samplePropertyCode, this.samplePropertyValue, expDesc);
    }

    public String getSpaceCode() {
        return this.spaceCode;
    }
}

