/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.shared.dto.identifier;

import ch.systemsx.cisd.common.exceptions.UserFailureException;
import ch.systemsx.cisd.common.utilities.ModifiedShortPrefixToStringStyle;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;

public abstract class AbstractIdentifierFactory {
    public static final String NO_GROUP_PREFIX = String.format("space identifier does not start with '%s'", Character.valueOf('/'));
    public static final String ILLEGAL_EMPTY_IDENTIFIER = "Illegal empty identifier";
    static final String ILLEGAL_IDENTIFIER_TEMPLATE = "Illegal identifier '%s': %s.";
    public static final String ILLEGAL_CHARACTERS = "contains illegal characters.";
    static final String ILLEGAL_CODE_CHARACTERS_TEMPLATE = "The code '%s' contains illegal characters.";
    static final String ILLEGAL_PATTERN_CHARACTERS_TEMPLATE = "The pattern '%s' contains illegal characters.";
    static final String IDENTIFIER_IS_INCOMPLETE = "identifier is incomplete";
    public static final String TOO_MANY_TOKENS = "too many tokens found";
    private static final String ALLOWED_CODE_CHARACTERS = "A-Z0-9_\\-\\.";
    private static final Pattern ALLOWED_CODE_REGEXP = Pattern.compile("^[A-Z0-9_\\-\\.]+$", 2);
    private static final Pattern ALLOWED_PATTERN_REGEXP = Pattern.compile("^[A-Z0-9_\\-\\.?*]+$", 2);
    protected static final String IDENTIFIER_SEPARARTOR_STRING = "/";
    private final String textToParse;

    protected AbstractIdentifierFactory(String textToParse) throws UserFailureException {
        assert (textToParse != null) : "Unspecified text to parse";
        this.textToParse = textToParse;
    }

    protected static final void assertValidPatternCharacters(String textOrNull) throws UserFailureException {
        AbstractIdentifierFactory.assertValidCharacters(textOrNull, ALLOWED_PATTERN_REGEXP, ILLEGAL_PATTERN_CHARACTERS_TEMPLATE);
    }

    protected static final String assertValidCode(String textOrNull) throws UserFailureException {
        AbstractIdentifierFactory.assertValidCharacters(textOrNull, ALLOWED_CODE_REGEXP, ILLEGAL_CODE_CHARACTERS_TEMPLATE);
        return textOrNull;
    }

    protected static final void assertValidCharacters(String textOrNull, Pattern pattern, String invalidPatternMsg) throws UserFailureException {
        if (textOrNull == null) {
            return;
        }
        AbstractIdentifierFactory.assertNotEmpty(textOrNull);
        if (!pattern.matcher(textOrNull).matches()) {
            throw UserFailureException.fromTemplate(invalidPatternMsg, textOrNull);
        }
    }

    private static final void assertNotEmpty(String text) throws UserFailureException {
        if (StringUtils.isEmpty((String)text)) {
            throw new UserFailureException(ILLEGAL_EMPTY_IDENTIFIER);
        }
    }

    protected static UserFailureException createTooManyTokensExcp(String text) {
        return UserFailureException.fromTemplate(ILLEGAL_IDENTIFIER_TEMPLATE, text, TOO_MANY_TOKENS);
    }

    protected static String tryAsDatabaseIdentifier(String text) {
        if (text.endsWith(":")) {
            String dbCode = text.substring(0, text.length() - 1);
            AbstractIdentifierFactory.assertValidCode(dbCode);
            return dbCode;
        }
        return null;
    }

    protected static UserFailureException createSlashMissingExcp(String text) {
        return UserFailureException.fromTemplate(ILLEGAL_IDENTIFIER_TEMPLATE, text, NO_GROUP_PREFIX);
    }

    protected final String getTextToParse() {
        return this.textToParse;
    }

    public final String toString() {
        return ToStringBuilder.reflectionToString((Object)this, (ToStringStyle)ModifiedShortPrefixToStringStyle.MODIFIED_SHORT_PREFIX_STYLE);
    }

    protected static String getDatabaseInstanceIdentifierSchema() {
        return "<database-instance-code>";
    }

    protected static class TokenLexer {
        private final String originalText;
        private int nextIx = 0;
        private final String[] tokens;

        public TokenLexer(String text) {
            AbstractIdentifierFactory.assertNotEmpty(text);
            this.tokens = text.split(AbstractIdentifierFactory.IDENTIFIER_SEPARARTOR_STRING);
            this.originalText = text;
            if (this.tokens.length == 0) {
                throw new UserFailureException(AbstractIdentifierFactory.ILLEGAL_EMPTY_IDENTIFIER);
            }
        }

        public void ensureNoTokensLeft() {
            if (this.hasNext()) {
                throw AbstractIdentifierFactory.createTooManyTokensExcp(this.originalText);
            }
        }

        public String peek() {
            return this.tokens[this.nextIx];
        }

        public boolean hasNext() {
            return this.nextIx < this.tokens.length;
        }

        public String next() {
            if (this.nextIx >= this.tokens.length) {
                throw UserFailureException.fromTemplate(AbstractIdentifierFactory.ILLEGAL_IDENTIFIER_TEMPLATE, this.originalText, AbstractIdentifierFactory.IDENTIFIER_IS_INCOMPLETE);
            }
            return this.tokens[this.nextIx++];
        }

        public String getOriginalText() {
            return this.originalText;
        }
    }
}

