/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.shared.translator;

import ch.systemsx.cisd.openbis.generic.shared.basic.dto.Space;
import ch.systemsx.cisd.openbis.generic.shared.dto.SpacePE;
import ch.systemsx.cisd.openbis.generic.shared.dto.identifier.IdentifierHelper;
import ch.systemsx.cisd.openbis.generic.shared.translator.DatabaseInstanceTranslator;
import ch.systemsx.cisd.openbis.generic.shared.translator.PersonTranslator;
import ch.systemsx.cisd.openbis.generic.shared.util.HibernateUtils;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class SpaceTranslator {
    private SpaceTranslator() {
    }

    public static final List<Space> translate(List<SpacePE> spaces) {
        ArrayList<Space> result = new ArrayList<Space>();
        for (SpacePE space : spaces) {
            result.add(SpaceTranslator.translate(space));
        }
        return result;
    }

    public static Space translate(SpacePE space) {
        if (space == null) {
            return null;
        }
        Space result = new Space();
        result.setId(HibernateUtils.getId(space));
        result.setCode(space.getCode());
        result.setDescription(space.getDescription());
        result.setInstance(DatabaseInstanceTranslator.translate(space.getDatabaseInstance()));
        result.setRegistrationDate(space.getRegistrationDate());
        result.setRegistrator(PersonTranslator.translate(space.getRegistrator()));
        result.setIdentifier(IdentifierHelper.createGroupIdentifier(space).toString());
        return result;
    }
}

