/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.common.collections;

import ch.systemsx.cisd.common.exceptions.UserFailureException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DAG<T, V extends Collection<T>> {
    private final Map<T, V> graph;

    public DAG(Map<T, V> graph) {
        this.graph = graph;
    }

    public Map<T, V> getNodes() {
        return this.graph;
    }

    private Collection<T> getSuccessors(T node) {
        return (Collection)this.graph.get(node);
    }

    public List<T> sortTopologically() {
        HashSet<T> nodesCopy = new HashSet<T>(this.graph.keySet());
        ArrayList<T> sorted = new ArrayList<T>();
        while (!nodesCopy.isEmpty()) {
            T nextNode = this.getNextNodeForTopologicalSort(nodesCopy);
            if (nextNode == null) {
                throw new UserFailureException("Graph cycle detected. Cannot execute topological sort.");
            }
            sorted.add(nextNode);
            nodesCopy.remove(nextNode);
        }
        return sorted;
    }

    private T getNextNodeForTopologicalSort(Collection<T> nodesCollection) {
        for (T node : nodesCollection) {
            Collection<T> successors = this.getSuccessors(node);
            boolean hasDependencies = false;
            if (successors != null) {
                for (T successor : successors) {
                    if (!nodesCollection.contains(successor)) continue;
                    hasDependencies = true;
                }
            }
            if (hasDependencies) continue;
            return node;
        }
        return null;
    }
}

