/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.common.concurrent;

import ch.systemsx.cisd.common.concurrent.IActivitySensor;
import ch.systemsx.cisd.common.logging.LogCategory;
import ch.systemsx.cisd.common.logging.LogFactory;
import java.util.Timer;
import java.util.TimerTask;
import org.apache.log4j.Logger;

public class InactivityMonitor {
    private static final Logger operationLog = LogFactory.getLogger(LogCategory.OPERATION, InactivityMonitor.class);
    private final IDescribingActivitySensor sensor;
    private final IInactivityObserver observer;
    private final Timer activityMonitoringTimer;
    private final long inactivityThresholdMillis;
    private final boolean stopAfterFirstEvent;

    public InactivityMonitor(IDescribingActivitySensor sensor, IInactivityObserver observer, long inactivityThresholdMillis, boolean stopAfterFirstEvent) {
        assert (sensor != null);
        assert (observer != null);
        assert (inactivityThresholdMillis > 0L);
        this.sensor = sensor;
        this.observer = observer;
        this.inactivityThresholdMillis = inactivityThresholdMillis;
        this.stopAfterFirstEvent = stopAfterFirstEvent;
        String currentThreadName = Thread.currentThread().getName();
        String threadNamePrefix = "main".equals(currentThreadName) ? "" : String.valueOf(currentThreadName) + " - ";
        this.activityMonitoringTimer = new Timer(String.valueOf(threadNamePrefix) + "Activity Monitor", true);
        InactivityMonitoringTimerTask inactivityMonitoringTimerTask = new InactivityMonitoringTimerTask();
        this.activityMonitoringTimer.schedule((TimerTask)inactivityMonitoringTimerTask, 0L, inactivityThresholdMillis / 2L);
    }

    public void stop() {
        this.activityMonitoringTimer.cancel();
    }

    public static interface IDescribingActivitySensor
    extends IActivitySensor {
        public String describeInactivity(long var1);
    }

    public static interface IInactivityObserver {
        public void update(long var1, String var3);
    }

    private final class InactivityMonitoringTimerTask
    extends TimerTask {
        private long timeOfLastActivity = System.currentTimeMillis();

        private InactivityMonitoringTimerTask() {
        }

        private long computePeriodOfInactivity(long now) {
            return now - this.timeOfLastActivity;
        }

        private void updateTimeOfActivity() {
            this.timeOfLastActivity = InactivityMonitor.this.sensor.getLastActivityMillisMoreRecentThan(InactivityMonitor.this.inactivityThresholdMillis);
        }

        private boolean isInactivityThresholdExceeded(long now) {
            return this.computePeriodOfInactivity(now) > InactivityMonitor.this.inactivityThresholdMillis;
        }

        public void run() {
            if (operationLog.isTraceEnabled()) {
                operationLog.trace((Object)"Start activity monitoring run.");
            }
            try {
                long now = System.currentTimeMillis();
                if (!this.isInactivityThresholdExceeded(now)) {
                    return;
                }
                try {
                    this.updateTimeOfActivity();
                    if (this.isInactivityThresholdExceeded(now)) {
                        InactivityMonitor.this.observer.update(this.computePeriodOfInactivity(now), InactivityMonitor.this.sensor.describeInactivity(now));
                        if (InactivityMonitor.this.stopAfterFirstEvent) {
                            InactivityMonitor.this.stop();
                        }
                    }
                }
                catch (Exception ex) {
                    operationLog.error((Object)"Exception when monitoring for activity.", (Throwable)ex);
                }
            }
            finally {
                if (operationLog.isTraceEnabled()) {
                    operationLog.trace((Object)"Finished activity monitoring run.");
                }
            }
        }
    }
}

