/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.common.filesystem;

import ch.systemsx.cisd.common.filesystem.FileUtilities;
import ch.systemsx.cisd.common.utilities.AbstractHashable;
import java.io.File;
import java.io.Serializable;

public class HostAwareFile
extends AbstractHashable
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final char HOST_FILE_SEP = ':';
    private final String hostOrNull;
    private final File path;
    private final String rsyncModuleOrNull;

    public HostAwareFile(File path) {
        this(null, path, null);
    }

    public HostAwareFile(String hostOrNull, File path, String rsyncModuleOrNull) {
        this.hostOrNull = hostOrNull;
        this.path = path;
        this.rsyncModuleOrNull = rsyncModuleOrNull;
    }

    public final String tryGetHost() {
        return this.hostOrNull;
    }

    public final File getFile() {
        return this.path;
    }

    public final String tryGetRsyncModule() {
        return this.rsyncModuleOrNull;
    }

    public final String getCanonicalPath() {
        if (this.tryGetHost() == null) {
            return FileUtilities.getCanonicalPath(this.getFile());
        }
        if (this.tryGetRsyncModule() == null) {
            return String.valueOf(this.tryGetHost()) + ':' + this.getFile();
        }
        return String.valueOf(this.tryGetHost()) + ':' + this.tryGetRsyncModule() + ':' + this.getFile();
    }
}

