/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.common.hdf5;

import ch.systemsx.cisd.base.exceptions.IOExceptionUnchecked;
import ch.systemsx.cisd.common.filesystem.FileUtilities;
import ch.systemsx.cisd.common.hdf5.HDF5Container;
import ch.systemsx.cisd.common.hdf5.IHDF5ContainerWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;

public class HierarchicalStructureDuplicatorFileToHDF5 {
    private final File file;
    private final String rootPath;
    private final IHDF5ContainerWriter writer;

    public static void makeDuplicate(File file, String rootPath, IHDF5ContainerWriter writer) {
        new HierarchicalStructureDuplicatorFileToHDF5(file, rootPath, writer).makeDuplicate();
    }

    private HierarchicalStructureDuplicatorFileToHDF5(File file, String rootPath, IHDF5ContainerWriter writer) {
        this.file = file;
        this.rootPath = rootPath;
        this.writer = writer;
    }

    private void makeDuplicate() {
        if (!this.file.exists()) {
            this.writer.close();
            throw new IllegalArgumentException("File does not exist " + this.file);
        }
        if (this.file.isFile()) {
            String name = this.file.getName();
            String hdf5Path = String.valueOf(this.rootPath) + name;
            this.mirrorDataSet(this.file, hdf5Path);
        } else {
            this.mirrorGroup(this.file, this.rootPath);
        }
    }

    private void mirrorGroup(File directory, String groupPath) {
        File[] files;
        File[] fileArray = files = directory.listFiles();
        int n = files.length;
        int n2 = 0;
        while (n2 < n) {
            File fileOrDirectory = fileArray[n2];
            String childPath = String.valueOf(groupPath) + fileOrDirectory.getName();
            if (fileOrDirectory.isDirectory()) {
                this.mirrorGroup(fileOrDirectory, String.valueOf(childPath) + "/");
            } else {
                this.mirrorDataSet(fileOrDirectory, childPath);
            }
            ++n2;
        }
    }

    private void mirrorDataSet(File normalFile, String hdf5Path) {
        if (FileUtilities.isSymbolicLink(normalFile)) {
            throw new IllegalArgumentException("Symbolic links are not supported for mirroring in a HDF5 container.");
        }
        FileInputStream istream = null;
        IOException e = null;
        try {
            try {
                istream = new FileInputStream(normalFile);
                this.writer.writeToHDF5Container(hdf5Path, istream, normalFile.length());
            }
            catch (IOException ex) {
                e = ex;
                throw new IOExceptionUnchecked(ex);
            }
        }
        finally {
            block12: {
                if (istream != null) {
                    try {
                        ((InputStream)istream).close();
                    }
                    catch (IOException ex) {
                        if (e != null) break block12;
                        throw new IOExceptionUnchecked(ex);
                    }
                }
            }
        }
    }

    public static class DuplicatorWriterClient
    implements HDF5Container.IHDF5WriterClient {
        private final File file;
        private final String rootPath;

        public DuplicatorWriterClient(File file) {
            this(file, "/");
        }

        public DuplicatorWriterClient(File file, String rootPath) {
            this.file = file;
            this.rootPath = rootPath;
        }

        public void runWithSimpleWriter(IHDF5ContainerWriter writer) {
            HierarchicalStructureDuplicatorFileToHDF5.makeDuplicate(this.file, this.rootPath, writer);
        }
    }
}

