/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.common.serviceconversation.client;

import ch.systemsx.cisd.common.serviceconversation.IServiceMessageTransport;
import ch.systemsx.cisd.common.serviceconversation.ServiceMessage;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;

class ClientResponseMessageQueue
implements IServiceMessageTransport {
    private int messageIdxLastSeen = -1;
    private final BlockingQueue<ServiceMessage> messageQueue = new LinkedBlockingQueue<ServiceMessage>();

    ClientResponseMessageQueue() {
    }

    ServiceMessage poll(int timeoutMillis) throws InterruptedException {
        return this.messageQueue.poll(timeoutMillis, TimeUnit.MILLISECONDS);
    }

    public void send(ServiceMessage message) {
        if (message.getMessageIdx() <= this.messageIdxLastSeen) {
            return;
        }
        this.messageIdxLastSeen = message.getMessageIdx();
        if (!message.hasPayload()) {
            this.messageQueue.clear();
        }
        this.messageQueue.add(message);
    }
}

