/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.dss.generic.shared.utils;

import ch.systemsx.cisd.common.exceptions.ConfigurationFailureException;
import ch.systemsx.cisd.common.exceptions.EnvironmentFailureException;
import ch.systemsx.cisd.common.logging.ISimpleLogger;
import ch.systemsx.cisd.common.logging.Log4jSimpleLogger;
import ch.systemsx.cisd.common.logging.LogCategory;
import ch.systemsx.cisd.common.logging.LogFactory;
import ch.systemsx.cisd.common.logging.LogLevel;
import ch.systemsx.cisd.common.utilities.PropertyParametersUtil;
import ch.systemsx.cisd.openbis.dss.generic.shared.Constants;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.CorePlugin;
import ch.systemsx.cisd.openbis.generic.shared.coreplugin.CorePluginScanner;
import java.io.File;
import java.io.FileInputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TreeSet;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CorePluginsInjector {
    static final String DELETE_KEY_WORD = "__DELETE__";
    private static final String UNALLOWED_PLUGIN_NAME_CHARACTERS = " ,=";
    public static final String CORE_PLUGINS_FOLDER_KEY = "core-plugins-folder";
    static final String DISABLED_CORE_PLUGINS_KEY = "disabled-core-plugins";
    static final String DISABLED_MARKER_FILE_NAME = "disabled";
    static final String PLUGIN_PROPERTIES_FILE_NAME = "plugin.properties";
    private static final ISimpleLogger DEFAULT_LOGGER = new Log4jSimpleLogger(LogFactory.getLogger(LogCategory.OPERATION, CorePluginsInjector.class));
    private final ISimpleLogger logger;
    private final Set<String> keysOfKeyLists;

    public CorePluginsInjector() {
        this(DEFAULT_LOGGER);
    }

    CorePluginsInjector(ISimpleLogger logger) {
        this.logger = logger;
        PluginType[] values = PluginType.values();
        this.keysOfKeyLists = new HashSet<String>();
        PluginType[] pluginTypeArray = values;
        int n = values.length;
        int n2 = 0;
        while (n2 < n) {
            PluginType type = pluginTypeArray[n2];
            String keyOfKeyListPropertyOrNull = type.getKeyOfKeyListPropertyOrNull();
            if (keyOfKeyListPropertyOrNull != null) {
                this.keysOfKeyLists.add(keyOfKeyListPropertyOrNull);
            }
            ++n2;
        }
    }

    void injectCorePlugins(Properties properties) {
        String corePluginsFolderPath = properties.getProperty(CORE_PLUGINS_FOLDER_KEY);
        if (corePluginsFolderPath == null) {
            return;
        }
        this.injectCorePlugins(properties, corePluginsFolderPath);
    }

    public void injectCorePlugins(Properties properties, String corePluginsFolderPath) {
        Set<String> disabledPlugins = this.getDisabledPlugins(properties);
        PluginKeyBundles pluginKeyBundles = new PluginKeyBundles(properties);
        HashSet<String> pluginNames = new HashSet<String>();
        pluginKeyBundles.addAndCheckUniquePluginNames(pluginNames);
        Map<PluginType, Map<String, DssCorePlugin>> plugins = this.scanForCorePlugins(corePluginsFolderPath, disabledPlugins, pluginNames);
        for (Map.Entry<PluginType, Map<String, DssCorePlugin>> entry : plugins.entrySet()) {
            PluginType pluginType = entry.getKey();
            Map<String, DssCorePlugin> map = entry.getValue();
            for (Map.Entry<String, DssCorePlugin> entry2 : map.entrySet()) {
                String pluginName = entry2.getKey();
                DssCorePlugin plugin = entry2.getValue();
                File definingFolder = plugin.getDefiningFolder();
                if (new File(definingFolder, DISABLED_MARKER_FILE_NAME).exists()) continue;
                Properties pluginProperties = this.getPluginProperties(definingFolder);
                if (pluginType.isUniquePluginNameRequired()) {
                    pluginKeyBundles.addPluginNameFor(pluginType, pluginName);
                    for (Map.Entry<Object, Object> keyValuePair : pluginProperties.entrySet()) {
                        String value = keyValuePair.getValue().toString();
                        this.injectProperty(properties, String.valueOf(pluginName) + "." + keyValuePair.getKey(), value);
                    }
                } else {
                    PluginKeyBundles miscPluginKeyBundles = new PluginKeyBundles(pluginProperties);
                    for (Map.Entry<Object, Object> keyValuePair : pluginProperties.entrySet()) {
                        String value = keyValuePair.getValue().toString();
                        String key = keyValuePair.getKey().toString();
                        if (this.keysOfKeyLists.contains(key)) continue;
                        this.injectProperty(properties, key, value);
                    }
                    pluginKeyBundles.add(miscPluginKeyBundles);
                }
                this.logger.log(LogLevel.INFO, "Plugin " + plugin + " added.");
            }
        }
        pluginKeyBundles.addOrReplaceKeyBundleIn(properties);
    }

    private void injectProperty(Properties properties, String key, String value) {
        String property = properties.getProperty(key);
        if (property != null && property.trim().equals(DELETE_KEY_WORD)) {
            properties.remove(key);
        } else {
            properties.setProperty(key, value);
        }
    }

    private Set<String> getDisabledPlugins(Properties properties) {
        HashSet<String> set = new HashSet<String>();
        String property = properties.getProperty(DISABLED_CORE_PLUGINS_KEY);
        if (StringUtils.isNotBlank((String)property)) {
            String[] splittedProperty;
            String[] stringArray = splittedProperty = property.split(",");
            int n = splittedProperty.length;
            int n2 = 0;
            while (n2 < n) {
                String term = stringArray[n2];
                set.add(term.trim());
                ++n2;
            }
        }
        return set;
    }

    private Map<PluginType, Map<String, DssCorePlugin>> scanForCorePlugins(String corePluginsFolderPath, Set<String> disabledPlugins, Set<String> pluginNames) {
        LinkedHashMap<PluginType, Map<String, DssCorePlugin>> typeToPluginsMap = new LinkedHashMap<PluginType, Map<String, DssCorePlugin>>();
        CorePluginScanner scanner = new CorePluginScanner(corePluginsFolderPath, CorePluginScanner.ScannerType.DSS, this.logger);
        List<CorePlugin> plugins = scanner.scanForPlugins();
        for (CorePlugin corePlugin : plugins) {
            PluginType[] values;
            String technology = corePlugin.getName();
            File dssFolder = new File(corePluginsFolderPath, String.valueOf(technology) + "/" + corePlugin.getVersion() + "/" + CorePluginScanner.ScannerType.DSS.getSubFolderName());
            PluginType[] pluginTypeArray = values = PluginType.values();
            int n = values.length;
            int n2 = 0;
            while (n2 < n) {
                PluginType pluginType = pluginTypeArray[n2];
                File file = new File(dssFolder, pluginType.getSubFolderName());
                if (file.isDirectory()) {
                    File[] pluginFolders;
                    File[] fileArray = pluginFolders = file.listFiles(new FilenameFilter(){

                        public boolean accept(File dir, String name) {
                            return !name.startsWith(".");
                        }
                    });
                    int n3 = pluginFolders.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        File pluginFolder = fileArray[n4];
                        String pluginName = pluginFolder.getName();
                        this.assertAndAddPluginName(pluginName, pluginNames, pluginType);
                        DssCorePlugin plugin = new DssCorePlugin(technology, pluginType, pluginFolder);
                        String fullPluginName = plugin.getName();
                        if (!this.isDisabled(disabledPlugins, fullPluginName)) {
                            LinkedHashMap<String, DssCorePlugin> map = (LinkedHashMap<String, DssCorePlugin>)typeToPluginsMap.get((Object)pluginType);
                            if (map == null) {
                                map = new LinkedHashMap<String, DssCorePlugin>();
                                typeToPluginsMap.put(pluginType, map);
                            }
                            map.put(pluginName, plugin);
                        }
                        ++n4;
                    }
                }
                ++n2;
            }
        }
        return typeToPluginsMap;
    }

    private boolean isDisabled(Set<String> disabledPlugins, String fullPluginName) {
        for (String disabledPlugin : disabledPlugins) {
            if (!fullPluginName.startsWith(disabledPlugin)) continue;
            return true;
        }
        return false;
    }

    private void assertAndAddPluginName(String pluginName, Set<String> pluginNames, PluginType pluginType) {
        int i = 0;
        while (i < UNALLOWED_PLUGIN_NAME_CHARACTERS.length()) {
            char c = UNALLOWED_PLUGIN_NAME_CHARACTERS.charAt(i);
            if (pluginName.contains(Character.toString(c))) {
                throw new EnvironmentFailureException("Plugin name contains '" + c + "': " + pluginName);
            }
            ++i;
        }
        if (pluginType.isUniquePluginNameRequired()) {
            if (pluginNames.contains(pluginName)) {
                throw new ConfigurationFailureException("There is already a plugin named '" + pluginName + "'.");
            }
            pluginNames.add(pluginName);
        }
    }

    private Properties getPluginProperties(File definingFolder) {
        File pluginPropertiesFile = new File(definingFolder, PLUGIN_PROPERTIES_FILE_NAME);
        if (!pluginPropertiesFile.exists()) {
            throw new EnvironmentFailureException("Missing plugin properties: " + pluginPropertiesFile);
        }
        File[] scripts = definingFolder.listFiles(new FilenameFilter(){

            public boolean accept(File dir, String name) {
                return !name.equals(CorePluginsInjector.PLUGIN_PROPERTIES_FILE_NAME);
            }
        });
        Properties pluginProperties = this.loadProperties(pluginPropertiesFile);
        for (Map.Entry<Object, Object> keyValuePair : pluginProperties.entrySet()) {
            String value = keyValuePair.getValue().toString();
            File[] fileArray = scripts;
            int n = scripts.length;
            int n2 = 0;
            while (n2 < n) {
                File script = fileArray[n2];
                value = value.replace(script.getName(), script.getPath());
                ++n2;
            }
            keyValuePair.setValue(value);
        }
        return pluginProperties;
    }

    private Properties loadProperties(File pluginPropertiesFile) {
        Properties pluginProperties = new Properties();
        FileInputStream inStream = null;
        try {
            try {
                inStream = new FileInputStream(pluginPropertiesFile);
                pluginProperties.load(inStream);
            }
            catch (IOException ex) {
                throw new EnvironmentFailureException("Couldn't load plugin properties '" + pluginPropertiesFile + "'.", ex);
            }
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(inStream);
            throw throwable;
        }
        IOUtils.closeQuietly((InputStream)inStream);
        return pluginProperties;
    }

    private static final class DssCorePlugin {
        private final String name;
        private final File definingFolder;

        DssCorePlugin(String technology, PluginType pluginType, File definingFolder) {
            this.name = String.valueOf(technology) + ":" + pluginType.getSubFolderName() + ":" + definingFolder.getName();
            this.definingFolder = definingFolder;
            if (!definingFolder.isDirectory()) {
                throw new EnvironmentFailureException("Is not a directory: " + definingFolder);
            }
        }

        String getName() {
            return this.name;
        }

        File getDefiningFolder() {
            return this.definingFolder;
        }

        public String toString() {
            return String.valueOf(this.name) + " [" + this.definingFolder + "]";
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class KeyBundle {
        private final String key;
        private final Set<String> keys;

        KeyBundle(Properties properties, String key) {
            this.key = key;
            this.keys = new TreeSet<String>();
            String keysAsString = properties.getProperty(key);
            if (keysAsString != null) {
                String[] keyArray = PropertyParametersUtil.parseItemisedProperty(keysAsString, key);
                this.keys.addAll(Arrays.asList(keyArray));
            }
        }

        public void addKey(String newKey) {
            this.keys.add(newKey);
        }

        void addAndCheckUniquePluginNames(Set<String> pluginNames) {
            for (String keyPrefix : this.keys) {
                if (pluginNames.contains(keyPrefix)) {
                    throw new ConfigurationFailureException("Property key '" + keyPrefix + "' for key list '" + this.key + "' is already defined in some other key list.");
                }
                pluginNames.add(keyPrefix);
            }
        }

        void addOrReplaceKeyBundleIn(Properties properties) {
            if (!this.keys.isEmpty()) {
                StringBuilder builder = new StringBuilder();
                for (String k : this.keys) {
                    if (builder.length() > 0) {
                        builder.append(", ");
                    }
                    builder.append(k);
                }
                properties.setProperty(this.key, builder.toString());
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class PluginKeyBundles {
        private Map<PluginType, KeyBundle> keyBundles = new LinkedHashMap<PluginType, KeyBundle>();

        PluginKeyBundles(Properties properties) {
            PluginType[] values;
            PluginType[] pluginTypeArray = values = PluginType.values();
            int n = values.length;
            int n2 = 0;
            while (n2 < n) {
                PluginType pluginType = pluginTypeArray[n2];
                String key = pluginType.getKeyOfKeyListPropertyOrNull();
                if (key != null) {
                    this.keyBundles.put(pluginType, new KeyBundle(properties, key));
                }
                ++n2;
            }
        }

        public void add(PluginKeyBundles bundles) {
            Set<Map.Entry<PluginType, KeyBundle>> entrySet = this.keyBundles.entrySet();
            for (Map.Entry<PluginType, KeyBundle> entry : entrySet) {
                PluginType pluginType = entry.getKey();
                KeyBundle keyBundle = bundles.keyBundles.get((Object)pluginType);
                if (keyBundle == null) continue;
                entry.getValue().keys.addAll(keyBundle.keys);
            }
        }

        void addAndCheckUniquePluginNames(Set<String> pluginNames) {
            for (KeyBundle keyBundle : this.keyBundles.values()) {
                keyBundle.addAndCheckUniquePluginNames(pluginNames);
            }
        }

        void addPluginNameFor(PluginType pluginType, String pluginName) {
            KeyBundle keyBundle = this.keyBundles.get((Object)pluginType);
            if (keyBundle != null) {
                keyBundle.addKey(pluginName);
            }
        }

        void addOrReplaceKeyBundleIn(Properties properties) {
            for (KeyBundle bundle : this.keyBundles.values()) {
                bundle.addOrReplaceKeyBundleIn(properties);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum PluginType {
        DROP_BOXES("drop-boxes", "inputs"),
        DATA_SOURCES("data-sources", "data-sources"),
        SERVICES("services", "plugin-services"),
        IMAGE_OVERVIEW_PLUGINS("image-overview-plugins", Constants.OVERVIEW_PLUGINS_SERVICES_LIST_KEY),
        REPORTING_PLUGINS("reporting-plugins", "reporting-plugins"),
        PROCESSING_PLUGINS("processing-plugins", "processing-plugins"),
        MAINTENANCE_TASKS("maintenance-tasks", "maintenance-plugins"),
        MISCELLANEOUS("miscellaneous", null);

        private final String subFolderName;
        private final String keyOfKeyListPropertyOrNull;

        private PluginType(String subFolderName, String keyOfKeyListPropertyOrNull) {
            this.subFolderName = subFolderName;
            this.keyOfKeyListPropertyOrNull = keyOfKeyListPropertyOrNull;
        }

        public String getSubFolderName() {
            return this.subFolderName;
        }

        public String getKeyOfKeyListPropertyOrNull() {
            return this.keyOfKeyListPropertyOrNull;
        }

        public boolean isUniquePluginNameRequired() {
            return this.keyOfKeyListPropertyOrNull != null;
        }
    }
}

