/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.shared;

import ch.systemsx.cisd.common.exceptions.UserFailureException;
import ch.systemsx.cisd.openbis.generic.shared.DatabaseCreateOrDeleteModification;
import ch.systemsx.cisd.openbis.generic.shared.DatabaseUpdateModification;
import ch.systemsx.cisd.openbis.generic.shared.IServer;
import ch.systemsx.cisd.openbis.generic.shared.authorization.annotation.AuthorizationGuard;
import ch.systemsx.cisd.openbis.generic.shared.authorization.annotation.Capability;
import ch.systemsx.cisd.openbis.generic.shared.authorization.annotation.ReturnValueFilter;
import ch.systemsx.cisd.openbis.generic.shared.authorization.annotation.RolesAllowed;
import ch.systemsx.cisd.openbis.generic.shared.authorization.predicate.AbstractExpressionPredicate;
import ch.systemsx.cisd.openbis.generic.shared.authorization.predicate.AbstractTechIdPredicate;
import ch.systemsx.cisd.openbis.generic.shared.authorization.predicate.DataSetCodeCollectionPredicate;
import ch.systemsx.cisd.openbis.generic.shared.authorization.predicate.DataSetCodePredicate;
import ch.systemsx.cisd.openbis.generic.shared.authorization.predicate.DataSetUpdatesPredicate;
import ch.systemsx.cisd.openbis.generic.shared.authorization.predicate.DeletionTechIdCollectionPredicate;
import ch.systemsx.cisd.openbis.generic.shared.authorization.predicate.ExperimentUpdatesPredicate;
import ch.systemsx.cisd.openbis.generic.shared.authorization.predicate.ListSampleCriteriaPredicate;
import ch.systemsx.cisd.openbis.generic.shared.authorization.predicate.ProjectUpdatesPredicate;
import ch.systemsx.cisd.openbis.generic.shared.authorization.predicate.RevertDeletionPredicate;
import ch.systemsx.cisd.openbis.generic.shared.authorization.predicate.SampleTechIdCollectionPredicate;
import ch.systemsx.cisd.openbis.generic.shared.authorization.predicate.SampleTechIdPredicate;
import ch.systemsx.cisd.openbis.generic.shared.authorization.predicate.SampleUpdatesPredicate;
import ch.systemsx.cisd.openbis.generic.shared.authorization.predicate.SpaceIdentifierPredicate;
import ch.systemsx.cisd.openbis.generic.shared.authorization.validator.DeletionValidator;
import ch.systemsx.cisd.openbis.generic.shared.authorization.validator.ExpressionValidator;
import ch.systemsx.cisd.openbis.generic.shared.authorization.validator.ExternalDataValidator;
import ch.systemsx.cisd.openbis.generic.shared.authorization.validator.MatchingEntityValidator;
import ch.systemsx.cisd.openbis.generic.shared.authorization.validator.ProjectValidator;
import ch.systemsx.cisd.openbis.generic.shared.authorization.validator.SampleValidator;
import ch.systemsx.cisd.openbis.generic.shared.authorization.validator.SpaceValidator;
import ch.systemsx.cisd.openbis.generic.shared.basic.IEntityInformationHolderWithPermId;
import ch.systemsx.cisd.openbis.generic.shared.basic.TechId;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.AbstractType;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.Attachment;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.AuthorizationGroup;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.AuthorizationGroupUpdates;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.BasicEntityDescription;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.BatchOperationKind;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.DataSetRelatedEntities;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.DataSetRelationshipRole;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.DataSetType;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.DataSetUpdateResult;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.DataStoreServiceKind;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.DataType;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.DatabaseModificationKind;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.DatastoreServiceDescription;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.Deletion;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.DeletionType;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.DetailedSearchCriteria;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.DynamicPropertyEvaluationInfo;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.EntityKind;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.EntityType;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.EntityTypePropertyType;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.Experiment;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.ExperimentType;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.ExperimentUpdateResult;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.ExternalData;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.FileFormatType;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.Grantee;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.GridCustomColumn;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.GridCustomFilter;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.IEntityProperty;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.IExpressionUpdates;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.IPropertyTypeUpdates;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.IScriptUpdates;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.ISpaceUpdates;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.IVocabularyTermUpdates;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.IVocabularyUpdates;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.LastModificationState;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.LinkModel;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.ListMaterialCriteria;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.ListSampleCriteria;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.MatchingEntity;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.Material;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.MaterialIdentifier;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.MaterialType;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.NewAttachment;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.NewAuthorizationGroup;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.NewColumnOrFilter;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.NewETPTAssignment;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.NewVocabulary;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.Person;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.Project;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.PropertyType;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.PropertyUpdates;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.RoleAssignment;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.RoleWithHierarchy;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.Sample;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.SampleParentWithDerived;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.SampleType;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.SampleUpdateResult;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.Script;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.ScriptType;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.Space;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.TableModel;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.Vocabulary;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.VocabularyTerm;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.VocabularyTermReplacement;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.api.IManagedProperty;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.api.IManagedUiAction;
import ch.systemsx.cisd.openbis.generic.shared.dto.DataSetUpdatesDTO;
import ch.systemsx.cisd.openbis.generic.shared.dto.DataSetUploadContext;
import ch.systemsx.cisd.openbis.generic.shared.dto.ExperimentUpdatesDTO;
import ch.systemsx.cisd.openbis.generic.shared.dto.ProjectUpdatesDTO;
import ch.systemsx.cisd.openbis.generic.shared.dto.SampleUpdatesDTO;
import ch.systemsx.cisd.openbis.generic.shared.dto.SearchableEntity;
import ch.systemsx.cisd.openbis.generic.shared.dto.VocabularyTermWithStats;
import ch.systemsx.cisd.openbis.generic.shared.dto.identifier.DatabaseInstanceIdentifier;
import ch.systemsx.cisd.openbis.generic.shared.dto.identifier.ExperimentIdentifier;
import ch.systemsx.cisd.openbis.generic.shared.dto.identifier.ProjectIdentifier;
import ch.systemsx.cisd.openbis.generic.shared.dto.identifier.SpaceIdentifier;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Set;
import org.springframework.transaction.annotation.Transactional;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public interface ICommonServer
extends IServer {
    @Transactional(readOnly=true)
    @RolesAllowed(value={RoleWithHierarchy.SPACE_OBSERVER})
    public void keepSessionAlive(String var1);

    @Transactional(readOnly=true)
    @RolesAllowed(value={RoleWithHierarchy.SPACE_OBSERVER})
    public List<Script> listScripts(String var1, ScriptType var2, EntityKind var3);

    @Transactional(readOnly=true)
    @RolesAllowed(value={RoleWithHierarchy.SPACE_OBSERVER})
    @ReturnValueFilter(validatorClass=SpaceValidator.class)
    public List<Space> listSpaces(String var1, DatabaseInstanceIdentifier var2);

    @Transactional
    @RolesAllowed(value={RoleWithHierarchy.INSTANCE_ADMIN})
    @DatabaseCreateOrDeleteModification(value={DatabaseModificationKind.ObjectKind.SPACE})
    public void registerSpace(String var1, String var2, String var3);

    @Transactional
    @RolesAllowed(value={RoleWithHierarchy.INSTANCE_ADMIN})
    @DatabaseUpdateModification(value={DatabaseModificationKind.ObjectKind.SCRIPT})
    public void updateScript(String var1, IScriptUpdates var2);

    @Transactional
    @RolesAllowed(value={RoleWithHierarchy.INSTANCE_ADMIN})
    @DatabaseUpdateModification(value={DatabaseModificationKind.ObjectKind.SPACE})
    public void updateSpace(String var1, ISpaceUpdates var2);

    @Transactional
    @RolesAllowed(value={RoleWithHierarchy.INSTANCE_ADMIN})
    @DatabaseCreateOrDeleteModification(value={DatabaseModificationKind.ObjectKind.AUTHORIZATION_GROUP})
    public void registerAuthorizationGroup(String var1, NewAuthorizationGroup var2);

    @Transactional
    @RolesAllowed(value={RoleWithHierarchy.INSTANCE_ADMIN})
    @DatabaseCreateOrDeleteModification(value={DatabaseModificationKind.ObjectKind.SCRIPT})
    public void registerScript(String var1, Script var2);

    @Transactional
    @RolesAllowed(value={RoleWithHierarchy.INSTANCE_ADMIN})
    @DatabaseCreateOrDeleteModification(value={DatabaseModificationKind.ObjectKind.AUTHORIZATION_GROUP})
    public void deleteAuthorizationGroups(String var1, List<TechId> var2, String var3);

    @Transactional(readOnly=true)
    @RolesAllowed(value={RoleWithHierarchy.INSTANCE_ADMIN})
    public List<Person> listPersons(String var1);

    @Transactional(readOnly=true)
    @RolesAllowed(value={RoleWithHierarchy.SPACE_OBSERVER})
    @ReturnValueFilter(validatorClass=ProjectValidator.class)
    public List<Project> listProjects(String var1);

    @Transactional
    @RolesAllowed(value={RoleWithHierarchy.INSTANCE_ADMIN})
    @DatabaseCreateOrDeleteModification(value={DatabaseModificationKind.ObjectKind.PERSON})
    public void registerPerson(String var1, String var2);

    @Transactional(readOnly=true)
    @RolesAllowed(value={RoleWithHierarchy.SPACE_ADMIN})
    public List<RoleAssignment> listRoleAssignments(String var1);

    @Transactional
    @RolesAllowed(value={RoleWithHierarchy.SPACE_ADMIN})
    @DatabaseCreateOrDeleteModification(value={DatabaseModificationKind.ObjectKind.ROLE_ASSIGNMENT})
    public void registerSpaceRole(String var1, RoleWithHierarchy.RoleCode var2, @AuthorizationGuard(guardClass=SpaceIdentifierPredicate.class) SpaceIdentifier var3, Grantee var4);

    @Transactional
    @RolesAllowed(value={RoleWithHierarchy.INSTANCE_ADMIN})
    @DatabaseCreateOrDeleteModification(value={DatabaseModificationKind.ObjectKind.ROLE_ASSIGNMENT})
    public void registerInstanceRole(String var1, RoleWithHierarchy.RoleCode var2, Grantee var3);

    @Transactional
    @RolesAllowed(value={RoleWithHierarchy.SPACE_ADMIN})
    @DatabaseCreateOrDeleteModification(value={DatabaseModificationKind.ObjectKind.ROLE_ASSIGNMENT})
    public void deleteSpaceRole(String var1, RoleWithHierarchy.RoleCode var2, @AuthorizationGuard(guardClass=SpaceIdentifierPredicate.class) SpaceIdentifier var3, Grantee var4);

    @Transactional
    @RolesAllowed(value={RoleWithHierarchy.INSTANCE_ADMIN})
    @DatabaseCreateOrDeleteModification(value={DatabaseModificationKind.ObjectKind.ROLE_ASSIGNMENT})
    public void deleteInstanceRole(String var1, RoleWithHierarchy.RoleCode var2, Grantee var3);

    @Transactional(readOnly=true)
    @RolesAllowed(value={RoleWithHierarchy.SPACE_OBSERVER})
    public List<SampleType> listSampleTypes(String var1);

    @Transactional(readOnly=true)
    @RolesAllowed(value={RoleWithHierarchy.SPACE_OBSERVER})
    @ReturnValueFilter(validatorClass=SampleValidator.class)
    public List<Sample> listSamples(String var1, @AuthorizationGuard(guardClass=ListSampleCriteriaPredicate.class) ListSampleCriteria var2);

    @Transactional(readOnly=true)
    @RolesAllowed(value={RoleWithHierarchy.SPACE_OBSERVER})
    public List<Experiment> listExperiments(String var1, ExperimentType var2, @AuthorizationGuard(guardClass=SpaceIdentifierPredicate.class) ProjectIdentifier var3);

    @Transactional(readOnly=true)
    @RolesAllowed(value={RoleWithHierarchy.SPACE_OBSERVER})
    public List<Experiment> listExperimentsHavingDataSets(String var1, ExperimentType var2, @AuthorizationGuard(guardClass=SpaceIdentifierPredicate.class) ProjectIdentifier var3);

    @Transactional(readOnly=true)
    @RolesAllowed(value={RoleWithHierarchy.SPACE_OBSERVER})
    public List<Experiment> listExperimentsHavingSamples(String var1, ExperimentType var2, @AuthorizationGuard(guardClass=SpaceIdentifierPredicate.class) ProjectIdentifier var3);

    @Transactional(readOnly=true)
    @RolesAllowed(value={RoleWithHierarchy.SPACE_OBSERVER})
    public List<Experiment> listExperiments(String var1, ExperimentType var2, @AuthorizationGuard(guardClass=SpaceIdentifierPredicate.class) SpaceIdentifier var3);

    @Transactional(readOnly=true)
    @RolesAllowed(value={RoleWithHierarchy.SPACE_OBSERVER})
    public List<Experiment> listExperiments(String var1, @AuthorizationGuard(guardClass=SpaceIdentifierPredicate.class) List<ExperimentIdentifier> var2);

    @Transactional(readOnly=true)
    @RolesAllowed(value={RoleWithHierarchy.SPACE_OBSERVER})
    public List<ExternalData> listSampleExternalData(String var1, @AuthorizationGuard(guardClass=SampleTechIdPredicate.class) TechId var2, boolean var3);

    @Transactional(readOnly=true)
    @RolesAllowed(value={RoleWithHierarchy.SPACE_OBSERVER})
    public List<ExternalData> listExperimentExternalData(String var1, @AuthorizationGuard(guardClass=AbstractTechIdPredicate.ExperimentTechIdPredicate.class) TechId var2, boolean var3);

    @Transactional(readOnly=true)
    @RolesAllowed(value={RoleWithHierarchy.SPACE_OBSERVER})
    public List<ExternalData> listDataSetRelationships(String var1, @AuthorizationGuard(guardClass=AbstractTechIdPredicate.DataSetTechIdPredicate.class) TechId var2, DataSetRelationshipRole var3);

    @Transactional(readOnly=true)
    @RolesAllowed(value={RoleWithHierarchy.SPACE_OBSERVER})
    @ReturnValueFilter(validatorClass=MatchingEntityValidator.class)
    public List<MatchingEntity> listMatchingEntities(String var1, SearchableEntity[] var2, String var3, boolean var4, int var5);

    @Transactional(readOnly=true)
    @RolesAllowed(value={RoleWithHierarchy.SPACE_OBSERVER})
    public List<ExperimentType> listExperimentTypes(String var1);

    @Transactional(readOnly=true)
    @RolesAllowed(value={RoleWithHierarchy.SPACE_OBSERVER})
    public List<PropertyType> listPropertyTypes(String var1, boolean var2);

    @Transactional(readOnly=true)
    @RolesAllowed(value={RoleWithHierarchy.SPACE_OBSERVER})
    public List<EntityTypePropertyType<?>> listEntityTypePropertyTypes(String var1);

    @Transactional(readOnly=true)
    @RolesAllowed(value={RoleWithHierarchy.SPACE_OBSERVER})
    public List<DataType> listDataTypes(String var1);

    @Transactional(readOnly=true)
    @RolesAllowed(value={RoleWithHierarchy.SPACE_OBSERVER})
    public List<FileFormatType> listFileFormatTypes(String var1);

    @Transactional(readOnly=true)
    @RolesAllowed(value={RoleWithHierarchy.SPACE_OBSERVER})
    public List<Vocabulary> listVocabularies(String var1, boolean var2, boolean var3);

    @Transactional
    @RolesAllowed(value={RoleWithHierarchy.INSTANCE_ADMIN})
    @DatabaseCreateOrDeleteModification(value={DatabaseModificationKind.ObjectKind.PROPERTY_TYPE})
    public void registerPropertyType(String var1, PropertyType var2);

    @Transactional
    @RolesAllowed(value={RoleWithHierarchy.INSTANCE_ADMIN})
    @DatabaseUpdateModification(value={DatabaseModificationKind.ObjectKind.PROPERTY_TYPE})
    public void updatePropertyType(String var1, IPropertyTypeUpdates var2);

    @Transactional
    @RolesAllowed(value={RoleWithHierarchy.INSTANCE_ADMIN})
    @DatabaseCreateOrDeleteModification(value={DatabaseModificationKind.ObjectKind.PROPERTY_TYPE})
    public void deletePropertyTypes(String var1, List<TechId> var2, String var3);

    @Transactional
    @RolesAllowed(value={RoleWithHierarchy.INSTANCE_ADMIN})
    @DatabaseCreateOrDeleteModification(value={DatabaseModificationKind.ObjectKind.PROPERTY_TYPE_ASSIGNMENT})
    public String assignPropertyType(String var1, NewETPTAssignment var2);

    @Transactional
    @RolesAllowed(value={RoleWithHierarchy.INSTANCE_ADMIN})
    @DatabaseUpdateModification(value={DatabaseModificationKind.ObjectKind.PROPERTY_TYPE_ASSIGNMENT})
    public void updatePropertyTypeAssignment(String var1, NewETPTAssignment var2);

    @Transactional
    @RolesAllowed(value={RoleWithHierarchy.INSTANCE_ADMIN})
    @DatabaseCreateOrDeleteModification(value={DatabaseModificationKind.ObjectKind.PROPERTY_TYPE_ASSIGNMENT})
    public void unassignPropertyType(String var1, EntityKind var2, String var3, String var4);

    @Transactional(readOnly=true)
    @RolesAllowed(value={RoleWithHierarchy.SPACE_OBSERVER})
    public int countPropertyTypedEntities(String var1, EntityKind var2, String var3, String var4);

    @Transactional
    @RolesAllowed(value={RoleWithHierarchy.INSTANCE_ADMIN})
    @DatabaseCreateOrDeleteModification(value={DatabaseModificationKind.ObjectKind.VOCABULARY})
    @Capability(value="REGISTER_VOCABULARY")
    public void registerVocabulary(String var1, NewVocabulary var2);

    @Transactional
    @RolesAllowed(value={RoleWithHierarchy.INSTANCE_ADMIN})
    @DatabaseUpdateModification(value={DatabaseModificationKind.ObjectKind.VOCABULARY})
    @Capability(value="WRITE_VOCABULARY")
    public void updateVocabulary(String var1, IVocabularyUpdates var2);

    @Transactional
    @RolesAllowed(value={RoleWithHierarchy.INSTANCE_ADMIN})
    @DatabaseCreateOrDeleteModification(value={DatabaseModificationKind.ObjectKind.VOCABULARY})
    @Capability(value="DELETE_VOCABULARY")
    public void deleteVocabularies(String var1, List<TechId> var2, String var3);

    @Transactional
    @RolesAllowed(value={RoleWithHierarchy.SPACE_POWER_USER})
    @DatabaseCreateOrDeleteModification(value={DatabaseModificationKind.ObjectKind.PROJECT})
    @Capability(value="DELETE_PROJECT")
    public void deleteProjects(String var1, @AuthorizationGuard(guardClass=AbstractTechIdPredicate.ProjectTechIdPredicate.class) List<TechId> var2, String var3);

    @Transactional
    @RolesAllowed(value={RoleWithHierarchy.INSTANCE_ADMIN})
    @DatabaseCreateOrDeleteModification(value={DatabaseModificationKind.ObjectKind.SPACE})
    public void deleteSpaces(String var1, @AuthorizationGuard(guardClass=AbstractTechIdPredicate.SpaceTechIdPredicate.class) List<TechId> var2, String var3);

    @Transactional
    @RolesAllowed(value={RoleWithHierarchy.INSTANCE_ADMIN})
    @DatabaseCreateOrDeleteModification(value={DatabaseModificationKind.ObjectKind.SCRIPT})
    public void deleteScripts(String var1, List<TechId> var2);

    @Transactional
    @RolesAllowed(value={RoleWithHierarchy.SPACE_POWER_USER})
    @DatabaseCreateOrDeleteModification(value={DatabaseModificationKind.ObjectKind.VOCABULARY_TERM})
    @Capability(value="WRITE_VOCABULARY_TERM")
    public void addVocabularyTerms(String var1, TechId var2, List<String> var3, Long var4);

    @Transactional
    @RolesAllowed(value={RoleWithHierarchy.SPACE_USER})
    @DatabaseCreateOrDeleteModification(value={DatabaseModificationKind.ObjectKind.VOCABULARY_TERM})
    @Capability(value="WRITE_UNOFFICIAL_VOCABULARY_TERM")
    public void addUnofficialVocabularyTerm(String var1, TechId var2, String var3, String var4, String var5, Long var6);

    @Transactional
    @RolesAllowed(value={RoleWithHierarchy.SPACE_POWER_USER})
    @DatabaseUpdateModification(value={DatabaseModificationKind.ObjectKind.VOCABULARY_TERM})
    @Capability(value="WRITE_VOCABULARY_TERM")
    public void updateVocabularyTerm(String var1, IVocabularyTermUpdates var2);

    @Transactional
    @RolesAllowed(value={RoleWithHierarchy.SPACE_POWER_USER})
    @DatabaseCreateOrDeleteModification(value={DatabaseModificationKind.ObjectKind.VOCABULARY_TERM})
    @Capability(value="WRITE_VOCABULARY_TERM")
    public void deleteVocabularyTerms(String var1, TechId var2, List<VocabularyTerm> var3, List<VocabularyTermReplacement> var4);

    @Transactional
    @RolesAllowed(value={RoleWithHierarchy.SPACE_POWER_USER})
    @DatabaseUpdateModification(value={DatabaseModificationKind.ObjectKind.VOCABULARY_TERM})
    @Capability(value="WRITE_VOCABULARY")
    public void makeVocabularyTermsOfficial(String var1, TechId var2, List<VocabularyTerm> var3);

    @Transactional
    @RolesAllowed(value={RoleWithHierarchy.SPACE_POWER_USER})
    @DatabaseCreateOrDeleteModification(value={DatabaseModificationKind.ObjectKind.PROJECT})
    @Capability(value="REGISTER_PROJECT")
    public void registerProject(String var1, @AuthorizationGuard(guardClass=SpaceIdentifierPredicate.class) ProjectIdentifier var2, String var3, String var4, Collection<NewAttachment> var5);

    @Transactional(readOnly=true)
    @RolesAllowed(value={RoleWithHierarchy.SPACE_OBSERVER})
    @ReturnValueFilter(validatorClass=ExternalDataValidator.class)
    public List<ExternalData> searchForDataSets(String var1, DetailedSearchCriteria var2);

    @Transactional(readOnly=true)
    @RolesAllowed(value={RoleWithHierarchy.SPACE_OBSERVER})
    public ExternalData getDataSetInfo(String var1, @AuthorizationGuard(guardClass=AbstractTechIdPredicate.DataSetTechIdPredicate.class) TechId var2);

    @Transactional
    @RolesAllowed(value={RoleWithHierarchy.SPACE_POWER_USER})
    @DatabaseUpdateModification(value={DatabaseModificationKind.ObjectKind.DATA_SET})
    @Capability(value="WRITE_DATASET")
    public DataSetUpdateResult updateDataSet(String var1, @AuthorizationGuard(guardClass=DataSetUpdatesPredicate.class) DataSetUpdatesDTO var2);

    @Transactional(readOnly=true)
    @RolesAllowed(value={RoleWithHierarchy.SPACE_OBSERVER})
    @ReturnValueFilter(validatorClass=SampleValidator.class)
    public List<Sample> searchForSamples(String var1, DetailedSearchCriteria var2);

    @Transactional(readOnly=true)
    @RolesAllowed(value={RoleWithHierarchy.SPACE_OBSERVER})
    @ReturnValueFilter(validatorClass=ExternalDataValidator.class)
    public List<ExternalData> listRelatedDataSets(String var1, DataSetRelatedEntities var2, boolean var3);

    @Transactional(readOnly=true)
    @RolesAllowed(value={RoleWithHierarchy.SPACE_OBSERVER})
    public List<MaterialType> listMaterialTypes(String var1);

    @Transactional(readOnly=true)
    @RolesAllowed(value={RoleWithHierarchy.SPACE_OBSERVER})
    public MaterialType getMaterialType(String var1, String var2);

    @Transactional(readOnly=true)
    @RolesAllowed(value={RoleWithHierarchy.SPACE_OBSERVER})
    public List<Material> listMaterials(String var1, ListMaterialCriteria var2, boolean var3);

    @Transactional
    @RolesAllowed(value={RoleWithHierarchy.INSTANCE_ADMIN})
    @DatabaseCreateOrDeleteModification(value={DatabaseModificationKind.ObjectKind.MATERIAL_TYPE})
    public void registerMaterialType(String var1, MaterialType var2);

    @Transactional
    @RolesAllowed(value={RoleWithHierarchy.INSTANCE_ADMIN})
    @DatabaseUpdateModification(value={DatabaseModificationKind.ObjectKind.MATERIAL_TYPE})
    public void updateMaterialType(String var1, EntityType var2);

    @Transactional
    @RolesAllowed(value={RoleWithHierarchy.INSTANCE_ADMIN})
    @DatabaseCreateOrDeleteModification(value={DatabaseModificationKind.ObjectKind.SAMPLE_TYPE})
    public void registerSampleType(String var1, SampleType var2);

    @Transactional
    @RolesAllowed(value={RoleWithHierarchy.INSTANCE_ADMIN})
    @DatabaseUpdateModification(value={DatabaseModificationKind.ObjectKind.SAMPLE_TYPE})
    public void updateSampleType(String var1, EntityType var2);

    @Transactional
    @RolesAllowed(value={RoleWithHierarchy.INSTANCE_ADMIN})
    @DatabaseCreateOrDeleteModification(value={DatabaseModificationKind.ObjectKind.EXPERIMENT_TYPE})
    public void registerExperimentType(String var1, ExperimentType var2);

    @Transactional
    @RolesAllowed(value={RoleWithHierarchy.INSTANCE_ADMIN})
    @DatabaseUpdateModification(value={DatabaseModificationKind.ObjectKind.EXPERIMENT_TYPE})
    public void updateExperimentType(String var1, EntityType var2);

    @Transactional
    @RolesAllowed(value={RoleWithHierarchy.INSTANCE_ADMIN})
    @DatabaseCreateOrDeleteModification(value={DatabaseModificationKind.ObjectKind.FILE_FORMAT_TYPE})
    public void registerFileFormatType(String var1, FileFormatType var2);

    @Transactional
    @RolesAllowed(value={RoleWithHierarchy.INSTANCE_ADMIN})
    @DatabaseCreateOrDeleteModification(value={DatabaseModificationKind.ObjectKind.DATASET_TYPE})
    public void registerDataSetType(String var1, DataSetType var2);

    @Transactional
    @RolesAllowed(value={RoleWithHierarchy.INSTANCE_ADMIN})
    @DatabaseUpdateModification(value={DatabaseModificationKind.ObjectKind.DATASET_TYPE})
    public void updateDataSetType(String var1, EntityType var2);

    @Transactional
    @RolesAllowed(value={RoleWithHierarchy.SPACE_POWER_USER})
    @DatabaseCreateOrDeleteModification(value={DatabaseModificationKind.ObjectKind.DATA_SET, DatabaseModificationKind.ObjectKind.DELETION})
    @Capability(value="DELETE_DATASET")
    public void deleteDataSets(String var1, @AuthorizationGuard(guardClass=DataSetCodePredicate.class) List<String> var2, String var3, DeletionType var4, boolean var5, boolean var6);

    @Transactional
    @RolesAllowed(value={RoleWithHierarchy.SPACE_POWER_USER})
    @DatabaseCreateOrDeleteModification(value={DatabaseModificationKind.ObjectKind.SAMPLE, DatabaseModificationKind.ObjectKind.DELETION})
    @Capability(value="DELETE_SAMPLE")
    public void deleteSamples(String var1, @AuthorizationGuard(guardClass=SampleTechIdCollectionPredicate.class) List<TechId> var2, String var3, DeletionType var4);

    @Transactional
    @RolesAllowed(value={RoleWithHierarchy.SPACE_POWER_USER})
    @DatabaseCreateOrDeleteModification(value={DatabaseModificationKind.ObjectKind.EXPERIMENT, DatabaseModificationKind.ObjectKind.DELETION})
    @Capability(value="DELETE_EXPERIMENT")
    public void deleteExperiments(String var1, @AuthorizationGuard(guardClass=AbstractTechIdPredicate.ExperimentTechIdPredicate.class) List<TechId> var2, String var3, DeletionType var4);

    @Transactional
    @RolesAllowed(value={RoleWithHierarchy.SPACE_POWER_USER})
    @DatabaseUpdateModification(value={DatabaseModificationKind.ObjectKind.EXPERIMENT})
    @Capability(value="DELETE_EXPERIMENT_ATTACHMENT")
    public void deleteExperimentAttachments(String var1, @AuthorizationGuard(guardClass=AbstractTechIdPredicate.ExperimentTechIdPredicate.class) TechId var2, List<String> var3, String var4);

    @Transactional
    @RolesAllowed(value={RoleWithHierarchy.SPACE_POWER_USER})
    @DatabaseUpdateModification(value={DatabaseModificationKind.ObjectKind.SAMPLE})
    @Capability(value="DELETE_SAMPLE_ATTACHMENT")
    public void deleteSampleAttachments(String var1, @AuthorizationGuard(guardClass=SampleTechIdPredicate.class) TechId var2, List<String> var3, String var4);

    @Transactional
    @RolesAllowed(value={RoleWithHierarchy.SPACE_POWER_USER})
    @DatabaseUpdateModification(value={DatabaseModificationKind.ObjectKind.PROJECT})
    @Capability(value="DELETE_PROJECT_ATTACHMENT")
    public void deleteProjectAttachments(String var1, @AuthorizationGuard(guardClass=AbstractTechIdPredicate.ProjectTechIdPredicate.class) TechId var2, List<String> var3, String var4);

    @Transactional(readOnly=true)
    @RolesAllowed(value={RoleWithHierarchy.SPACE_OBSERVER})
    public List<Attachment> listExperimentAttachments(String var1, @AuthorizationGuard(guardClass=AbstractTechIdPredicate.ExperimentTechIdPredicate.class) TechId var2);

    @Transactional(readOnly=true)
    @RolesAllowed(value={RoleWithHierarchy.SPACE_OBSERVER})
    public List<Attachment> listSampleAttachments(String var1, @AuthorizationGuard(guardClass=SampleTechIdPredicate.class) TechId var2);

    @Transactional(readOnly=true)
    @RolesAllowed(value={RoleWithHierarchy.SPACE_OBSERVER})
    public List<Attachment> listProjectAttachments(String var1, @AuthorizationGuard(guardClass=AbstractTechIdPredicate.ProjectTechIdPredicate.class) TechId var2);

    @Transactional
    @RolesAllowed(value={RoleWithHierarchy.SPACE_OBSERVER})
    public String uploadDataSets(String var1, List<String> var2, DataSetUploadContext var3);

    @Transactional(readOnly=true)
    @RolesAllowed(value={RoleWithHierarchy.SPACE_OBSERVER})
    public List<VocabularyTermWithStats> listVocabularyTermsWithStatistics(String var1, Vocabulary var2);

    @Transactional(readOnly=true)
    @RolesAllowed(value={RoleWithHierarchy.SPACE_OBSERVER})
    public Set<VocabularyTerm> listVocabularyTerms(String var1, Vocabulary var2);

    @Transactional(readOnly=true)
    @RolesAllowed(value={RoleWithHierarchy.SPACE_OBSERVER})
    public List<DataSetType> listDataSetTypes(String var1);

    @RolesAllowed(value={RoleWithHierarchy.SPACE_OBSERVER})
    public LastModificationState getLastModificationState(String var1);

    @Transactional(readOnly=true)
    @RolesAllowed(value={RoleWithHierarchy.SPACE_OBSERVER})
    public SampleParentWithDerived getSampleInfo(String var1, @AuthorizationGuard(guardClass=SampleTechIdPredicate.class) TechId var2) throws UserFailureException;

    @Transactional
    @RolesAllowed(value={RoleWithHierarchy.SPACE_USER})
    @DatabaseUpdateModification(value={DatabaseModificationKind.ObjectKind.SAMPLE})
    @Capability(value="WRITE_SAMPLE")
    public SampleUpdateResult updateSample(String var1, @AuthorizationGuard(guardClass=SampleUpdatesPredicate.class) SampleUpdatesDTO var2);

    @Transactional(readOnly=true)
    @RolesAllowed(value={RoleWithHierarchy.SPACE_OBSERVER})
    public Experiment getExperimentInfo(String var1, @AuthorizationGuard(guardClass=SpaceIdentifierPredicate.class) ExperimentIdentifier var2);

    @Transactional(readOnly=true)
    @RolesAllowed(value={RoleWithHierarchy.SPACE_OBSERVER})
    public Experiment getExperimentInfo(String var1, @AuthorizationGuard(guardClass=AbstractTechIdPredicate.ExperimentTechIdPredicate.class) TechId var2);

    @Transactional
    @RolesAllowed(value={RoleWithHierarchy.SPACE_USER})
    @DatabaseUpdateModification(value={DatabaseModificationKind.ObjectKind.EXPERIMENT, DatabaseModificationKind.ObjectKind.SAMPLE})
    @Capability(value="WRITE_EXPERIMENT_SAMPLE")
    public ExperimentUpdateResult updateExperiment(String var1, @AuthorizationGuard(guardClass=ExperimentUpdatesPredicate.class) ExperimentUpdatesDTO var2);

    @Transactional(readOnly=true)
    @RolesAllowed(value={RoleWithHierarchy.SPACE_OBSERVER})
    public Project getProjectInfo(String var1, @AuthorizationGuard(guardClass=AbstractTechIdPredicate.ProjectTechIdPredicate.class) TechId var2);

    @Transactional(readOnly=true)
    @RolesAllowed(value={RoleWithHierarchy.SPACE_OBSERVER})
    public Project getProjectInfo(String var1, @AuthorizationGuard(guardClass=SpaceIdentifierPredicate.class) ProjectIdentifier var2);

    @Transactional
    @RolesAllowed(value={RoleWithHierarchy.SPACE_USER})
    public String generateCode(String var1, String var2);

    @Transactional
    @RolesAllowed(value={RoleWithHierarchy.SPACE_POWER_USER})
    @DatabaseUpdateModification(value={DatabaseModificationKind.ObjectKind.PROJECT})
    @Capability(value="WRITE_PROJECT")
    public Date updateProject(String var1, @AuthorizationGuard(guardClass=ProjectUpdatesPredicate.class) ProjectUpdatesDTO var2);

    @Transactional
    @RolesAllowed(value={RoleWithHierarchy.INSTANCE_ADMIN})
    @DatabaseCreateOrDeleteModification(value={DatabaseModificationKind.ObjectKind.DATASET_TYPE, DatabaseModificationKind.ObjectKind.PROPERTY_TYPE_ASSIGNMENT})
    public void deleteDataSetTypes(String var1, List<String> var2);

    @Transactional
    @RolesAllowed(value={RoleWithHierarchy.INSTANCE_ADMIN})
    @DatabaseCreateOrDeleteModification(value={DatabaseModificationKind.ObjectKind.SAMPLE_TYPE, DatabaseModificationKind.ObjectKind.PROPERTY_TYPE_ASSIGNMENT})
    public void deleteSampleTypes(String var1, List<String> var2);

    @Transactional
    @RolesAllowed(value={RoleWithHierarchy.INSTANCE_ADMIN})
    @DatabaseCreateOrDeleteModification(value={DatabaseModificationKind.ObjectKind.EXPERIMENT_TYPE, DatabaseModificationKind.ObjectKind.PROPERTY_TYPE_ASSIGNMENT})
    public void deleteExperimentTypes(String var1, List<String> var2);

    @Transactional
    @RolesAllowed(value={RoleWithHierarchy.INSTANCE_ADMIN})
    @DatabaseCreateOrDeleteModification(value={DatabaseModificationKind.ObjectKind.FILE_FORMAT_TYPE})
    public void deleteFileFormatTypes(String var1, List<String> var2);

    @Transactional
    @RolesAllowed(value={RoleWithHierarchy.INSTANCE_ADMIN})
    @DatabaseCreateOrDeleteModification(value={DatabaseModificationKind.ObjectKind.MATERIAL_TYPE, DatabaseModificationKind.ObjectKind.PROPERTY_TYPE_ASSIGNMENT})
    public void deleteMaterialTypes(String var1, List<String> var2);

    @Transactional(readOnly=true)
    @RolesAllowed(value={RoleWithHierarchy.SPACE_OBSERVER})
    public IEntityInformationHolderWithPermId getEntityInformationHolder(String var1, EntityKind var2, String var3);

    @Transactional(readOnly=true)
    @RolesAllowed(value={RoleWithHierarchy.INSTANCE_ADMIN})
    public IEntityInformationHolderWithPermId getEntityInformationHolder(String var1, BasicEntityDescription var2);

    @Transactional(readOnly=true)
    @RolesAllowed(value={RoleWithHierarchy.SPACE_OBSERVER})
    public Material getMaterialInfo(String var1, MaterialIdentifier var2);

    @Transactional(readOnly=true)
    @RolesAllowed(value={RoleWithHierarchy.SPACE_OBSERVER})
    public Material getMaterialInfo(String var1, TechId var2);

    @Transactional(readOnly=true)
    @RolesAllowed(value={RoleWithHierarchy.SPACE_OBSERVER})
    public IEntityInformationHolderWithPermId getMaterialInformationHolder(String var1, MaterialIdentifier var2);

    @Transactional
    @RolesAllowed(value={RoleWithHierarchy.INSTANCE_ADMIN})
    @DatabaseUpdateModification(value={DatabaseModificationKind.ObjectKind.MATERIAL})
    @Capability(value="WRITE_MATERIAL")
    public Date updateMaterial(String var1, TechId var2, List<IEntityProperty> var3, Date var4);

    @Transactional(readOnly=true)
    @RolesAllowed(value={RoleWithHierarchy.SPACE_OBSERVER})
    public String getTemplateColumns(String var1, EntityKind var2, String var3, boolean var4, boolean var5, boolean var6, BatchOperationKind var7);

    @Transactional
    @RolesAllowed(value={RoleWithHierarchy.INSTANCE_ADMIN})
    @DatabaseUpdateModification(value={DatabaseModificationKind.ObjectKind.FILE_FORMAT_TYPE})
    public void updateFileFormatType(String var1, AbstractType var2);

    @Transactional
    @RolesAllowed(value={RoleWithHierarchy.SPACE_USER})
    @DatabaseUpdateModification(value={DatabaseModificationKind.ObjectKind.EXPERIMENT})
    @Capability(value="WRITE_EXPERIMENT_ATTACHMENT")
    public void updateExperimentAttachments(String var1, TechId var2, Attachment var3);

    @Transactional
    @RolesAllowed(value={RoleWithHierarchy.SPACE_USER})
    @DatabaseUpdateModification(value={DatabaseModificationKind.ObjectKind.EXPERIMENT})
    @Capability(value="WRITE_EXPERIMENT_ATTACHMENT")
    public void addExperimentAttachment(String var1, TechId var2, NewAttachment var3);

    @Transactional
    @RolesAllowed(value={RoleWithHierarchy.SPACE_USER})
    @DatabaseUpdateModification(value={DatabaseModificationKind.ObjectKind.SAMPLE})
    @Capability(value="WRITE_SAMPLE_ATTACHMENT")
    public void updateSampleAttachments(String var1, TechId var2, Attachment var3);

    @Transactional
    @RolesAllowed(value={RoleWithHierarchy.SPACE_USER})
    @DatabaseUpdateModification(value={DatabaseModificationKind.ObjectKind.SAMPLE})
    @Capability(value="WRITE_SAMPLE_ATTACHMENT")
    public void addSampleAttachments(String var1, TechId var2, NewAttachment var3);

    @Transactional
    @RolesAllowed(value={RoleWithHierarchy.SPACE_POWER_USER})
    @DatabaseUpdateModification(value={DatabaseModificationKind.ObjectKind.PROJECT})
    @Capability(value="WRITE_PROJECT_ATTACHMENT")
    public void updateProjectAttachments(String var1, TechId var2, Attachment var3);

    @Transactional
    @RolesAllowed(value={RoleWithHierarchy.SPACE_POWER_USER})
    @DatabaseUpdateModification(value={DatabaseModificationKind.ObjectKind.PROJECT})
    @Capability(value="WRITE_PROJECT_ATTACHMENT")
    public void addProjectAttachments(String var1, TechId var2, NewAttachment var3);

    @Transactional(readOnly=true)
    @RolesAllowed(value={RoleWithHierarchy.SPACE_OBSERVER})
    public List<DatastoreServiceDescription> listDataStoreServices(String var1, DataStoreServiceKind var2);

    @Transactional(readOnly=true)
    @RolesAllowed(value={RoleWithHierarchy.SPACE_OBSERVER})
    public TableModel createReportFromDatasets(String var1, DatastoreServiceDescription var2, @AuthorizationGuard(guardClass=DataSetCodeCollectionPredicate.class) List<String> var3);

    @Transactional(readOnly=true)
    @RolesAllowed(value={RoleWithHierarchy.SPACE_USER})
    public void processDatasets(String var1, DatastoreServiceDescription var2, @AuthorizationGuard(guardClass=DataSetCodeCollectionPredicate.class) List<String> var3);

    @Transactional
    @RolesAllowed(value={RoleWithHierarchy.SPACE_POWER_USER})
    @DatabaseUpdateModification(value={DatabaseModificationKind.ObjectKind.DATA_SET})
    @Capability(value="ARCHIVE_DATASET")
    public int archiveDatasets(String var1, @AuthorizationGuard(guardClass=DataSetCodeCollectionPredicate.class) List<String> var2, boolean var3);

    @Transactional
    @RolesAllowed(value={RoleWithHierarchy.SPACE_USER})
    @DatabaseUpdateModification(value={DatabaseModificationKind.ObjectKind.DATA_SET})
    @Capability(value="UNARCHIVE_DATASET")
    public int unarchiveDatasets(String var1, @AuthorizationGuard(guardClass=DataSetCodeCollectionPredicate.class) List<String> var2);

    @Transactional
    @RolesAllowed(value={RoleWithHierarchy.SPACE_ADMIN})
    @DatabaseUpdateModification(value={DatabaseModificationKind.ObjectKind.DATA_SET})
    public int lockDatasets(String var1, @AuthorizationGuard(guardClass=DataSetCodeCollectionPredicate.class) List<String> var2);

    @Transactional
    @RolesAllowed(value={RoleWithHierarchy.SPACE_ADMIN})
    @DatabaseUpdateModification(value={DatabaseModificationKind.ObjectKind.DATA_SET})
    public int unlockDatasets(String var1, @AuthorizationGuard(guardClass=DataSetCodeCollectionPredicate.class) List<String> var2);

    @Transactional(readOnly=true)
    @RolesAllowed(value={RoleWithHierarchy.SPACE_ADMIN})
    public List<AuthorizationGroup> listAuthorizationGroups(String var1);

    @Transactional
    @RolesAllowed(value={RoleWithHierarchy.INSTANCE_ADMIN})
    @DatabaseUpdateModification(value={DatabaseModificationKind.ObjectKind.AUTHORIZATION_GROUP})
    public Date updateAuthorizationGroup(String var1, AuthorizationGroupUpdates var2);

    @Transactional(readOnly=true)
    @RolesAllowed(value={RoleWithHierarchy.SPACE_ADMIN})
    public List<Person> listPersonInAuthorizationGroup(String var1, TechId var2);

    @Transactional
    @RolesAllowed(value={RoleWithHierarchy.INSTANCE_ADMIN})
    public void addPersonsToAuthorizationGroup(String var1, TechId var2, List<String> var3);

    @Transactional
    @RolesAllowed(value={RoleWithHierarchy.INSTANCE_ADMIN})
    public void removePersonsFromAuthorizationGroup(String var1, TechId var2, List<String> var3);

    @Transactional
    @RolesAllowed(value={RoleWithHierarchy.SPACE_OBSERVER})
    @ReturnValueFilter(validatorClass=ExpressionValidator.class)
    public List<GridCustomFilter> listFilters(String var1, String var2);

    @Transactional
    @RolesAllowed(value={RoleWithHierarchy.SPACE_POWER_USER})
    @DatabaseCreateOrDeleteModification(value={DatabaseModificationKind.ObjectKind.GRID_CUSTOM_FILTER})
    @Capability(value="WRITE_FILTER")
    public void registerFilter(String var1, NewColumnOrFilter var2);

    @Transactional
    @RolesAllowed(value={RoleWithHierarchy.SPACE_POWER_USER})
    @DatabaseCreateOrDeleteModification(value={DatabaseModificationKind.ObjectKind.GRID_CUSTOM_FILTER})
    @Capability(value="DELETE_FILTER")
    public void deleteFilters(String var1, @AuthorizationGuard(guardClass=AbstractExpressionPredicate.DeleteGridCustomFilterPredicate.class) List<TechId> var2);

    @Transactional
    @RolesAllowed(value={RoleWithHierarchy.SPACE_POWER_USER})
    @DatabaseUpdateModification(value={DatabaseModificationKind.ObjectKind.GRID_CUSTOM_FILTER})
    @Capability(value="WRITE_FILTER")
    public void updateFilter(String var1, @AuthorizationGuard(guardClass=AbstractExpressionPredicate.UpdateGridCustomFilterPredicate.class) IExpressionUpdates var2);

    @Override
    @Transactional
    @RolesAllowed(value={RoleWithHierarchy.SPACE_OBSERVER})
    @ReturnValueFilter(validatorClass=ExpressionValidator.class)
    public List<GridCustomColumn> listGridCustomColumns(String var1, String var2);

    @Transactional
    @RolesAllowed(value={RoleWithHierarchy.SPACE_POWER_USER})
    @DatabaseCreateOrDeleteModification(value={DatabaseModificationKind.ObjectKind.GRID_CUSTOM_COLUMN})
    @Capability(value="WRITE_CUSTOM_COLUMN")
    public void registerGridCustomColumn(String var1, NewColumnOrFilter var2);

    @Transactional
    @RolesAllowed(value={RoleWithHierarchy.SPACE_POWER_USER})
    @DatabaseCreateOrDeleteModification(value={DatabaseModificationKind.ObjectKind.GRID_CUSTOM_COLUMN})
    @Capability(value="DELETE_CUSTOM_COLUMN")
    public void deleteGridCustomColumns(String var1, @AuthorizationGuard(guardClass=AbstractExpressionPredicate.DeleteGridCustomColumnPredicate.class) List<TechId> var2);

    @Transactional
    @RolesAllowed(value={RoleWithHierarchy.SPACE_POWER_USER})
    @DatabaseUpdateModification(value={DatabaseModificationKind.ObjectKind.GRID_CUSTOM_COLUMN})
    @Capability(value="WRITE_CUSTOM_COLUMN")
    public void updateGridCustomColumn(String var1, @AuthorizationGuard(guardClass=AbstractExpressionPredicate.UpdateGridCustomColumnPredicate.class) IExpressionUpdates var2);

    @Transactional
    @RolesAllowed(value={RoleWithHierarchy.INSTANCE_ADMIN})
    @DatabaseUpdateModification(value={DatabaseModificationKind.ObjectKind.VOCABULARY_TERM})
    @Capability(value="WRITE_VOCABULARY")
    public void updateVocabularyTerms(String var1, TechId var2, List<VocabularyTerm> var3);

    @Transactional
    @RolesAllowed(value={RoleWithHierarchy.INSTANCE_ADMIN})
    @DatabaseCreateOrDeleteModification(value={DatabaseModificationKind.ObjectKind.MATERIAL})
    @Capability(value="DELETE_MATERIAL")
    public void deleteMaterials(String var1, List<TechId> var2, String var3);

    @Transactional(readOnly=true)
    @RolesAllowed(value={RoleWithHierarchy.SPACE_OBSERVER})
    public LinkModel retrieveLinkFromDataSet(String var1, DatastoreServiceDescription var2, @AuthorizationGuard(guardClass=DataSetCodePredicate.class) String var3);

    @Transactional(readOnly=true)
    @RolesAllowed(value={RoleWithHierarchy.SPACE_OBSERVER})
    public Script getScriptInfo(String var1, TechId var2);

    @Transactional(readOnly=true)
    @RolesAllowed(value={RoleWithHierarchy.INSTANCE_ADMIN})
    public String evaluate(String var1, DynamicPropertyEvaluationInfo var2);

    @Transactional
    @RolesAllowed(value={RoleWithHierarchy.SPACE_USER})
    @DatabaseUpdateModification(value={DatabaseModificationKind.ObjectKind.EXPERIMENT})
    public void updateManagedPropertyOnExperiment(String var1, TechId var2, IManagedProperty var3, IManagedUiAction var4);

    @Transactional
    @RolesAllowed(value={RoleWithHierarchy.SPACE_USER})
    @DatabaseUpdateModification(value={DatabaseModificationKind.ObjectKind.SAMPLE})
    public void updateManagedPropertyOnSample(String var1, TechId var2, IManagedProperty var3, IManagedUiAction var4);

    @Transactional
    @RolesAllowed(value={RoleWithHierarchy.SPACE_USER})
    @DatabaseUpdateModification(value={DatabaseModificationKind.ObjectKind.DATA_SET})
    public void updateManagedPropertyOnDataSet(String var1, TechId var2, IManagedProperty var3, IManagedUiAction var4);

    @Transactional
    @RolesAllowed(value={RoleWithHierarchy.SPACE_USER})
    @DatabaseUpdateModification(value={DatabaseModificationKind.ObjectKind.MATERIAL})
    public void updateManagedPropertyOnMaterial(String var1, TechId var2, IManagedProperty var3, IManagedUiAction var4);

    @Transactional(readOnly=true)
    @RolesAllowed(value={RoleWithHierarchy.SPACE_OBSERVER})
    public String getDefaultPutDataStoreBaseURL(String var1);

    @Transactional
    @RolesAllowed(value={RoleWithHierarchy.SPACE_USER})
    @DatabaseUpdateModification(value={DatabaseModificationKind.ObjectKind.DATA_SET})
    @Capability(value="WRITE_DATASET_PROPERTIES")
    public void updateDataSetProperties(String var1, @AuthorizationGuard(guardClass=AbstractTechIdPredicate.DataSetTechIdPredicate.class) TechId var2, List<PropertyUpdates> var3);

    @Transactional
    @RolesAllowed(value={RoleWithHierarchy.SPACE_USER})
    @DatabaseUpdateModification(value={DatabaseModificationKind.ObjectKind.EXPERIMENT})
    @Capability(value="WRITE_EXPERIMENT_PROPERTIES")
    public void updateExperimentProperties(String var1, @AuthorizationGuard(guardClass=AbstractTechIdPredicate.ExperimentTechIdPredicate.class) TechId var2, List<PropertyUpdates> var3);

    @Transactional
    @RolesAllowed(value={RoleWithHierarchy.SPACE_USER})
    @DatabaseUpdateModification(value={DatabaseModificationKind.ObjectKind.SAMPLE})
    @Capability(value="WRITE_SAMPLE_PROPERTIES")
    public void updateSampleProperties(String var1, @AuthorizationGuard(guardClass=SampleTechIdPredicate.class) TechId var2, List<PropertyUpdates> var3);

    @Transactional
    @RolesAllowed(value={RoleWithHierarchy.INSTANCE_ADMIN})
    @DatabaseUpdateModification(value={DatabaseModificationKind.ObjectKind.MATERIAL})
    @Capability(value="WRITE_MATERIAL_PROPERTIES")
    public void updateMaterialProperties(String var1, TechId var2, List<PropertyUpdates> var3);

    @Transactional(readOnly=true)
    @RolesAllowed(value={RoleWithHierarchy.SPACE_USER})
    @ReturnValueFilter(validatorClass=DeletionValidator.class)
    public List<Deletion> listDeletions(String var1, boolean var2);

    @Transactional
    @RolesAllowed(value={RoleWithHierarchy.SPACE_USER})
    @DatabaseCreateOrDeleteModification(value={DatabaseModificationKind.ObjectKind.DELETION})
    @DatabaseUpdateModification(value={DatabaseModificationKind.ObjectKind.EXPERIMENT, DatabaseModificationKind.ObjectKind.SAMPLE, DatabaseModificationKind.ObjectKind.DATA_SET})
    @Capability(value="RESTORE")
    public void revertDeletions(String var1, @AuthorizationGuard(guardClass=RevertDeletionPredicate.class) List<TechId> var2);

    @Transactional
    @RolesAllowed(value={RoleWithHierarchy.SPACE_ADMIN})
    @DatabaseCreateOrDeleteModification(value={DatabaseModificationKind.ObjectKind.DELETION, DatabaseModificationKind.ObjectKind.EXPERIMENT, DatabaseModificationKind.ObjectKind.SAMPLE, DatabaseModificationKind.ObjectKind.DATA_SET})
    @Capability(value="PURGE")
    public void deletePermanently(String var1, @AuthorizationGuard(guardClass=DeletionTechIdCollectionPredicate.class) List<TechId> var2, boolean var3);

    @Transactional(readOnly=true)
    @RolesAllowed(value={RoleWithHierarchy.SPACE_OBSERVER})
    public List<Material> searchForMaterials(String var1, DetailedSearchCriteria var2);
}

