/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.shared.api.v1.dto;

import ch.systemsx.cisd.openbis.generic.shared.api.v1.dto.EntityRegistrationDetails;
import ch.systemsx.cisd.openbis.generic.shared.api.v1.dto.InitializingChecks;
import ch.systemsx.cisd.openbis.generic.shared.basic.IIdentifierHolder;
import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Sample
implements Serializable,
IIdentifierHolder {
    private static final long serialVersionUID = 1L;
    private Long id;
    private String spaceCode;
    private String permId;
    private String code;
    private String identifier;
    private String experimentIdentifierOrNull;
    private Long sampleTypeId;
    private String sampleTypeCode;
    private HashMap<String, String> properties;
    private EntityRegistrationDetails registrationDetails;

    public Sample(SampleInitializer initializer) {
        InitializingChecks.checkValidLong(initializer.getId(), "Unspecified id.");
        this.id = initializer.getId();
        this.spaceCode = initializer.getSpaceCode();
        InitializingChecks.checkValidString(initializer.getPermId(), "Unspecified permanent id.");
        this.permId = initializer.getPermId();
        InitializingChecks.checkValidString(initializer.getCode(), "Unspecified code.");
        this.code = initializer.getCode();
        InitializingChecks.checkValidString(initializer.getIdentifier(), "Unspecified identifier.");
        this.identifier = initializer.getIdentifier();
        this.experimentIdentifierOrNull = initializer.getExperimentIdentifierOrNull();
        InitializingChecks.checkValidLong(initializer.getSampleTypeId(), "Unspecified sample type id.");
        this.sampleTypeId = initializer.getSampleTypeId();
        InitializingChecks.checkValidString(initializer.getSampleTypeCode(), "Unspecified sample type code.");
        this.sampleTypeCode = initializer.getSampleTypeCode();
        this.properties = initializer.getProperties();
        InitializingChecks.checkValidRegistrationDetails(initializer.getRegistrationDetails(), "Unspecified entity registration details.");
        this.registrationDetails = initializer.getRegistrationDetails();
    }

    public Long getId() {
        return this.id;
    }

    public String getSpaceCode() {
        return this.spaceCode;
    }

    public String getPermId() {
        return this.permId;
    }

    public String getCode() {
        return this.code;
    }

    @Override
    public String getIdentifier() {
        return this.identifier;
    }

    public String getExperimentIdentifierOrNull() {
        return this.experimentIdentifierOrNull;
    }

    public Long getSampleTypeId() {
        return this.sampleTypeId;
    }

    public String getSampleTypeCode() {
        return this.sampleTypeCode;
    }

    public Map<String, String> getProperties() {
        return Collections.unmodifiableMap(this.properties);
    }

    public EntityRegistrationDetails getRegistrationDetails() {
        return this.registrationDetails;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof Sample)) {
            return false;
        }
        EqualsBuilder builder = new EqualsBuilder();
        Sample other = (Sample)obj;
        builder.append((Object)this.getId(), (Object)other.getId());
        return builder.isEquals();
    }

    public int hashCode() {
        HashCodeBuilder builder = new HashCodeBuilder();
        builder.append((Object)this.getId());
        return builder.toHashCode();
    }

    public String toString() {
        ToStringBuilder builder = new ToStringBuilder((Object)this, ToStringStyle.SHORT_PREFIX_STYLE);
        builder.append((Object)this.getIdentifier());
        builder.append((Object)this.getSampleTypeCode());
        builder.append(this.getProperties());
        return builder.toString();
    }

    private Sample() {
    }

    private void setId(Long id) {
        this.id = id;
    }

    private void setSpaceCode(String spaceCode) {
        this.spaceCode = spaceCode;
    }

    private void setPermId(String permId) {
        this.permId = permId;
    }

    private void setCode(String code) {
        this.code = code;
    }

    private void setIdentifier(String identifier) {
        this.identifier = identifier;
    }

    private void setExperimentIdentifierOrNull(String experimentIdentifierOrNull) {
        this.experimentIdentifierOrNull = experimentIdentifierOrNull;
    }

    private void setSampleTypeId(Long sampleTypeId) {
        this.sampleTypeId = sampleTypeId;
    }

    private void setSampleTypeCode(String sampleTypeCode) {
        this.sampleTypeCode = sampleTypeCode;
    }

    private void setProperties(HashMap<String, String> properties) {
        this.properties = properties;
    }

    private void setRegistrationDetails(EntityRegistrationDetails registrationDetails) {
        this.registrationDetails = registrationDetails;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class SampleInitializer {
        private Long id;
        private String spaceCode;
        private String permId;
        private String code;
        private String identifier;
        private String experimentIdentifierOrNull;
        private Long sampleTypeId;
        private String sampleTypeCode;
        private HashMap<String, String> properties = new HashMap();
        private EntityRegistrationDetails registrationDetails;

        public void setId(Long id) {
            this.id = id;
        }

        public Long getId() {
            return this.id;
        }

        public void setSpaceCode(String spaceCode) {
            this.spaceCode = spaceCode;
        }

        public String getSpaceCode() {
            return this.spaceCode;
        }

        public void setPermId(String permId) {
            this.permId = permId;
        }

        public String getPermId() {
            return this.permId;
        }

        public void setCode(String code) {
            this.code = code;
        }

        public String getCode() {
            return this.code;
        }

        public String getIdentifier() {
            return this.identifier;
        }

        public void setIdentifier(String identifier) {
            this.identifier = identifier;
        }

        public String getExperimentIdentifierOrNull() {
            return this.experimentIdentifierOrNull;
        }

        public void setExperimentIdentifierOrNull(String experimentIdentifierOrNull) {
            this.experimentIdentifierOrNull = experimentIdentifierOrNull;
        }

        public void setSampleTypeId(Long sampleTypeId) {
            this.sampleTypeId = sampleTypeId;
        }

        public Long getSampleTypeId() {
            return this.sampleTypeId;
        }

        public void setSampleTypeCode(String sampleTypeCode) {
            this.sampleTypeCode = sampleTypeCode;
        }

        public String getSampleTypeCode() {
            return this.sampleTypeCode;
        }

        public HashMap<String, String> getProperties() {
            return this.properties;
        }

        public void putProperty(String propCode, String value) {
            this.properties.put(propCode, value);
        }

        public void setRegistrationDetails(EntityRegistrationDetails registrationDetails) {
            this.registrationDetails = registrationDetails;
        }

        public EntityRegistrationDetails getRegistrationDetails() {
            return this.registrationDetails;
        }
    }
}

