/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.shared.authorization.predicate;

import ch.systemsx.cisd.common.exceptions.Status;
import ch.systemsx.cisd.common.exceptions.StatusFlag;
import ch.systemsx.cisd.openbis.generic.shared.authorization.IAuthorizationDataProvider;
import ch.systemsx.cisd.openbis.generic.shared.authorization.RoleWithIdentifier;
import ch.systemsx.cisd.openbis.generic.shared.authorization.predicate.AbstractPredicate;
import ch.systemsx.cisd.openbis.generic.shared.authorization.predicate.IPredicate;
import ch.systemsx.cisd.openbis.generic.shared.dto.PersonPE;
import java.util.Collection;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class CollectionPredicate<T>
extends AbstractPredicate<Collection<T>> {
    private final IPredicate<T> predicate;

    public CollectionPredicate(IPredicate<T> predicate) {
        this.predicate = predicate;
    }

    protected Status itemEvaluate(PersonPE person, List<RoleWithIdentifier> allowedRoles, T item) {
        return this.predicate.evaluate(person, allowedRoles, item);
    }

    @Override
    public final void init(IAuthorizationDataProvider provider) {
        this.predicate.init(provider);
    }

    @Override
    protected final Status doEvaluation(PersonPE person, List<RoleWithIdentifier> allowedRoles, Collection<T> value) {
        for (T item : value) {
            Status status = this.itemEvaluate(person, allowedRoles, item);
            if (status.getFlag().equals((Object)StatusFlag.OK)) continue;
            return status;
        }
        return Status.OK;
    }

    @Override
    public final String getCandidateDescription() {
        if (this.predicate instanceof AbstractPredicate) {
            return ((AbstractPredicate)this.predicate).getCandidateDescription();
        }
        return "collection";
    }
}

