/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.shared.authorization.predicate;

import ch.systemsx.cisd.common.exceptions.Status;
import ch.systemsx.cisd.openbis.generic.shared.authorization.IAuthorizationDataProvider;
import ch.systemsx.cisd.openbis.generic.shared.authorization.RoleWithIdentifier;
import ch.systemsx.cisd.openbis.generic.shared.authorization.predicate.AbstractPredicate;
import ch.systemsx.cisd.openbis.generic.shared.authorization.predicate.IPredicate;
import ch.systemsx.cisd.openbis.generic.shared.authorization.predicate.SpaceIdentifierPredicate;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.NewBasicExperiment;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.NewExperimentsWithType;
import ch.systemsx.cisd.openbis.generic.shared.dto.PersonPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.identifier.ExperimentIdentifier;
import ch.systemsx.cisd.openbis.generic.shared.dto.identifier.ExperimentIdentifierFactory;
import ch.systemsx.cisd.openbis.generic.shared.dto.identifier.SpaceIdentifier;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class NewExperimentsWithTypePredicate
extends AbstractPredicate<NewExperimentsWithType> {
    private final IPredicate<SpaceIdentifier> delegate;

    @Override
    public final void init(IAuthorizationDataProvider provider) {
        this.delegate.init(provider);
    }

    @Override
    public final Status doEvaluation(PersonPE person, List<RoleWithIdentifier> allowedRoles, NewExperimentsWithType value) {
        Status s = Status.OK;
        for (NewBasicExperiment experiment : value.getNewExperiments()) {
            ExperimentIdentifier identifier = new ExperimentIdentifierFactory(experiment.getIdentifier()).createIdentifier();
            s = this.delegate.evaluate(person, allowedRoles, identifier);
            if (s.equals(Status.OK)) continue;
            return s;
        }
        return s;
    }

    @Deprecated
    NewExperimentsWithTypePredicate(IPredicate<SpaceIdentifier> delegate) {
        this.delegate = delegate;
    }

    public NewExperimentsWithTypePredicate() {
        this.delegate = new SpaceIdentifierPredicate();
    }

    @Override
    public final String getCandidateDescription() {
        return "new experiments with type";
    }
}

