/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.shared.basic.dto;

import ch.systemsx.cisd.openbis.generic.shared.basic.dto.IEntityProperty;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.ManagedProperty;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.ManagedUiDescription;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.Material;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.PropertyType;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.VocabularyTerm;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.api.IManagedProperty;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.api.IManagedUiDescription;

public class ManagedEntityProperty
implements IEntityProperty,
IManagedProperty {
    private static final long serialVersionUID = 32L;
    private IEntityProperty entityProperty;
    private boolean ownTab = true;
    private IManagedUiDescription uiDescription = new ManagedUiDescription();

    public ManagedEntityProperty(IEntityProperty entityProperty) {
        this.entityProperty = entityProperty;
    }

    public boolean isOwnTab() {
        return this.ownTab;
    }

    public void setOwnTab(boolean ownTab) {
        this.ownTab = ownTab;
    }

    public IManagedUiDescription getUiDescription() {
        return this.uiDescription;
    }

    public String getPropertyTypeCode() {
        return this.entityProperty.getPropertyType().getCode();
    }

    public boolean isSpecialValue() {
        return ManagedProperty.isSpecialValue(this.getValue());
    }

    public boolean isManaged() {
        return true;
    }

    public boolean isScriptable() {
        return true;
    }

    public String tryGetAsString() {
        return this.entityProperty.tryGetAsString();
    }

    public String tryGetOriginalValue() {
        return this.entityProperty.tryGetOriginalValue();
    }

    public Material getMaterial() {
        return this.entityProperty.getMaterial();
    }

    public void setMaterial(Material material) {
        this.entityProperty.setMaterial(material);
    }

    public VocabularyTerm getVocabularyTerm() {
        return this.entityProperty.getVocabularyTerm();
    }

    public void setVocabularyTerm(VocabularyTerm vocabularyTerm) {
        this.entityProperty.setVocabularyTerm(vocabularyTerm);
    }

    public String getValue() {
        return this.entityProperty.getValue();
    }

    public void setValue(String value) {
        this.entityProperty.setValue(value);
    }

    public PropertyType getPropertyType() {
        return this.entityProperty.getPropertyType();
    }

    public void setPropertyType(PropertyType propertyType) {
        this.entityProperty.setPropertyType(propertyType);
    }

    public void setOrdinal(Long ordinal) {
        this.entityProperty.setOrdinal(ordinal);
    }

    public Long getOrdinal() {
        return this.entityProperty.getOrdinal();
    }

    public int compareTo(IEntityProperty o) {
        return this.entityProperty.compareTo(o);
    }

    public String toString() {
        return this.entityProperty.toString();
    }

    public ManagedEntityProperty() {
    }
}

