/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.shared.basic.dto;

import java.io.Serializable;

public class TrackingDataSetCriteria
implements Serializable {
    private static final long serialVersionUID = 32L;
    private final String connectedSampleTypeCode;
    private final long lastSeenDataSetId;
    private final boolean enrichResult;

    public TrackingDataSetCriteria(long lastSeenDataSetId) {
        this(null, lastSeenDataSetId, false);
    }

    public TrackingDataSetCriteria(String connectedSampleTypeCodeOrNull, long lastSeenDataSetId) {
        this(connectedSampleTypeCodeOrNull, lastSeenDataSetId, true);
        assert (connectedSampleTypeCodeOrNull != null);
    }

    private TrackingDataSetCriteria(String connectedSampleTypeCodeOrNull, long lastSeenDataSetId, boolean enrichResult) {
        this.enrichResult = enrichResult;
        this.lastSeenDataSetId = lastSeenDataSetId;
        this.connectedSampleTypeCode = connectedSampleTypeCodeOrNull;
    }

    public String getConnectedSampleTypeCode() {
        return this.connectedSampleTypeCode;
    }

    public long getLastSeenDataSetId() {
        return this.lastSeenDataSetId;
    }

    public boolean shouldResultBeEnriched() {
        return this.enrichResult;
    }

    public String toString() {
        return "lastSeenDataSetId:" + this.lastSeenDataSetId + (this.connectedSampleTypeCode == null ? "" : " sample type:" + this.connectedSampleTypeCode) + (this.enrichResult ? " (enrich)" : "");
    }
}

