/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.shared.calculator;

import ch.systemsx.cisd.common.evaluator.Evaluator;
import ch.systemsx.cisd.common.evaluator.EvaluatorException;
import ch.systemsx.cisd.openbis.generic.shared.basic.PrimitiveValue;
import ch.systemsx.cisd.openbis.generic.shared.calculator.StandardFunctions;
import java.math.BigInteger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AbstractCalculator {
    protected static String NEWLINE = "\n";
    protected final Evaluator evaluator;

    protected static String importFunctions(Class<?> clazz) {
        return "from " + clazz.getCanonicalName() + " import *";
    }

    protected static final String getBasicInitialScript() {
        return String.valueOf(AbstractCalculator.importFunctions(StandardFunctions.class)) + NEWLINE + "def int(x):return toInt(x)" + NEWLINE + "def float(x):return toFloat(x)" + NEWLINE;
    }

    public AbstractCalculator(Evaluator evaluator) {
        this.evaluator = evaluator;
    }

    public PrimitiveValue getTypedResult() {
        Object value = this.evaluator.evalLegacy2_2();
        if (value == null) {
            return PrimitiveValue.NULL;
        }
        if (value instanceof Long) {
            return new PrimitiveValue((Long)value);
        }
        if (value instanceof Double) {
            return new PrimitiveValue((Double)value);
        }
        return new PrimitiveValue(value.toString());
    }

    public boolean evalToBoolean() throws EvaluatorException {
        return this.evaluator.evalToBoolean();
    }

    public int evalToInt() throws EvaluatorException {
        return this.evaluator.evalToInt();
    }

    public BigInteger evalToBigInt() throws EvaluatorException {
        return this.evaluator.evalToBigInt();
    }

    public double evalToDouble() throws EvaluatorException {
        return this.evaluator.evalToDouble();
    }

    public String evalAsString() throws EvaluatorException {
        return this.evaluator.evalAsStringLegacy2_2();
    }

    public Object eval() throws EvaluatorException {
        return this.evaluator.evalLegacy2_2();
    }
}

