/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.shared.dto;

import ch.systemsx.cisd.openbis.generic.shared.dto.AbstractIdAndCodeHolder;
import javax.persistence.Column;
import javax.persistence.MappedSuperclass;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.hibernate.search.annotations.Field;
import org.hibernate.search.annotations.Index;
import org.hibernate.search.annotations.Store;
import org.hibernate.validator.Length;
import org.hibernate.validator.NotNull;
import org.hibernate.validator.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@MappedSuperclass
public abstract class AbstractTypePE
extends AbstractIdAndCodeHolder<AbstractTypePE> {
    private static final long serialVersionUID = 32L;
    protected transient Long id;
    private String code;
    private String description;

    public void setId(Long id) {
        this.id = id;
    }

    public void setCode(String code) {
        this.code = code;
    }

    @Column(name="description")
    @Length(max=2000, message="Given description '%s' is too long (maximal length: {max} characters).")
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    @Override
    @Column(name="code")
    @Length(min=1, max=60, message="Given code '%s' is either too short (minimal length: {min} character) or too long (maximal length: {max} characters).")
    @NotNull(message="Code can not be null.")
    @Pattern(regex="^[A-Z0-9_\\-\\.]+$", flags=2, message="Given code '%s' contains illegal characters (allowed: A-Z, a-z, 0-9 and _, -, .)")
    @Field(index=Index.TOKENIZED, store=Store.YES, name="code")
    public String getCode() {
        return this.code;
    }

    @Override
    ToStringBuilder createStringBuilder() {
        ToStringBuilder builder = super.createStringBuilder();
        builder.append("description", (Object)this.getDescription());
        return builder;
    }
}

