/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.shared.dto;

import ch.systemsx.cisd.common.utilities.ClassUtils;
import ch.systemsx.cisd.openbis.generic.shared.dto.AbstractTypePE;
import ch.systemsx.cisd.openbis.generic.shared.dto.DatabaseInstancePE;
import ch.systemsx.cisd.openbis.generic.shared.dto.properties.EntityKind;
import ch.systemsx.cisd.openbis.generic.shared.util.EqualsHashUtils;
import javax.persistence.FetchType;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.MappedSuperclass;
import javax.persistence.Transient;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.hibernate.validator.NotNull;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@MappedSuperclass
public abstract class EntityTypePE
extends AbstractTypePE {
    private static final long serialVersionUID = 32L;
    private DatabaseInstancePE databaseInstance;

    @Transient
    public abstract EntityKind getEntityKind();

    @ManyToOne(fetch=FetchType.EAGER)
    @NotNull(message="Database instance can not be null.")
    @JoinColumn(name="dbin_id", updatable=false)
    public DatabaseInstancePE getDatabaseInstance() {
        return this.databaseInstance;
    }

    public void setDatabaseInstance(DatabaseInstancePE databaseInstance) {
        this.databaseInstance = databaseInstance;
    }

    public static final <T extends EntityTypePE> T createEntityTypePE(EntityKind entityKind) {
        assert (entityKind != null) : "Unspecified entity kind.";
        return (T)((EntityTypePE)ClassUtils.createInstance(entityKind.getTypeClass()));
    }

    @Override
    ToStringBuilder createStringBuilder() {
        ToStringBuilder builder = super.createStringBuilder();
        builder.append("databaseInstance", (Object)this.getDatabaseInstance());
        return builder;
    }

    @Override
    public boolean equals(Object obj) {
        EqualsHashUtils.assertDefined(this.getCode(), "code");
        EqualsHashUtils.assertDefined(this.getDatabaseInstance(), "database instance");
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof EntityTypePE)) {
            return false;
        }
        EntityTypePE that = (EntityTypePE)obj;
        EqualsBuilder builder = new EqualsBuilder();
        builder.append((Object)this.getCode(), (Object)that.getCode());
        builder.append((Object)this.getDatabaseInstance(), (Object)that.getDatabaseInstance());
        return builder.isEquals();
    }

    @Override
    public int hashCode() {
        HashCodeBuilder builder = new HashCodeBuilder();
        builder.append((Object)this.getCode());
        builder.append((Object)this.getDatabaseInstance());
        return builder.toHashCode();
    }
}

