/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.shared.dto;

import ch.systemsx.cisd.authentication.BasicSession;
import ch.systemsx.cisd.authentication.Principal;
import ch.systemsx.cisd.openbis.generic.shared.dto.IAuthSession;
import ch.systemsx.cisd.openbis.generic.shared.dto.PersonPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.SpacePE;
import org.apache.commons.lang.time.DateFormatUtils;

public final class Session
extends BasicSession
implements IAuthSession {
    private static final String BASE_URL_FALLBACK = "http://localhost/openbis/index.html";
    private static final long serialVersionUID = 1L;
    private PersonPE personOrNull;
    private String baseIndexURL;

    @Deprecated
    public Session() {
    }

    public Session(String user, String sessionToken, Principal principal, String remoteHost, long sessionStart) {
        this(user, sessionToken, principal, remoteHost, sessionStart, 0);
    }

    public Session(String userName, String sessionToken, Principal principal, String remoteHost, long sessionStart, int expirationTime) {
        super(sessionToken, userName, principal, remoteHost, sessionStart, expirationTime);
    }

    public final void setPerson(PersonPE person) {
        this.personOrNull = person;
    }

    public final PersonPE tryGetPerson() {
        return this.personOrNull;
    }

    public final SpacePE tryGetHomeGroup() {
        if (this.personOrNull == null) {
            return null;
        }
        return this.personOrNull.getHomeSpace();
    }

    public final String tryGetHomeGroupCode() {
        SpacePE homeGroup = this.tryGetHomeGroup();
        if (homeGroup == null) {
            return null;
        }
        return homeGroup.getCode();
    }

    public final String getBaseIndexURL() {
        return this.baseIndexURL != null ? this.baseIndexURL : BASE_URL_FALLBACK;
    }

    public final void setBaseIndexURL(String baseIndexURL) {
        this.baseIndexURL = baseIndexURL;
    }

    @Deprecated
    public PersonPE getPerson() {
        return this.personOrNull;
    }

    public String getUserName() {
        return this.personOrNull == null ? super.getUserName() : this.personOrNull.getUserId();
    }

    public final String toString() {
        return "Session{user=" + this.getUserName() + ",space=" + this.tryGetHomeGroupCode() + ",sessionstart=" + DateFormatUtils.format((long)this.getSessionStart(), (String)"yyyy-MM-dd HH:mm:ss") + "}";
    }

    public String getUserEmail() {
        return this.personOrNull == null ? this.getPrincipal().getEmail() : this.personOrNull.getEmail();
    }
}

