/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.shared.dto.properties;

import ch.systemsx.cisd.openbis.generic.shared.dto.DataPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.DataSetPropertyPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.DataSetTypePE;
import ch.systemsx.cisd.openbis.generic.shared.dto.DataSetTypePropertyTypePE;
import ch.systemsx.cisd.openbis.generic.shared.dto.DeletedDataPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.DeletedExperimentPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.DeletedSamplePE;
import ch.systemsx.cisd.openbis.generic.shared.dto.EntityPropertyPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.EntityTypePE;
import ch.systemsx.cisd.openbis.generic.shared.dto.EntityTypePropertyTypePE;
import ch.systemsx.cisd.openbis.generic.shared.dto.ExperimentPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.ExperimentPropertyPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.ExperimentTypePE;
import ch.systemsx.cisd.openbis.generic.shared.dto.ExperimentTypePropertyTypePE;
import ch.systemsx.cisd.openbis.generic.shared.dto.IDeletablePE;
import ch.systemsx.cisd.openbis.generic.shared.dto.IEntityInformationWithPropertiesHolder;
import ch.systemsx.cisd.openbis.generic.shared.dto.MaterialPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.MaterialPropertyPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.MaterialTypePE;
import ch.systemsx.cisd.openbis.generic.shared.dto.MaterialTypePropertyTypePE;
import ch.systemsx.cisd.openbis.generic.shared.dto.SamplePE;
import ch.systemsx.cisd.openbis.generic.shared.dto.SamplePropertyPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.SampleTypePE;
import ch.systemsx.cisd.openbis.generic.shared.dto.SampleTypePropertyTypePE;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum EntityKind {
    MATERIAL("materials", null, "material", MaterialPE.class, null, MaterialTypePE.class, MaterialTypePropertyTypePE.class, MaterialPropertyPE.class),
    EXPERIMENT("experiments", "experiments_all", "experiment", ExperimentPE.class, DeletedExperimentPE.class, ExperimentTypePE.class, ExperimentTypePropertyTypePE.class, ExperimentPropertyPE.class),
    SAMPLE("samples", "samples_all", "sample", SamplePE.class, DeletedSamplePE.class, SampleTypePE.class, SampleTypePropertyTypePE.class, SamplePropertyPE.class),
    DATA_SET("data", "data_all", "dataSet", DataPE.class, DeletedDataPE.class, DataSetTypePE.class, DataSetTypePropertyTypePE.class, DataSetPropertyPE.class);

    private final String entityTableName;
    private final String allEntitiesTableName;
    private final String entityLabel;
    private final transient Class<? extends IEntityInformationWithPropertiesHolder> entityClass;
    private final transient Class<? extends IDeletablePE> deletedEntityClass;
    private final transient Class<?> typeClass;
    private final transient Class<?> assignmentClass;
    private final transient Class<?> propertyClass;

    private EntityKind(String entityTableName, String allEntitiesTableName, String entityLabel, Class<? extends IEntityInformationWithPropertiesHolder> entityClass, Class<? extends IDeletablePE> deletedEntityClass, Class<?> typeClass, Class<?> assignmentClass, Class<?> propertyClass) {
        this.entityTableName = entityTableName;
        this.allEntitiesTableName = allEntitiesTableName;
        this.entityLabel = entityLabel;
        this.entityClass = entityClass;
        this.deletedEntityClass = deletedEntityClass;
        this.typeClass = typeClass;
        this.assignmentClass = assignmentClass;
        this.propertyClass = propertyClass;
    }

    private static final <T> Class<T> cast(Class<?> clazz) {
        return clazz;
    }

    public final String getLabel() {
        return this.entityLabel;
    }

    public final String getTableName() {
        return this.entityTableName;
    }

    public final String getAllTableName() {
        return this.allEntitiesTableName;
    }

    public final <T extends EntityTypePE> Class<T> getTypeClass() {
        return EntityKind.cast(this.typeClass);
    }

    public final <T extends EntityTypePropertyTypePE> Class<T> getEntityTypePropertyTypeAssignmentClass() {
        return EntityKind.cast(this.assignmentClass);
    }

    public final <T extends EntityPropertyPE> Class<T> getEntityPropertyClass() {
        return EntityKind.cast(this.propertyClass);
    }

    public final <T extends IEntityInformationWithPropertiesHolder> Class<T> getEntityClass() {
        return EntityKind.cast(this.entityClass);
    }

    public final <T extends IDeletablePE> Class<T> getDeletedEntityClass() {
        if (this.deletedEntityClass == null) {
            throw new UnsupportedOperationException("No deleted entity class is specified for " + this.name());
        }
        return EntityKind.cast(this.deletedEntityClass);
    }

    public final String getEntityTypeFieldName() {
        return String.valueOf(this.entityLabel) + "Type";
    }
}

