/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.shared.translator;

import ch.systemsx.cisd.openbis.generic.shared.basic.PermlinkUtilities;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.Attachment;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.AttachmentHolderKind;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.AttachmentWithContent;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.NewAttachment;
import ch.systemsx.cisd.openbis.generic.shared.dto.AttachmentContentPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.AttachmentHolderPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.AttachmentPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.ProjectPE;
import ch.systemsx.cisd.openbis.generic.shared.translator.PersonTranslator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class AttachmentTranslator {
    private AttachmentTranslator() {
    }

    private static final Attachment translate(AttachmentPE attachment, String baseIndexURL) {
        if (attachment == null) {
            return null;
        }
        Attachment result = new Attachment();
        result.setPermlink(AttachmentTranslator.createPermlink(attachment, baseIndexURL, false));
        result.setLatestVersionPermlink(AttachmentTranslator.createPermlink(attachment, baseIndexURL, true));
        result.setFileName(attachment.getFileName());
        result.setTitle(attachment.getTitle());
        result.setDescription(attachment.getDescription());
        result.setRegistrator(PersonTranslator.translate(attachment.getRegistrator()));
        result.setRegistrationDate(attachment.getRegistrationDate());
        result.setVersion(attachment.getVersion());
        return result;
    }

    private static String createPermlink(AttachmentPE attachment, String baseIndexURL, boolean latestVersionPermlink) {
        Integer versionOrNull;
        AttachmentHolderPE holder = attachment.getParent();
        String fileName = attachment.getFileName();
        Integer n = versionOrNull = latestVersionPermlink ? null : Integer.valueOf(attachment.getVersion());
        if (holder.getAttachmentHolderKind() == AttachmentHolderKind.PROJECT) {
            ProjectPE project = (ProjectPE)holder;
            return PermlinkUtilities.createProjectAttachmentPermlinkURL(baseIndexURL, fileName, versionOrNull, project.getCode(), project.getSpace().getCode());
        }
        return PermlinkUtilities.createAttachmentPermlinkURL(baseIndexURL, fileName, versionOrNull, holder.getAttachmentHolderKind(), holder.getPermId());
    }

    public static final AttachmentWithContent translateWithContent(AttachmentPE attachment) {
        if (attachment == null) {
            return null;
        }
        AttachmentWithContent result = new AttachmentWithContent();
        result.setFileName(attachment.getFileName());
        result.setTitle(attachment.getTitle());
        result.setDescription(attachment.getDescription());
        result.setRegistrator(PersonTranslator.translate(attachment.getRegistrator()));
        result.setRegistrationDate(attachment.getRegistrationDate());
        result.setVersion(attachment.getVersion());
        result.setContent(attachment.getAttachmentContent().getValue());
        return result;
    }

    public static final List<Attachment> translate(Collection<AttachmentPE> attachments, String baseIndexURL) {
        if (attachments == null) {
            return null;
        }
        ArrayList<Attachment> result = new ArrayList<Attachment>();
        for (AttachmentPE attachment : attachments) {
            result.add(AttachmentTranslator.translate(attachment, baseIndexURL));
        }
        return result;
    }

    public static final AttachmentPE translate(NewAttachment attachment) {
        String fileName = AttachmentTranslator.getFileName(attachment.getFilePath());
        AttachmentContentPE content = new AttachmentContentPE();
        content.setValue(attachment.getContent());
        return AttachmentTranslator.createAttachmentPE(attachment, fileName, content);
    }

    private static String getFileName(String filePath) {
        int lastIndexOfSeparator = filePath.replace('\\', '/').lastIndexOf(47);
        return lastIndexOfSeparator < 0 ? filePath : filePath.substring(lastIndexOfSeparator + 1);
    }

    private static final AttachmentPE createAttachmentPE(NewAttachment attachment, String fileName, AttachmentContentPE content) {
        assert (fileName != null) : "file name not set";
        assert (attachment != null) : "attachment not set";
        assert (content != null) : "content not set";
        AttachmentPE result = new AttachmentPE();
        result.setFileName(fileName);
        result.setDescription(attachment.getDescription());
        result.setTitle(attachment.getTitle());
        result.setAttachmentContent(content);
        return result;
    }
}

