/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.shared.translator;

import ch.systemsx.cisd.openbis.generic.shared.basic.dto.Attachment;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.Project;
import ch.systemsx.cisd.openbis.generic.shared.dto.ProjectPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.identifier.IdentifierHelper;
import ch.systemsx.cisd.openbis.generic.shared.translator.DtoConverters;
import ch.systemsx.cisd.openbis.generic.shared.translator.PersonTranslator;
import ch.systemsx.cisd.openbis.generic.shared.translator.SpaceTranslator;
import ch.systemsx.cisd.openbis.generic.shared.util.HibernateUtils;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ProjectTranslator {
    private ProjectTranslator() {
    }

    public static final List<Project> translate(List<ProjectPE> projects) {
        ArrayList<Project> result = new ArrayList<Project>();
        for (ProjectPE project : projects) {
            result.add(ProjectTranslator.translate(project));
        }
        return result;
    }

    public static final Project translate(ProjectPE project) {
        if (project == null) {
            return null;
        }
        Project result = new Project();
        result.setId(HibernateUtils.getId(project));
        result.setModificationDate(project.getModificationDate());
        result.setCode(project.getCode());
        result.setDescription(project.getDescription());
        result.setSpace(SpaceTranslator.translate(project.getSpace()));
        result.setProjectLeader(PersonTranslator.translate(project.getProjectLeader()));
        result.setRegistrator(PersonTranslator.translate(project.getRegistrator()));
        result.setRegistrationDate(project.getRegistrationDate());
        result.setIdentifier(IdentifierHelper.createProjectIdentifier(project).toString());
        List<Attachment> attachments = DtoConverters.createUnmodifiableEmptyList();
        result.setAttachments(attachments);
        return result;
    }
}

