/*
 * Decompiled with CFR 0.152.
 */
package ch.ethz.bsse.cisd.dsu.tracking.main;

import ch.ethz.bsse.cisd.dsu.tracking.email.EntityTrackingEmailGenerator;
import ch.ethz.bsse.cisd.dsu.tracking.main.FileBasedTrackingDAO;
import ch.ethz.bsse.cisd.dsu.tracking.main.Parameters;
import ch.ethz.bsse.cisd.dsu.tracking.main.TrackingBO;
import ch.ethz.bsse.cisd.dsu.tracking.utils.LogUtils;
import ch.systemsx.cisd.common.exceptions.EnvironmentFailureException;
import ch.systemsx.cisd.common.io.PropertyIOUtils;
import ch.systemsx.cisd.common.logging.LogInitializer;
import ch.systemsx.cisd.common.mail.EMailAddress;
import ch.systemsx.cisd.common.mail.IMailClient;
import ch.systemsx.cisd.common.shared.basic.string.StringUtils;
import ch.systemsx.cisd.common.spring.HttpInvokerUtils;
import ch.systemsx.cisd.openbis.generic.shared.ITrackingServer;
import ch.systemsx.cisd.openbis.generic.shared.dto.SessionContextDTO;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Properties;
import org.apache.commons.io.IOUtils;

public class TrackingClient {
    private static final String SERVICE_PROPERTIES_FILE = "etc/service.properties";
    private static final String LOCAL_STORAGE_FILE = "etc/tracking-local-database";
    private static final String EMAIL_TEMPLATE_FILE = "etc/email-template.txt";
    private static final String OPENBIS_RMI_TRACKING = "/rmi-tracking";

    public static void main(String[] args) {
        try {
            TrackingClient.track();
        }
        catch (EnvironmentFailureException ex) {
            LogUtils.notify(ex);
        }
        catch (Throwable ex) {
            LogUtils.notify(ex);
        }
    }

    private static void track() {
        LogInitializer.init();
        Properties props = PropertyIOUtils.loadProperties(SERVICE_PROPERTIES_FILE);
        Parameters params = new Parameters(props);
        ITrackingServer trackingServer = TrackingClient.createOpenBISTrackingServer(params);
        EntityTrackingEmailGenerator emailGenerator = new EntityTrackingEmailGenerator(props, TrackingClient.retrieveEmailTemplate());
        IMailClient mailClient = params.getMailClient();
        TrackingBO trackingBO = new TrackingBO(trackingServer, emailGenerator, mailClient);
        FileBasedTrackingDAO trackingDAO = new FileBasedTrackingDAO(LOCAL_STORAGE_FILE);
        SessionContextDTO session = TrackingClient.authentificateInOpenBIS(params, trackingServer);
        trackingBO.trackAndNotify(trackingDAO, session);
    }

    private static ITrackingServer createOpenBISTrackingServer(Parameters params) {
        String serviceURL = String.valueOf(params.getOpenbisServerURL()) + OPENBIS_RMI_TRACKING;
        return HttpInvokerUtils.createServiceStub(ITrackingServer.class, serviceURL, 300000L);
    }

    private static SessionContextDTO authentificateInOpenBIS(Parameters params, ITrackingServer trackingServer) {
        try {
            String openbisUser = params.getOpenbisUser();
            SessionContextDTO session = trackingServer.tryAuthenticate(openbisUser, params.getOpenbisPassword());
            if (session == null) {
                throw TrackingClient.createAuthentificationException(params, null);
            }
            trackingServer.setBaseIndexURL(session.getSessionToken(), params.getPermlinkURL());
            return session;
        }
        catch (Exception ex) {
            throw TrackingClient.createAuthentificationException(params, ex);
        }
    }

    private static String retrieveEmailTemplate() {
        try {
            return IOUtils.toString((Reader)new FileReader(new File(EMAIL_TEMPLATE_FILE)));
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw LogUtils.environmentError("Couldn't find email template file '%s'.", EMAIL_TEMPLATE_FILE);
        }
        catch (IOException ex) {
            throw LogUtils.environmentError("Exception has occured while trying to read template file '%s':%s", EMAIL_TEMPLATE_FILE, ex.getMessage());
        }
    }

    private static EnvironmentFailureException createAuthentificationException(Parameters params, Exception exOrNull) {
        String exceptionMsg = exOrNull == null ? "" : " Unexpected exception has occured: " + exOrNull.getMessage();
        EnvironmentFailureException ret = LogUtils.environmentError("Cannot authentificate in openBIS as a user '%s'. Check that the password is correct and that openBIS service URL is correct.%s", params.getOpenbisUser(), exceptionMsg);
        if (!StringUtils.isBlank(params.getAdminEmail())) {
            ArrayList<EMailAddress> adminEmails = new ArrayList<EMailAddress>();
            String[] stringArray = params.getAdminEmail().split(",");
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String adminEmail = stringArray[n2];
                adminEmails.add(new EMailAddress(adminEmail.trim()));
                ++n2;
            }
            IMailClient emailClient = params.getMailClient();
            emailClient.sendEmailMessage("[DSU Tracker] DSU Tracking client NOT working", ret.getLocalizedMessage(), null, new EMailAddress(params.getNotificationEmail()), adminEmails.toArray(new EMailAddress[0]));
        }
        return ret;
    }
}

