/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.etlserver;

import ch.systemsx.cisd.common.filesystem.FileUtilities;
import ch.systemsx.cisd.common.filesystem.IFileOperations;
import ch.systemsx.cisd.common.logging.LogCategory;
import ch.systemsx.cisd.common.logging.LogFactory;
import ch.systemsx.cisd.common.utilities.ITimeProvider;
import ch.systemsx.cisd.common.utilities.SystemTimeProvider;
import ch.systemsx.cisd.etlserver.DssRegistrationLogDirectoryHelper;
import java.io.File;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang.time.FastDateFormat;
import org.apache.log4j.Logger;

public class DssRegistrationLogger {
    private static final Logger notificationLog = LogFactory.getLogger(LogCategory.NOTIFY, DssRegistrationLogger.class);
    private File file;
    private final DssRegistrationLogDirectoryHelper helper;
    private final IFileOperations fileOperations;
    private final ITimeProvider timeProvider;
    private static FastDateFormat simpleNoISODateFormat = FastDateFormat.getInstance((String)"yyyy-MM-dd HH:mm:ss");

    public File getFile() {
        return this.file;
    }

    public DssRegistrationLogger(File file, DssRegistrationLogDirectoryHelper helper, IFileOperations fileOperations) {
        this(file, helper, fileOperations, SystemTimeProvider.SYSTEM_TIME_PROVIDER);
    }

    public DssRegistrationLogger(File file, DssRegistrationLogDirectoryHelper helper, IFileOperations fileOperations, ITimeProvider timeProvider) {
        this.file = file;
        this.helper = helper;
        this.fileOperations = fileOperations;
        this.timeProvider = timeProvider;
    }

    public void registerFailure() {
        if (this.isInFailureState()) {
            return;
        }
        this.moveToDir(this.helper.getFailedDir());
        notificationLog.error("Data set registration failed. See log for details : " + this.file.getAbsolutePath());
    }

    private boolean isInFailureState() {
        return this.helper.getFailedDir().equals(this.file.getParentFile());
    }

    public void registerSuccess() {
        this.moveToDir(this.helper.getSucceededDir());
    }

    public void log(String message) {
        StringBuilder logMessage = new StringBuilder();
        logMessage.append(simpleNoISODateFormat.format(new Date(this.timeProvider.getTimeInMilliseconds())));
        logMessage.append(" ");
        logMessage.append(message);
        logMessage.append("\n");
        FileUtilities.appendToFile(this.file, logMessage.toString(), false);
    }

    public void log(Throwable ex, String message) {
        this.log(String.valueOf(message) + ": " + ex.toString());
    }

    public void logTruncatingIfNecessary(String message) {
        String truncatedMessage = message;
        if (message.length() > 100) {
            truncatedMessage = String.valueOf(message.substring(0, 96)) + "...";
        }
        this.log(truncatedMessage);
    }

    private void moveToDir(File dir) {
        assert (dir.isDirectory());
        this.fileOperations.move(this.file, dir);
        this.file = new File(dir, this.file.getName());
    }

    public void logDssRegistrationResult(List<Throwable> encounteredErrors) {
        if (encounteredErrors.size() == 0) {
            this.registerSuccess();
        } else {
            StringBuilder logMessage = new StringBuilder();
            logMessage.append("Registration failed with the following errors\n");
            for (Throwable error : encounteredErrors) {
                logMessage.append("\t");
                logMessage.append(error.toString());
            }
            this.log(logMessage.toString());
            this.registerFailure();
        }
    }
}

