/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.dss.generic.server.api.v1;

import ch.systemsx.cisd.base.exceptions.CheckedExceptionTunnel;
import ch.systemsx.cisd.base.exceptions.IOExceptionUnchecked;
import ch.systemsx.cisd.common.exceptions.UserFailureException;
import ch.systemsx.cisd.common.filesystem.FileUtilities;
import ch.systemsx.cisd.common.filesystem.IFreeSpaceProvider;
import ch.systemsx.cisd.common.filesystem.SimpleFreeSpaceProvider;
import ch.systemsx.cisd.common.logging.Log4jSimpleLogger;
import ch.systemsx.cisd.common.logging.LogCategory;
import ch.systemsx.cisd.common.logging.LogFactory;
import ch.systemsx.cisd.etlserver.api.v1.PutDataSetService;
import ch.systemsx.cisd.etlserver.plugins.DataSetMover;
import ch.systemsx.cisd.etlserver.plugins.IDataSetMover;
import ch.systemsx.cisd.openbis.common.io.hierarchical_content.HierarchicalContentUtils;
import ch.systemsx.cisd.openbis.common.io.hierarchical_content.api.IHierarchicalContent;
import ch.systemsx.cisd.openbis.common.io.hierarchical_content.api.IHierarchicalContentNode;
import ch.systemsx.cisd.openbis.common.spring.IInvocationLoggerContext;
import ch.systemsx.cisd.openbis.dss.generic.server.AbstractDssServiceRpc;
import ch.systemsx.cisd.openbis.dss.generic.server.IStreamRepository;
import ch.systemsx.cisd.openbis.dss.generic.server.SessionWorkspaceProvider;
import ch.systemsx.cisd.openbis.dss.generic.server.api.v1.DssServiceRpcGenericLogger;
import ch.systemsx.cisd.openbis.dss.generic.server.plugins.tasks.IPluginTaskInfoProvider;
import ch.systemsx.cisd.openbis.dss.generic.shared.IDataStoreServiceInternal;
import ch.systemsx.cisd.openbis.dss.generic.shared.IEncapsulatedOpenBISService;
import ch.systemsx.cisd.openbis.dss.generic.shared.IHierarchicalContentProvider;
import ch.systemsx.cisd.openbis.dss.generic.shared.IShareIdManager;
import ch.systemsx.cisd.openbis.dss.generic.shared.ServiceProvider;
import ch.systemsx.cisd.openbis.dss.generic.shared.api.internal.authorization.IDssServiceRpcGenericInternal;
import ch.systemsx.cisd.openbis.dss.generic.shared.api.v1.DataSetFileDTO;
import ch.systemsx.cisd.openbis.dss.generic.shared.api.v1.FileInfoDssDTO;
import ch.systemsx.cisd.openbis.dss.generic.shared.api.v1.HierarchicalFileInfoDssBuilder;
import ch.systemsx.cisd.openbis.dss.generic.shared.api.v1.NewDataSetDTO;
import ch.systemsx.cisd.openbis.dss.generic.shared.api.v1.ShareInfo;
import ch.systemsx.cisd.openbis.dss.generic.shared.utils.DatasetLocationUtil;
import ch.systemsx.cisd.openbis.dss.generic.shared.utils.SegmentedStoreUtils;
import ch.systemsx.cisd.openbis.dss.generic.shared.utils.Share;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.AbstractExternalData;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.PhysicalDataSet;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.TableModel;
import ch.systemsx.cisd.openbis.generic.shared.dto.DatasetDescription;
import ch.systemsx.cisd.openbis.generic.shared.dto.SessionContextDTO;
import ch.systemsx.cisd.openbis.generic.shared.translator.DataSetTranslator;
import ch.systemsx.cisd.openbis.plugin.query.shared.api.v1.IQueryApiServer;
import ch.systemsx.cisd.openbis.plugin.query.shared.api.v1.dto.AggregationServiceDescription;
import ch.systemsx.cisd.openbis.plugin.query.shared.api.v1.dto.QueryTableModel;
import ch.systemsx.cisd.openbis.plugin.query.shared.api.v1.dto.ReportDescription;
import ch.systemsx.cisd.openbis.plugin.query.shared.translator.QueryTableModelTranslator;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;
import org.apache.log4j.Logger;

public class DssServiceRpcGeneric
extends AbstractDssServiceRpc<IDssServiceRpcGenericInternal>
implements IDssServiceRpcGenericInternal {
    protected static Logger operationLog = LogFactory.getLogger(LogCategory.OPERATION, DssServiceRpcGeneric.class);
    private final PutDataSetService putService;
    private final IQueryApiServer queryApiServer;
    private final File sessionWorkspaceRootDirectory;
    private final IFreeSpaceProvider freeSpaceProvider;
    private IDataSetMover dataSetMover;
    private String dataStoreCode;

    public DssServiceRpcGeneric(IEncapsulatedOpenBISService openBISService, IQueryApiServer apiServer, IPluginTaskInfoProvider infoProvider) {
        this(openBISService, apiServer, infoProvider, new SimpleFreeSpaceProvider(), null, null);
    }

    DssServiceRpcGeneric(IEncapsulatedOpenBISService openBISService, IQueryApiServer apiServer, IPluginTaskInfoProvider infoProvider, IFreeSpaceProvider freeSpaceProvider, IShareIdManager shareIdManager, IHierarchicalContentProvider contentProvider) {
        this(openBISService, apiServer, infoProvider, null, freeSpaceProvider, shareIdManager, contentProvider, new PutDataSetService(openBISService, operationLog));
    }

    public DssServiceRpcGeneric(IEncapsulatedOpenBISService openBISService, IQueryApiServer apiServer, IPluginTaskInfoProvider infoProvider, IStreamRepository streamRepository, IFreeSpaceProvider freeSpaceProvider, IShareIdManager shareIdManager, IHierarchicalContentProvider contentProvider, PutDataSetService service) {
        super(openBISService, streamRepository, shareIdManager, contentProvider);
        this.queryApiServer = apiServer;
        this.freeSpaceProvider = freeSpaceProvider;
        this.putService = service;
        this.sessionWorkspaceRootDirectory = infoProvider.getSessionWorkspaceRootDir();
        operationLog.info("[rpc] Started DSS API V1 service.");
    }

    public void setDataStoreCode(String dataStoreCode) {
        this.dataStoreCode = dataStoreCode;
    }

    void setDataSetMover(IDataSetMover dataSetMover) {
        this.dataSetMover = dataSetMover;
    }

    @Override
    public IDssServiceRpcGenericInternal createLogger(IInvocationLoggerContext context) {
        return new DssServiceRpcGenericLogger(context);
    }

    @Override
    public FileInfoDssDTO[] listFilesForDataSet(String sessionToken, String dataSetCode, String startPath, boolean isRecursive) throws IllegalArgumentException {
        IHierarchicalContent content = null;
        try {
            content = this.getHierarchicalContent(sessionToken, dataSetCode);
            IHierarchicalContentNode startPathNode = this.getContentNode(content, startPath);
            ArrayList<FileInfoDssDTO> list = new ArrayList<FileInfoDssDTO>();
            if (startPathNode.isDirectory()) {
                this.appendFileInfosForFile(startPathNode, list, isRecursive);
            } else {
                list.add(new FileInfoDssDTO(startPathNode.getRelativePath(), startPathNode.getName(), false, startPathNode.getFileLength(), startPathNode.isChecksumCRC32Precalculated() ? Integer.valueOf(startPathNode.getChecksumCRC32()) : null));
            }
            FileInfoDssDTO[] fileInfos = new FileInfoDssDTO[list.size()];
            FileInfoDssDTO[] fileInfoDssDTOArray = list.toArray(fileInfos);
            return fileInfoDssDTOArray;
        }
        catch (IOException ex) {
            operationLog.info("listFiles: " + startPath + " caused an exception", ex);
            throw new IOExceptionUnchecked(ex);
        }
        catch (RuntimeException ex) {
            operationLog.info("listFiles: " + startPath + " caused an exception", ex);
            throw ex;
        }
        finally {
            if (content != null) {
                content.close();
            }
        }
    }

    @Override
    public InputStream getFileForDataSet(String sessionToken, String dataSetCode, String path) throws IOExceptionUnchecked, IllegalArgumentException {
        IHierarchicalContent content = null;
        try {
            content = this.getHierarchicalContent(sessionToken, dataSetCode);
            IHierarchicalContentNode contentNode = this.getContentNode(content, path);
            return HierarchicalContentUtils.getInputStreamAutoClosingContent(contentNode, content);
        }
        catch (RuntimeException ex) {
            operationLog.info("getFile: " + path + " caused an exception", ex);
            if (content != null) {
                content.close();
            }
            throw ex;
        }
    }

    @Override
    public String getDownloadUrlForFileForDataSet(String sessionToken, String dataSetCode, String path) throws IOExceptionUnchecked, IllegalArgumentException {
        InputStream stream = this.getFileForDataSet(sessionToken, dataSetCode, path);
        return this.addToRepositoryAndReturnDownloadUrl(stream, path, 0L);
    }

    @Override
    public String getDownloadUrlForFileForDataSetWithTimeout(String sessionToken, String dataSetCode, String path, long validityDurationInSeconds) throws IOExceptionUnchecked, IllegalArgumentException {
        InputStream stream = this.getFileForDataSet(sessionToken, dataSetCode, path);
        return this.addToRepositoryAndReturnDownloadUrl(stream, path, validityDurationInSeconds);
    }

    private IHierarchicalContentNode getContentNode(IHierarchicalContent content, String startPath) {
        return content.getNode(startPath.startsWith("/") ? startPath.substring(1) : startPath);
    }

    @Override
    public String putDataSet(String sessionToken, NewDataSetDTO newDataSet, InputStream inputStream) throws IOExceptionUnchecked, IllegalArgumentException {
        return this.putService.putDataSet(sessionToken, newDataSet, inputStream);
    }

    @Override
    public long putFileToSessionWorkspace(String sessionToken, String filePath, InputStream inputStream) throws IOExceptionUnchecked {
        long l;
        this.getOpenBISService().checkSession(sessionToken);
        if (filePath.contains("../")) {
            throw new IOExceptionUnchecked("filePath must not contain '../'");
        }
        String subDir = FilenameUtils.getFullPath((String)filePath);
        String filename = FilenameUtils.getName((String)filePath);
        File workspaceDir = new SessionWorkspaceProvider(this.sessionWorkspaceRootDirectory, sessionToken).getSessionWorkspace();
        File dir = new File(workspaceDir, subDir);
        dir.mkdirs();
        File file = new File(dir, filename);
        FileOutputStream ostream = null;
        try {
            ostream = new FileOutputStream(file);
            long size = IOUtils.copyLarge((InputStream)inputStream, (OutputStream)ostream);
            ((OutputStream)ostream).close();
            l = size;
        }
        catch (IOException ex) {
            try {
                file.delete();
                throw CheckedExceptionTunnel.wrapIfNecessary(ex);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(ostream);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((OutputStream)ostream);
        return l;
    }

    @Override
    public long putFileSliceToSessionWorkspace(String sessionToken, String filePath, long slicePosition, InputStream sliceInputStream) throws IOExceptionUnchecked {
        this.getOpenBISService().checkSession(sessionToken);
        if (filePath.contains("../")) {
            throw new IOExceptionUnchecked("filePath must not contain '../'");
        }
        String subDir = FilenameUtils.getFullPath((String)filePath);
        String filename = FilenameUtils.getName((String)filePath);
        File workspaceDir = new SessionWorkspaceProvider(this.sessionWorkspaceRootDirectory, sessionToken).getSessionWorkspace();
        File dir = new File(workspaceDir, subDir);
        dir.mkdirs();
        File file = new File(dir, filename);
        return FileUtilities.writeToFile(file, slicePosition, sliceInputStream);
    }

    @Override
    public InputStream getFileFromSessionWorkspace(String sessionToken, String filePath) throws IOExceptionUnchecked {
        this.getOpenBISService().checkSession(sessionToken);
        if (filePath.contains("../")) {
            throw new IOExceptionUnchecked("filePath must not contain '../'");
        }
        File workspaceDir = new SessionWorkspaceProvider(this.sessionWorkspaceRootDirectory, sessionToken).getSessionWorkspace();
        File file = new File(workspaceDir, filePath);
        try {
            return new FileInputStream(file);
        }
        catch (FileNotFoundException ex) {
            throw new IOExceptionUnchecked(ex);
        }
    }

    @Override
    public boolean deleteSessionWorkspaceFile(String sessionToken, String path) {
        this.getOpenBISService().checkSession(sessionToken);
        if (path.contains("../")) {
            throw new IOExceptionUnchecked("path must not contain '../'");
        }
        File workspaceDir = new SessionWorkspaceProvider(this.sessionWorkspaceRootDirectory, sessionToken).getSessionWorkspace();
        File file = new File(workspaceDir, path);
        FileUtilities.deleteRecursively(file);
        return !file.exists();
    }

    @Override
    public int getMajorVersion() {
        return 1;
    }

    @Override
    public int getMinorVersion() {
        return 7;
    }

    private void appendFileInfosForFile(IHierarchicalContentNode listingRootNode, ArrayList<FileInfoDssDTO> list, boolean isRecursive) throws IOException {
        HierarchicalFileInfoDssBuilder factory = new HierarchicalFileInfoDssBuilder(listingRootNode);
        factory.appendFileInfos(list, isRecursive);
    }

    @Override
    public InputStream getFileForDataSet(String sessionToken, DataSetFileDTO fileOrFolder) throws IOExceptionUnchecked, IllegalArgumentException {
        return this.getFileForDataSet(sessionToken, fileOrFolder.getDataSetCode(), fileOrFolder.getPath());
    }

    @Override
    public String getDownloadUrlForFileForDataSet(String sessionToken, DataSetFileDTO fileOrFolder) throws IOExceptionUnchecked, IllegalArgumentException {
        InputStream stream = this.getFileForDataSet(sessionToken, fileOrFolder);
        return this.addToRepositoryAndReturnDownloadUrl(stream, fileOrFolder.getPath(), 0L);
    }

    @Override
    public String getDownloadUrlForFileForDataSetWithTimeout(String sessionToken, DataSetFileDTO fileOrFolder, long validityDurationInSeconds) throws IOExceptionUnchecked, IllegalArgumentException {
        InputStream stream = this.getFileForDataSet(sessionToken, fileOrFolder);
        return this.addToRepositoryAndReturnDownloadUrl(stream, fileOrFolder.getPath(), validityDurationInSeconds);
    }

    @Override
    public FileInfoDssDTO[] listFilesForDataSet(String sessionToken, DataSetFileDTO fileOrFolder) throws IOExceptionUnchecked, IllegalArgumentException {
        return this.listFilesForDataSet(sessionToken, fileOrFolder.getDataSetCode(), fileOrFolder.getPath(), fileOrFolder.isRecursive());
    }

    @Override
    public void setStoreDirectory(File aFile) {
        super.setStoreDirectory(aFile);
        this.putService.setStoreDirectory(aFile);
    }

    @Override
    public String getPathToDataSet(String sessionToken, String dataSetCode, String overrideStoreRootPathOrNull) throws IOExceptionUnchecked, IllegalArgumentException {
        File dataSetRootDirectory = DatasetLocationUtil.getDatasetLocationPath(this.getStoreDirectory(), dataSetCode, this.getShareIdManager().getShareId(dataSetCode), this.getHomeDatabaseInstance().getUuid());
        if (!dataSetRootDirectory.exists()) {
            throw new IllegalArgumentException("Path to dataset '" + dataSetCode + "' not available: this is a container dataset.");
        }
        return DssServiceRpcGeneric.convertPath(this.getStoreDirectory(), dataSetRootDirectory, overrideStoreRootPathOrNull);
    }

    @Override
    public List<ShareInfo> listAllShares(String sessionToken) {
        this.getOpenBISService().checkSession(sessionToken);
        List<Share> shares = SegmentedStoreUtils.getSharesWithDataSets(this.getStoreDirectory(), this.dataStoreCode, false, Collections.<String>emptySet(), this.freeSpaceProvider, this.getOpenBISService(), new Log4jSimpleLogger(operationLog));
        ArrayList<ShareInfo> result = new ArrayList<ShareInfo>();
        for (Share share : shares) {
            ShareInfo shareInfo = new ShareInfo(share.getShareId(), share.calculateFreeSpace());
            shareInfo.setIgnoredForShuffling(shareInfo.isIgnoredForShuffling());
            shareInfo.setIncoming(share.isIncoming());
            shareInfo.setWithdrawShare(share.isWithdrawShare());
            result.add(shareInfo);
        }
        return result;
    }

    @Override
    public void shuffleDataSet(String sessionToken, String dataSetCode, String shareId) {
        this.getOpenBISService().checkSession(sessionToken);
        AbstractExternalData dataSet = this.getOpenBISService().tryGetDataSet(dataSetCode);
        if (dataSet == null) {
            throw new UserFailureException("Unknown data set: " + dataSetCode);
        }
        if (dataSet.isContainer()) {
            throw new UserFailureException("Container data set: " + dataSetCode);
        }
        PhysicalDataSet realDataSet = dataSet.tryGetAsDataSet();
        String dataSetLocation = realDataSet.getDataSetLocation();
        if (realDataSet.getShareId().equals(shareId)) {
            throw new UserFailureException("Data set " + dataSetCode + " is already in share " + shareId + ".");
        }
        File share = new File(this.getStoreDirectory(), this.getShareIdManager().getShareId(dataSetCode));
        File newShare = new File(this.getStoreDirectory(), shareId);
        if (!newShare.exists()) {
            throw new UserFailureException("Share does not exists: " + newShare.getAbsolutePath());
        }
        if (!newShare.isDirectory()) {
            throw new UserFailureException("Share is not a directory: " + newShare.getAbsolutePath());
        }
        this.getDataSetMover().moveDataSetToAnotherShare(new File(share, dataSetLocation), newShare, null, new Log4jSimpleLogger(operationLog));
    }

    private IDataSetMover getDataSetMover() {
        if (this.dataSetMover == null) {
            this.dataSetMover = new DataSetMover(this.getOpenBISService(), this.getShareIdManager());
        }
        return this.dataSetMover;
    }

    public static String convertPath(File storeRoot, File dataSetRoot, String overrideStoreRootPathOrNull) {
        String dataStoreRootPath = storeRoot.getAbsolutePath();
        String dataSetPath = dataSetRoot.getAbsolutePath();
        if (overrideStoreRootPathOrNull == null || !dataSetPath.startsWith(dataStoreRootPath)) {
            return dataSetPath;
        }
        File usersPath = new File(overrideStoreRootPathOrNull, dataSetPath.substring(dataStoreRootPath.length()));
        return usersPath.getPath();
    }

    @Override
    public String getValidationScript(String sessionToken, String dataSetTypeOrNull) throws IOExceptionUnchecked, IllegalArgumentException {
        return this.putService.getValidationScript(dataSetTypeOrNull);
    }

    @Override
    public QueryTableModel createReportFromAggregationService(String sessionToken, String aggregationServiceName, Map<String, Object> parameters) {
        IEncapsulatedOpenBISService openBisService = this.getOpenBISService();
        IDataStoreServiceInternal service = ServiceProvider.getDataStoreService();
        SessionContextDTO sessionContext = openBisService.tryGetSession(sessionToken);
        TableModel tableModel = service.internalCreateReportFromAggregationService(sessionToken, aggregationServiceName, parameters, sessionContext.getUserName(), sessionContext.getUserEmail());
        return new QueryTableModelTranslator(tableModel).translate();
    }

    @Override
    public QueryTableModel createReportFromDataSets(String sessionToken, String serviceKey, List<String> dataSetCodes) {
        IEncapsulatedOpenBISService openBisService = this.getOpenBISService();
        IDataStoreServiceInternal service = ServiceProvider.getDataStoreService();
        SessionContextDTO sessionContext = openBisService.tryGetSession(sessionToken);
        ArrayList<DatasetDescription> dataSetDescriptions = new ArrayList<DatasetDescription>();
        for (String dataSetCode : dataSetCodes) {
            AbstractExternalData dataSet = this.getOpenBISService().tryGetDataSet(dataSetCode);
            dataSetDescriptions.add(DssServiceRpcGeneric.translateToDescription(dataSet));
        }
        TableModel tableModel = service.internalCreateReportFromDatasets(sessionToken, serviceKey, dataSetDescriptions, sessionContext.getUserName(), sessionContext.getUserEmail());
        return new QueryTableModelTranslator(tableModel).translate();
    }

    private static DatasetDescription translateToDescription(AbstractExternalData dataSet) {
        return DataSetTranslator.translateToDescription(dataSet);
    }

    @Override
    public List<AggregationServiceDescription> listAggregationServices(String sessionToken) {
        return this.queryApiServer.listAggregationServices(sessionToken);
    }

    @Override
    public List<ReportDescription> listTableReportDescriptions(String sessionToken) {
        return this.queryApiServer.listTableReportDescriptions(sessionToken);
    }
}

