/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.client.web.client.application;

import ch.systemsx.cisd.openbis.generic.client.web.client.application.IViewContext;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.TabContent;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.framework.IDatabaseModificationObserver;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.grid.IDisposableComponent;
import ch.systemsx.cisd.openbis.generic.shared.basic.IIdHolder;

public abstract class DisposableTabContent
extends TabContent {
    protected IDisposableComponent disposableComponentOrNull = null;

    protected abstract IDisposableComponent createDisposableContent();

    public DisposableTabContent(String header, IViewContext<?> viewContext, IIdHolder ownerIdOrNull) {
        super(header, viewContext, ownerIdOrNull);
    }

    public IDatabaseModificationObserver tryGetDatabaseModificationObserver() {
        return this.disposableComponentOrNull;
    }

    public IDisposableComponent tryGetDisposableComponentOrNull() {
        return this.disposableComponentOrNull;
    }

    @Override
    public void disposeComponents() {
        if (this.disposableComponentOrNull != null) {
            this.disposableComponentOrNull.dispose();
        }
    }

    @Override
    protected void showContent() {
        IDisposableComponent contentOrNull = this.createDisposableContent();
        if (contentOrNull != null) {
            this.updateContent(contentOrNull, false);
        }
    }

    protected void updateContent(IDisposableComponent content, boolean syncNeeded) {
        if (content != null) {
            this.disposableComponentOrNull = content;
            this.add(content.getComponent());
            if (syncNeeded) {
                this.syncSize();
            }
        }
    }

    protected void replaceContent(IDisposableComponent content) {
        if (content != null) {
            this.removeAll();
            this.disposeComponents();
            this.updateContent(content, true);
        }
    }
}

