/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.vocabulary;

import ch.systemsx.cisd.openbis.generic.client.web.client.ICommonClientServiceAsync;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.FormPanelListener;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.IViewContext;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.AbstractRegistrationForm;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.vocabulary.VocabularyRegistrationFieldSet;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.NewVocabulary;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.Vocabulary;
import com.extjs.gxt.ui.client.event.ButtonEvent;
import com.extjs.gxt.ui.client.event.Events;
import com.extjs.gxt.ui.client.event.SelectionListener;
import com.google.gwt.user.client.ui.Widget;

public final class VocabularyRegistrationForm
extends AbstractRegistrationForm {
    private static final String PREFIX = "vocabulary-registration_";
    public static final String ID_PREFIX = "openbis_vocabulary-registration_";
    public static final String ID = "openbis_vocabulary-registration_form";
    protected final IViewContext<ICommonClientServiceAsync> viewContext;
    protected final String termsSessionKey;
    protected final VocabularyRegistrationFieldSet vocabularyRegistrationFieldSet;

    public VocabularyRegistrationForm(IViewContext<ICommonClientServiceAsync> viewContext) {
        super(viewContext, ID);
        this.setResetButtonVisible(true);
        this.viewContext = viewContext;
        this.termsSessionKey = "openbis_vocabulary-registration_form_terms";
        this.vocabularyRegistrationFieldSet = new VocabularyRegistrationFieldSet(viewContext, this.getId(), this.labelWidth, this.fieldWidth - 40, this.termsSessionKey);
        this.addUploadFeatures();
        this.formPanel.add((Widget)this.vocabularyRegistrationFieldSet);
    }

    @Override
    protected final void submitValidForm() {
        NewVocabulary vocabulary = this.vocabularyRegistrationFieldSet.createVocabulary();
        this.viewContext.getService().registerVocabulary(this.termsSessionKey, vocabulary, new VocabularyRegistrationCallback(this.viewContext, vocabulary));
    }

    private void addUploadFeatures() {
        this.addFormSubmitListener();
        this.redefineSaveListeners();
        this.addUploadFeatures(this.termsSessionKey);
    }

    private void addFormSubmitListener() {
        this.formPanel.addListener(Events.Submit, new FormPanelListener(this.infoBox){

            @Override
            protected void onSuccessfullUpload() {
                VocabularyRegistrationForm.this.submitValidForm();
            }

            @Override
            protected void setUploadEnabled() {
                VocabularyRegistrationForm.this.setUploadEnabled(true);
            }
        });
    }

    private void redefineSaveListeners() {
        this.saveButton.removeAllListeners();
        this.addSaveButtonConfirmationListener();
        this.saveButton.addSelectionListener((SelectionListener)new SelectionListener<ButtonEvent>(){

            public final void componentSelected(ButtonEvent ce) {
                if (VocabularyRegistrationForm.this.formPanel.isValid()) {
                    if (VocabularyRegistrationForm.this.vocabularyRegistrationFieldSet.isUploadFileDefined()) {
                        VocabularyRegistrationForm.this.setUploadEnabled(false);
                        VocabularyRegistrationForm.this.formPanel.submit();
                    } else {
                        VocabularyRegistrationForm.this.submitValidForm();
                    }
                }
            }
        });
    }

    private final class VocabularyRegistrationCallback
    extends AbstractRegistrationForm.AbstractRegistrationCallback<Void> {
        private final Vocabulary vocabulary;

        VocabularyRegistrationCallback(IViewContext<?> viewContext, Vocabulary vocabulary) {
            super(viewContext);
            this.vocabulary = vocabulary;
        }

        @Override
        protected String createSuccessfullRegistrationInfo(Void result) {
            return "Vocabulary <b>" + this.vocabulary.getCode() + "</b> successfully registered.";
        }
    }
}

