/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.server.dataaccess.db.search;

import ch.systemsx.cisd.common.logging.LogCategory;
import ch.systemsx.cisd.common.logging.LogFactory;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.db.search.IFullTextIndexer;
import java.io.Serializable;
import java.util.List;
import org.apache.log4j.Logger;
import org.hibernate.CacheMode;
import org.hibernate.Criteria;
import org.hibernate.FlushMode;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Projection;
import org.hibernate.criterion.Projections;
import org.hibernate.criterion.Restrictions;
import org.hibernate.search.FullTextSession;
import org.hibernate.search.Search;
import org.springframework.dao.DataAccessException;

final class DefaultFullTextIndexer
implements IFullTextIndexer {
    private static final Logger operationLog = LogFactory.getLogger(LogCategory.OPERATION, DefaultFullTextIndexer.class);
    private static String ID_PROPERTY_NAME = "id";
    private final int batchSize;

    DefaultFullTextIndexer(int batchSize) {
        assert (batchSize > -1) : "Batch size can not be negative.";
        this.batchSize = batchSize;
    }

    @Override
    public final <T> void doFullTextIndex(Session hibernateSession, Class<T> clazz) throws DataAccessException {
        operationLog.info(String.format("Indexing '%s'...", clazz.getSimpleName()));
        FullTextSession fullTextSession = DefaultFullTextIndexer.getFullTextSession(hibernateSession);
        this.doFullTextIndex(fullTextSession, clazz);
    }

    <T> void doFullTextIndex(FullTextSession fullTextSession, Class<T> clazz) {
        block3: {
            Transaction transaction = null;
            try {
                transaction = fullTextSession.beginTransaction();
                List<Long> ids = DefaultFullTextIndexer.getAllIds(fullTextSession, clazz);
                int idsSize = ids.size();
                operationLog.info(String.format("... got %d '%s' ids...", idsSize, clazz.getSimpleName()));
                int index = 0;
                while (index < idsSize) {
                    int nextIndex = index + this.batchSize;
                    long minId = ids.get(index);
                    long maxId = nextIndex < idsSize ? ids.get(nextIndex) : Integer.MAX_VALUE;
                    List<T> results = DefaultFullTextIndexer.listEntitiesWithRestrictedId(fullTextSession, clazz, minId, maxId);
                    DefaultFullTextIndexer.indexEntities(fullTextSession, results);
                    operationLog.info(String.format("%d/%d %ss have been indexed...", Math.min(nextIndex, idsSize), idsSize, clazz.getSimpleName()));
                    index += this.batchSize;
                }
                fullTextSession.getSearchFactory().optimize(clazz);
                transaction.commit();
                operationLog.info(String.format("'%s' index complete. %d entities have been indexed.", clazz.getSimpleName(), idsSize));
            }
            catch (Exception e) {
                operationLog.error(e.getMessage());
                if (transaction == null) break block3;
                transaction.rollback();
            }
        }
    }

    @Override
    public <T> void doFullTextIndexUpdate(Session hibernateSession, Class<T> clazz, List<Long> ids) throws DataAccessException {
        block3: {
            operationLog.info(String.format("Reindexing %s %ss...", ids.size(), clazz.getSimpleName()));
            FullTextSession fullTextSession = DefaultFullTextIndexer.getFullTextSession(hibernateSession);
            Transaction transaction = null;
            try {
                transaction = fullTextSession.beginTransaction();
                int maxIndex = ids.size();
                int index = 0;
                while (index < maxIndex) {
                    int nextIndex = this.getNextIndex(index, maxIndex);
                    List<Long> subList = ids.subList(index, nextIndex);
                    List<T> results = DefaultFullTextIndexer.listEntitiesWithRestrictedId(fullTextSession, clazz, subList);
                    DefaultFullTextIndexer.indexEntities(fullTextSession, results);
                    index = nextIndex;
                    operationLog.info(String.format("%d/%d %ss have been reindexed...", index, maxIndex, clazz.getSimpleName()));
                }
                fullTextSession.getSearchFactory().optimize(clazz);
                transaction.commit();
                operationLog.info(String.format("'%s' index is updated. %d entities have been reindexed.", clazz.getSimpleName(), index));
            }
            catch (Exception e) {
                operationLog.error(e.getMessage());
                if (transaction == null) break block3;
                transaction.rollback();
            }
        }
    }

    @Override
    public <T> void removeFromIndex(Session hibernateSession, Class<T> clazz, List<Long> ids) throws DataAccessException {
        block3: {
            operationLog.info(String.format("Removing %s %ss...", ids.size(), clazz.getSimpleName()));
            FullTextSession fullTextSession = DefaultFullTextIndexer.getFullTextSession(hibernateSession);
            Transaction transaction = null;
            try {
                transaction = fullTextSession.beginTransaction();
                for (Long id : ids) {
                    fullTextSession.purge(clazz, (Serializable)id);
                }
                fullTextSession.getSearchFactory().optimize(clazz);
                transaction.commit();
                operationLog.info(String.format("'%s' index is updated. %d entities have been removed.", clazz.getSimpleName(), ids.size()));
            }
            catch (Exception e) {
                operationLog.error(e.getMessage());
                if (transaction == null) break block3;
                transaction.rollback();
            }
        }
    }

    private int getNextIndex(int index, int maxIndex) {
        return Math.min(index + this.batchSize, maxIndex);
    }

    private static final FullTextSession getFullTextSession(Session hibernateSession) {
        FullTextSession fullTextSession = Search.getFullTextSession((Session)hibernateSession);
        fullTextSession.setFlushMode(FlushMode.MANUAL);
        fullTextSession.setCacheMode(CacheMode.IGNORE);
        return fullTextSession;
    }

    private static final <T> void indexEntities(FullTextSession fullTextSession, List<T> entities) {
        for (T entity : entities) {
            DefaultFullTextIndexer.indexEntity(fullTextSession, entity);
        }
        fullTextSession.flushToIndexes();
        fullTextSession.clear();
    }

    private static final <T> List<Long> getAllIds(FullTextSession fullTextSession, Class<T> clazz) {
        Criteria criteria = DefaultFullTextIndexer.createCriteria(fullTextSession, clazz).setProjection((Projection)Projections.property((String)ID_PROPERTY_NAME)).addOrder(Order.asc((String)ID_PROPERTY_NAME));
        return DefaultFullTextIndexer.list(criteria);
    }

    private static final <T> List<T> listEntitiesWithRestrictedId(FullTextSession fullTextSession, Class<T> clazz, long minId, long maxId) {
        Criteria criteria = DefaultFullTextIndexer.createCriteria(fullTextSession, clazz).add((Criterion)Restrictions.ge((String)ID_PROPERTY_NAME, (Object)minId)).add((Criterion)Restrictions.lt((String)ID_PROPERTY_NAME, (Object)maxId));
        return DefaultFullTextIndexer.list(criteria);
    }

    private static final <T> List<T> listEntitiesWithRestrictedId(FullTextSession fullTextSession, Class<T> clazz, List<Long> ids) {
        Criteria criteria = DefaultFullTextIndexer.createCriteria(fullTextSession, clazz).add(Restrictions.in((String)ID_PROPERTY_NAME, ids));
        return DefaultFullTextIndexer.list(criteria);
    }

    private static final <T> Criteria createCriteria(FullTextSession fullTextSession, Class<T> clazz) {
        return fullTextSession.createCriteria(clazz);
    }

    private static final <T> List<T> list(Criteria criteria) {
        return criteria.list();
    }

    private static final <T> void indexEntity(FullTextSession fullTextSession, T entity) {
        if (operationLog.isDebugEnabled()) {
            operationLog.debug(String.format("Indexing entity '%s'.", entity));
        }
        try {
            fullTextSession.index(entity);
        }
        catch (Exception e) {
            operationLog.error("Error while indexing the entity " + entity + ": " + e.getMessage() + ". Indexing will be continued.");
        }
    }
}

