/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.server.jython.api.v1.impl;

import ch.systemsx.cisd.openbis.generic.server.jython.api.v1.EntityKind;
import ch.systemsx.cisd.openbis.generic.server.jython.api.v1.IDataSetTypeImmutable;
import ch.systemsx.cisd.openbis.generic.server.jython.api.v1.IScriptImmutable;
import ch.systemsx.cisd.openbis.generic.server.jython.api.v1.impl.ScriptHelper;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.DataSetKind;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.DataSetType;

public class DataSetTypeImmutable
implements IDataSetTypeImmutable {
    private final DataSetType dataSetType;

    DataSetTypeImmutable(String code) {
        this(new DataSetType());
        this.getDataSetType().setCode(code);
    }

    DataSetTypeImmutable(DataSetType dataSetType) {
        this.dataSetType = dataSetType;
    }

    DataSetType getDataSetType() {
        return this.dataSetType;
    }

    @Override
    public String getCode() {
        return this.getDataSetType().getCode();
    }

    @Override
    public String getDescription() {
        return this.getDataSetType().getDescription();
    }

    @Override
    public boolean isContainerType() {
        return DataSetKind.CONTAINER == this.getDataSetType().getDataSetKind();
    }

    @Override
    public boolean isLinkType() {
        return DataSetKind.LINK == this.getDataSetType().getDataSetKind();
    }

    @Override
    public String getDataSetKind() {
        DataSetKind kind = this.getDataSetType().getDataSetKind();
        return kind == null ? null : kind.name();
    }

    @Override
    public boolean isDeletionDisallowed() {
        return this.getDataSetType().isDeletionDisallow();
    }

    @Override
    public EntityKind getEntityKind() {
        return EntityKind.DATA_SET;
    }

    @Override
    public String getMainDataSetPattern() {
        return this.getDataSetType().getMainDataSetPattern();
    }

    @Override
    public String getMainDataSetPath() {
        return this.getDataSetType().getMainDataSetPath();
    }

    @Override
    public IScriptImmutable getValidationScript() {
        return ScriptHelper.getScriptImmutable(this.getDataSetType());
    }
}

