/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.plugin.generic.client.web.client.application.dataset;

import ch.systemsx.cisd.openbis.generic.client.web.client.application.IViewContext;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.TabContent;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.framework.DisplayTypeIDGenerator;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.util.lang.StringEscapeUtils;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.LinkDataSet;
import ch.systemsx.cisd.openbis.plugin.generic.client.web.client.application.dataset.LinkDataSetAnchor;
import com.google.gwt.user.client.ui.FlowPanel;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.Widget;

public class LinkDataViewSection
extends TabContent {
    private final LinkDataSet dataset;

    public LinkDataViewSection(IViewContext<?> viewContext, LinkDataSet dataset) {
        super(viewContext.getMessage("data_view", new Object[0]), viewContext, dataset);
        this.dataset = dataset;
        this.setIds(DisplayTypeIDGenerator.DATA_SET_DATA_SECTION);
    }

    @Override
    protected void showContent() {
        FlowPanel content = new FlowPanel();
        content.setStyleName("linkDataViewContent");
        content.add(this.createInfoWidget());
        content.add(this.createLinkWidget());
        this.add((Widget)content);
    }

    private Widget createInfoWidget() {
        Label label = new Label(this.viewContext.getMessage("linked_data_set_info", new Object[0]));
        label.addStyleName("linkDataViewInfo");
        return label;
    }

    private Widget createLinkWidget() {
        LinkDataSetAnchor anchor = LinkDataSetAnchor.tryCreate(this.dataset);
        if (anchor != null) {
            Label label = new Label(this.viewContext.getMessage("linked_data_set_link", new Object[0]));
            label.addStyleName("linkDataViewLabel");
            anchor.setText(StringEscapeUtils.unescapeHtml(String.valueOf(this.dataset.getExternalDataManagementSystem().getLabel()) + ":" + StringEscapeUtils.unescapeHtml(this.dataset.getExternalCode())));
            HorizontalPanel panel = new HorizontalPanel();
            panel.add((Widget)label);
            panel.add((Widget)anchor);
            return panel;
        }
        return new Label(this.viewContext.getMessage("linked_data_set_link_not_available", new Object[0]));
    }
}

