/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.plugin.query.server;

import ch.rinn.restrictions.Private;
import ch.systemsx.cisd.authentication.ISessionManager;
import ch.systemsx.cisd.common.exceptions.UserFailureException;
import ch.systemsx.cisd.openbis.common.spring.IInvocationLoggerContext;
import ch.systemsx.cisd.openbis.generic.server.AbstractServer;
import ch.systemsx.cisd.openbis.generic.server.authorization.annotation.ReturnValueFilter;
import ch.systemsx.cisd.openbis.generic.server.authorization.annotation.RolesAllowed;
import ch.systemsx.cisd.openbis.generic.server.authorization.validator.ExpressionValidator;
import ch.systemsx.cisd.openbis.generic.server.business.IPropertiesBatchManager;
import ch.systemsx.cisd.openbis.generic.server.business.bo.DataAccessExceptionTranslator;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.IDAOFactory;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.IQueryDAO;
import ch.systemsx.cisd.openbis.generic.server.plugin.IDataSetTypeSlaveServerPlugin;
import ch.systemsx.cisd.openbis.generic.server.plugin.ISampleTypeSlaveServerPlugin;
import ch.systemsx.cisd.openbis.generic.shared.basic.TechId;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.BasicEntityType;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.QueryType;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.RoleWithHierarchy;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.TableModel;
import ch.systemsx.cisd.openbis.generic.shared.dto.QueryPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.Session;
import ch.systemsx.cisd.openbis.plugin.query.server.DAO;
import ch.systemsx.cisd.openbis.plugin.query.server.IDAO;
import ch.systemsx.cisd.openbis.plugin.query.server.QueryServerLogger;
import ch.systemsx.cisd.openbis.plugin.query.server.authorization.QueryAccessController;
import ch.systemsx.cisd.openbis.plugin.query.shared.DatabaseDefinition;
import ch.systemsx.cisd.openbis.plugin.query.shared.IQueryDatabaseDefinitionProvider;
import ch.systemsx.cisd.openbis.plugin.query.shared.IQueryServer;
import ch.systemsx.cisd.openbis.plugin.query.shared.basic.dto.IQueryUpdates;
import ch.systemsx.cisd.openbis.plugin.query.shared.basic.dto.NewQuery;
import ch.systemsx.cisd.openbis.plugin.query.shared.basic.dto.QueryDatabase;
import ch.systemsx.cisd.openbis.plugin.query.shared.basic.dto.QueryExpression;
import ch.systemsx.cisd.openbis.plugin.query.shared.basic.dto.QueryParameterBindings;
import ch.systemsx.cisd.openbis.plugin.query.shared.translator.QueryTranslator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.dao.DataAccessException;
import org.springframework.stereotype.Component;

@Component(value="query-plugin-server")
public class QueryServer
extends AbstractServer<IQueryServer>
implements IQueryServer {
    @Resource(name="query-db-definition-provider")
    private IQueryDatabaseDefinitionProvider dbDefinitionProvider;
    @Deprecated
    private final Map<String, IDAO> daos = new HashMap<String, IDAO>();

    public QueryServer() {
    }

    @Private
    QueryServer(ISessionManager<Session> sessionManager, IDAOFactory daoFactory, IPropertiesBatchManager propertiesBatchManager, ISampleTypeSlaveServerPlugin sampleTypeSlaveServerPlugin, IDataSetTypeSlaveServerPlugin dataSetTypeSlaveServerPlugin, IQueryDatabaseDefinitionProvider dbDefinitionProvider) {
        super(sessionManager, daoFactory, propertiesBatchManager, sampleTypeSlaveServerPlugin, dataSetTypeSlaveServerPlugin);
        this.dbDefinitionProvider = dbDefinitionProvider;
    }

    @Override
    public IQueryServer createLogger(IInvocationLoggerContext context) {
        return new QueryServerLogger(this.getSessionManager(), context);
    }

    @Override
    @RolesAllowed(value={RoleWithHierarchy.SPACE_OBSERVER})
    public int initDatabases(String sessionToken) {
        this.checkSession(sessionToken);
        this.dbDefinitionProvider.initDatabaseDefinitions();
        return this.dbDefinitionProvider.getAllDefinitions().size();
    }

    @Override
    @RolesAllowed(value={RoleWithHierarchy.SPACE_OBSERVER})
    public List<QueryDatabase> listQueryDatabases(String sessionToken) {
        this.checkSession(sessionToken);
        ArrayList<QueryDatabase> results = new ArrayList<QueryDatabase>();
        for (DatabaseDefinition definition : this.dbDefinitionProvider.getAllDefinitions()) {
            results.add(new QueryDatabase(definition.getKey(), definition.getLabel()));
        }
        Collections.sort(results);
        return results;
    }

    @Override
    @RolesAllowed(value={RoleWithHierarchy.SPACE_OBSERVER})
    @ReturnValueFilter(validatorClass=ExpressionValidator.class)
    public List<QueryExpression> listQueries(String sessionToken, QueryType queryType, BasicEntityType entityTypeOrNull) {
        this.checkSession(sessionToken);
        try {
            List<QueryPE> queries = this.getDAOFactory().getQueryDAO().listQueries(queryType);
            ArrayList<QueryPE> filtered = new ArrayList<QueryPE>();
            if (entityTypeOrNull != null) {
                String entityTypeCode = entityTypeOrNull.getCode();
                for (QueryPE query : queries) {
                    String queryEntityTypeCodePatternOrNull = query.getEntityTypeCodePattern();
                    if (!StringUtils.isEmpty((String)queryEntityTypeCodePatternOrNull) && !entityTypeCode.matches(queryEntityTypeCodePatternOrNull)) continue;
                    filtered.add(query);
                }
            } else {
                filtered.addAll(queries);
            }
            return QueryTranslator.translate(filtered, this.dbDefinitionProvider);
        }
        catch (DataAccessException ex) {
            throw new UserFailureException(ex.getMostSpecificCause().getMessage(), ex);
        }
    }

    @Override
    @RolesAllowed(value={RoleWithHierarchy.SPACE_OBSERVER})
    public void registerQuery(String sessionToken, NewQuery expression) {
        Session session = this.getSession(sessionToken);
        QueryAccessController.checkWriteAccess(session, expression.getQueryDatabase().getKey(), "create");
        QueryPE query = new QueryPE();
        query.setName(expression.getName());
        query.setDescription(expression.getDescription());
        query.setExpression(expression.getExpression());
        query.setPublic(expression.isPublic());
        query.setRegistrator(session.tryGetPerson());
        query.setQueryType(expression.getQueryType());
        query.setEntityTypeCodePattern(expression.getEntityTypeCode());
        query.setQueryDatabaseKey(expression.getQueryDatabase().getKey());
        try {
            this.getDAOFactory().getQueryDAO().createQuery(query);
        }
        catch (DataAccessException ex) {
            DataAccessExceptionTranslator.throwException(ex, "Query definition '" + expression.getName() + "'", null);
        }
    }

    @Override
    @RolesAllowed(value={RoleWithHierarchy.SPACE_OBSERVER})
    public void deleteQueries(String sessionToken, List<TechId> queryIds) {
        Session session = this.getSession(sessionToken);
        IQueryDAO queryDAO = this.getDAOFactory().getQueryDAO();
        try {
            for (TechId techId : queryIds) {
                QueryPE query = (QueryPE)queryDAO.getByTechId(techId);
                QueryAccessController.checkWriteAccess(session, query.getQueryDatabaseKey(), "delete");
                queryDAO.delete(query);
            }
        }
        catch (DataAccessException ex) {
            DataAccessExceptionTranslator.throwException(ex, "Query definition", null);
        }
    }

    @Override
    @RolesAllowed(value={RoleWithHierarchy.SPACE_OBSERVER})
    public void updateQuery(String sessionToken, IQueryUpdates updates) {
        Session session = this.getSession(sessionToken);
        QueryAccessController.checkWriteAccess(session, updates.getQueryDatabase().getKey(), "update");
        try {
            IQueryDAO queryDAO = this.getDAOFactory().getQueryDAO();
            QueryPE query = (QueryPE)queryDAO.getByTechId(TechId.create(updates));
            query.setName(updates.getName());
            query.setDescription(updates.getDescription());
            query.setExpression(updates.getExpression());
            query.setPublic(updates.isPublic());
            query.setQueryType(updates.getQueryType());
            query.setEntityTypeCodePattern(updates.getEntityTypeCode());
            query.setQueryDatabaseKey(updates.getQueryDatabase().getKey());
            queryDAO.validateAndSaveUpdatedEntity(query);
        }
        catch (DataAccessException ex) {
            DataAccessExceptionTranslator.throwException(ex, "Query definition '" + updates.getName() + "'", null);
        }
    }

    @Override
    @RolesAllowed(value={RoleWithHierarchy.SPACE_OBSERVER})
    public TableModel queryDatabase(String sessionToken, QueryDatabase database, String sqlQuery, QueryParameterBindings bindings, boolean onlyPerform) {
        Session session = this.getSession(sessionToken);
        try {
            String dbKey = database.getKey();
            if (onlyPerform) {
                QueryAccessController.checkReadAccess(session, dbKey);
            } else {
                QueryAccessController.checkWriteAccess(session, dbKey, "create and perform");
            }
            return QueryAccessController.filterResults(session.tryGetPerson(), dbKey, this.getDAOFactory(), this.queryDatabaseWithKey(dbKey, sqlQuery, bindings));
        }
        catch (DataAccessException ex) {
            throw new UserFailureException(ex.getMostSpecificCause().getMessage(), ex);
        }
    }

    @Override
    @RolesAllowed(value={RoleWithHierarchy.SPACE_OBSERVER})
    public TableModel queryDatabase(String sessionToken, TechId queryId, QueryParameterBindings bindings) {
        Session session = this.getSession(sessionToken);
        try {
            IQueryDAO queryDAO = this.getDAOFactory().getQueryDAO();
            QueryPE query = (QueryPE)queryDAO.getByTechId(queryId);
            String dbKey = query.getQueryDatabaseKey();
            String expression = StringEscapeUtils.unescapeHtml((String)query.getExpression());
            QueryAccessController.checkReadAccess(session, dbKey);
            return QueryAccessController.filterResults(session.tryGetPerson(), dbKey, this.getDAOFactory(), this.queryDatabaseWithKey(dbKey, expression, bindings));
        }
        catch (DataAccessException ex) {
            throw new UserFailureException(ex.getMostSpecificCause().getMessage(), ex);
        }
    }

    private TableModel queryDatabaseWithKey(String dbKey, String sqlQuery, QueryParameterBindings bindings) {
        return this.getDAO(dbKey).query(sqlQuery, bindings);
    }

    private IDAO getDAO(String dbKey) {
        IDAO result = this.daos.get(dbKey);
        if (result == null) {
            DatabaseDefinition definition = this.dbDefinitionProvider.getDefinition(dbKey);
            if (definition == null) {
                throw new UnsupportedOperationException("Undefined query database '" + dbKey + "'");
            }
            result = new DAO(definition.getConfigurationContext().getDataSource());
        }
        return result;
    }
}

