/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.installer.izpack;

import ch.systemsx.cisd.openbis.installer.izpack.GlobalInstallationContext;
import ch.systemsx.cisd.openbis.installer.izpack.Utils;
import com.izforge.izpack.api.data.AutomatedInstallData;
import com.izforge.izpack.api.installer.DataValidator;
import java.io.File;
import java.io.FileInputStream;
import java.security.KeyStore;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import org.apache.commons.io.IOUtils;

public class KeyStoreValidator
implements DataValidator {
    private String errorMessage;

    @Override
    public DataValidator.Status validateData(AutomatedInstallData data) {
        ArrayList<File> keyStoreFiles = new ArrayList<File>();
        String keyStoreFilePath = data.getVariable("KEY_STORE_FILE");
        if (keyStoreFilePath != null && keyStoreFilePath.length() > 0) {
            keyStoreFiles.add(new File(keyStoreFilePath));
        } else {
            File installDir = GlobalInstallationContext.installDir;
            this.addKeyStoreFileIfItExists(keyStoreFiles, Utils.getKeystoreFileForAS(installDir));
            this.addKeyStoreFileIfItExists(keyStoreFiles, Utils.getKeystoreFileForDSS(installDir));
        }
        String keyStorePassword = data.getVariable("KEY_STORE_PASSWORD");
        String keyPassword = data.getVariable("KEY_PASSWORD");
        for (File keyStoreFile : keyStoreFiles) {
            FileInputStream input = null;
            try {
                try {
                    KeyStore keyStore = KeyStore.getInstance(KeyStore.getDefaultType());
                    input = new FileInputStream(keyStoreFile);
                    keyStore.load(input, keyStorePassword.toCharArray());
                    Enumeration<String> aliases = keyStore.aliases();
                    while (aliases.hasMoreElements()) {
                        String alias = aliases.nextElement();
                        keyStore.getKey(alias, keyPassword.toCharArray());
                    }
                }
                catch (Exception ex) {
                    this.errorMessage = "Error for key store " + keyStoreFile.getPath() + ":" + ex.getMessage();
                    DataValidator.Status status = DataValidator.Status.ERROR;
                    IOUtils.closeQuietly(input);
                    return status;
                }
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(input);
                throw throwable;
            }
            IOUtils.closeQuietly(input);
        }
        return DataValidator.Status.OK;
    }

    private void addKeyStoreFileIfItExists(List<File> keyStoreFiles, File keyStoreFile) {
        if (keyStoreFile.isFile()) {
            keyStoreFiles.add(keyStoreFile);
        }
    }

    @Override
    public String getErrorMessageId() {
        return this.errorMessage;
    }

    @Override
    public String getWarningMessageId() {
        return this.getErrorMessageId();
    }

    @Override
    public boolean getDefaultAnswer() {
        return true;
    }
}

