/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.api.data;

import com.izforge.izpack.api.adaptator.IXMLElement;
import com.izforge.izpack.api.adaptator.impl.XMLParser;
import com.izforge.izpack.api.exception.IzPackException;
import java.io.InputStream;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;

public class LocaleDatabase
extends TreeMap<String, String> {
    private static Map<String, LocaleDatabase> cachedLocales = new HashMap<String, LocaleDatabase>();
    public static final String LOCALE_DATABASE_DIRECTORY = "/langpacks/";
    public static final String LOCALE_DATABASE_DEF_SUFFIX = ".xml";
    private static final char TEMP_QUOTING_CHARACTER = '\uffff';
    static final long serialVersionUID = 4941525634108401848L;

    public LocaleDatabase(InputStream in) throws Exception {
        this.add(in);
    }

    public void add(InputStream in) {
        XMLParser parser = new XMLParser();
        IXMLElement data = parser.parse(in);
        if (!"langpack".equalsIgnoreCase(data.getName())) {
            throw new IzPackException("this is not an IzPack XML langpack file");
        }
        for (IXMLElement child : data.getChildren()) {
            String text = child.getContent();
            if (text != null && !"".equals(text)) {
                this.put(child.getAttribute("id"), text.trim());
                continue;
            }
            this.put(child.getAttribute("id"), child.getAttribute("txt"));
        }
    }

    public String getString(String key) {
        String val = (String)this.get(key);
        if (val == null) {
            val = key;
        }
        return val;
    }

    public String getString(String key, String[] variables) {
        int i = 0;
        while (i < variables.length) {
            if (variables[i] == null) {
                variables[i] = "N/A";
            } else if (variables[i].startsWith("$")) {
                String curArg = variables[i];
                curArg = curArg.startsWith("${") ? curArg.substring(2, curArg.length() - 1) : curArg.substring(1);
                variables[i] = this.getString(curArg);
            }
            ++i;
        }
        String message = this.getString(key);
        message = message.replace('\'', '\uffff');
        message = MessageFormat.format(message, variables);
        return message.replace('\uffff', '\'');
    }
}

