/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.core.rules;

import com.izforge.izpack.api.adaptator.IXMLElement;
import com.izforge.izpack.api.adaptator.XMLException;
import com.izforge.izpack.api.adaptator.impl.XMLElementImpl;
import com.izforge.izpack.api.adaptator.impl.XMLWriter;
import com.izforge.izpack.api.container.BindeableContainer;
import com.izforge.izpack.api.data.AutomatedInstallData;
import com.izforge.izpack.api.data.Pack;
import com.izforge.izpack.api.exception.IzPackException;
import com.izforge.izpack.api.rules.Condition;
import com.izforge.izpack.api.rules.RulesEngine;
import com.izforge.izpack.core.container.ConditionContainer;
import com.izforge.izpack.core.rules.logic.AndCondition;
import com.izforge.izpack.core.rules.logic.NotCondition;
import com.izforge.izpack.core.rules.logic.OrCondition;
import com.izforge.izpack.core.rules.logic.XorCondition;
import com.izforge.izpack.core.rules.process.JavaCondition;
import com.izforge.izpack.core.rules.process.PackselectionCondition;
import com.izforge.izpack.merge.resolve.ClassPathCrawler;
import com.izforge.izpack.util.Debug;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.picocontainer.Parameter;

public class RulesEngineImpl
implements RulesEngine {
    private static final long serialVersionUID = 3966346766966632860L;
    protected Map<String, String> panelconditions;
    protected Map<String, String> packconditions;
    protected Map<String, String> optionalpackconditions;
    protected Map<String, Condition> conditionsmap = new HashMap<String, Condition>();
    protected AutomatedInstallData installdata;
    private ClassPathCrawler classPathCrawler;
    private BindeableContainer container;

    public RulesEngineImpl(AutomatedInstallData installdata, ClassPathCrawler classPathCrawler, ConditionContainer container) {
        this.installdata = installdata;
        this.classPathCrawler = classPathCrawler;
        this.container = container;
        this.conditionsmap = new HashMap<String, Condition>();
        this.panelconditions = new HashMap<String, String>();
        this.packconditions = new HashMap<String, String>();
        this.optionalpackconditions = new HashMap<String, String>();
        this.initStandardConditions();
    }

    public RulesEngineImpl(ClassPathCrawler classPathCrawler, ConditionContainer container) {
        this(null, classPathCrawler, container);
    }

    private void initStandardConditions() {
        Debug.trace("RulesEngine.initStandardConditions()");
        this.initOsConditions();
        if (this.installdata != null && this.installdata.getAllPacks() != null) {
            Debug.trace("Initializing builtin conditions for packs.");
            for (Pack pack : this.installdata.getAllPacks()) {
                if (pack.id == null) continue;
                PackselectionCondition packselcond = new PackselectionCondition();
                packselcond.setInstalldata(this.installdata);
                packselcond.setId("izpack.selected." + pack.id);
                packselcond.setPackid(pack.id);
                this.conditionsmap.put(packselcond.getId(), packselcond);
                Debug.trace("Pack.getCondition(): " + pack.getCondition() + " for pack " + pack.id);
                if (pack.getCondition() == null || pack.getCondition().length() <= 0) continue;
                Debug.trace("Adding pack condition " + pack.getCondition() + " for pack " + pack.id);
                this.packconditions.put(pack.id, pack.getCondition());
            }
        }
    }

    private void initOsConditions() {
        this.createBuiltinOsCondition("IS_AIX", "izpack.aixinstall");
        this.createBuiltinOsCondition("IS_WINDOWS", "izpack.windowsinstall");
        this.createBuiltinOsCondition("IS_WINDOWS_XP", "izpack.windowsinstall.xp");
        this.createBuiltinOsCondition("IS_WINDOWS_2003", "izpack.windowsinstall.2003");
        this.createBuiltinOsCondition("IS_WINDOWS_VISTA", "izpack.windowsinstall.vista");
        this.createBuiltinOsCondition("IS_WINDOWS_7", "izpack.windowsinstall.7");
        this.createBuiltinOsCondition("IS_LINUX", "izpack.linuxinstall");
        this.createBuiltinOsCondition("IS_SUNOS", "izpack.solarisinstall");
        this.createBuiltinOsCondition("IS_MAC", "izpack.macinstall");
        this.createBuiltinOsCondition("IS_SUNOS", "izpack.solarisinstall");
        this.createBuiltinOsCondition("IS_SUNOS_X86", "izpack.solarisinstall.x86");
        this.createBuiltinOsCondition("IS_SUNOS_SPARC", "izpack.solarisinstall.sparc");
    }

    private void createBuiltinOsCondition(String osVersionField, String conditionId) {
        JavaCondition condition = new JavaCondition("com.izforge.izpack.util.OsVersion", osVersionField, true, "true", "boolean");
        condition.setInstalldata(this.installdata);
        condition.setId(conditionId);
        this.conditionsmap.put(condition.getId(), condition);
    }

    @Override
    public void readConditionMap(Map<String, Condition> rules) {
        this.conditionsmap = rules;
        for (String key : this.conditionsmap.keySet()) {
            Condition condition = this.conditionsmap.get(key);
            condition.setInstalldata(this.installdata);
        }
    }

    @Override
    public String[] getKnownConditionIds() {
        Object[] conditionids = this.conditionsmap.keySet().toArray(new String[this.conditionsmap.size()]);
        Arrays.sort(conditionids);
        return conditionids;
    }

    @Override
    public Condition instanciateCondition(IXMLElement condition) {
        String condid = condition.getAttribute("id");
        String condtype = condition.getAttribute("type");
        Condition result = null;
        if (condtype != null) {
            String conditionclassname = "";
            if (condtype.indexOf(46) > -1) {
                conditionclassname = condtype;
            } else {
                String conditiontype = condtype.toLowerCase();
                conditionclassname = String.valueOf(conditiontype.substring(0, 1).toUpperCase()) + conditiontype.substring(1, conditiontype.length());
                conditionclassname = String.valueOf(conditionclassname) + "Condition";
            }
            try {
                Class conditionclass = this.classPathCrawler.searchClassInClassPath(conditionclassname);
                this.container.addComponent(condid, conditionclass, new Parameter[0]);
                result = (Condition)this.container.getComponent(condid);
                result.readFromXML(condition);
                if (condid != null) {
                    result.setId(condid);
                }
                result.setInstalldata(this.installdata);
            }
            catch (Exception e) {
                throw new IzPackException(e);
            }
        }
        return result;
    }

    @Override
    public void analyzeXml(IXMLElement conditionsspec) {
        if (conditionsspec == null) {
            Debug.trace("No specification for conditions found.");
            return;
        }
        if (conditionsspec.hasChildren()) {
            List<IXMLElement> childs = conditionsspec.getChildrenNamed("condition");
            for (IXMLElement condition : childs) {
                Condition cond = this.instanciateCondition(condition);
                if (cond == null) continue;
                String condid = cond.getId();
                cond.setInstalldata(this.installdata);
                if (condid == null || "UNKNOWN".equals(condid)) continue;
                this.conditionsmap.put(condid, cond);
            }
            List<IXMLElement> panelconditionels = conditionsspec.getChildrenNamed("panelcondition");
            for (IXMLElement panelel : panelconditionels) {
                String panelid = panelel.getAttribute("panelid");
                String conditionid = panelel.getAttribute("conditionid");
                this.panelconditions.put(panelid, conditionid);
            }
            List<IXMLElement> packconditionels = conditionsspec.getChildrenNamed("packcondition");
            for (IXMLElement panelel : packconditionels) {
                boolean optionalinstall;
                String panelid = panelel.getAttribute("packid");
                String conditionid = panelel.getAttribute("conditionid");
                this.packconditions.put(panelid, conditionid);
                String optional = panelel.getAttribute("optional");
                if (optional == null || !(optionalinstall = Boolean.valueOf(optional).booleanValue())) continue;
                this.optionalpackconditions.put(panelid, conditionid);
            }
        }
    }

    @Override
    public Condition getCondition(String id) {
        Condition result = this.conditionsmap.get(id);
        if (result == null) {
            result = id.startsWith("@") ? this.parseComplexCondition(id.substring(1)) : this.getConditionByExpr(new StringBuffer(id));
        }
        return result;
    }

    protected Condition parseComplexCondition(String expression) {
        Condition result = null;
        result = expression.contains("||") ? this.parseComplexOrCondition(expression) : (expression.contains("&&") ? this.parseComplexAndCondition(expression) : (expression.contains("^") ? this.parseComplexXorCondition(expression) : (expression.contains("!") ? this.parseComplexNotCondition(expression) : this.conditionsmap.get(expression))));
        result.setInstalldata(this.installdata);
        return result;
    }

    private Condition parseComplexOrCondition(String expression) {
        OrCondition result = null;
        String[] parts = expression.split("\\|\\|", 2);
        result = new OrCondition(this, this.parseComplexCondition(parts[0].trim()), this.parseComplexCondition(parts[1].trim()));
        return result;
    }

    private Condition parseComplexXorCondition(String expression) {
        XorCondition result = null;
        String[] parts = expression.split("\\^", 2);
        result = new XorCondition(this, this.parseComplexCondition(parts[0].trim()), this.parseComplexCondition(parts[1].trim()));
        return result;
    }

    private Condition parseComplexAndCondition(String expression) {
        AndCondition result = null;
        String[] parts = expression.split("\\&\\&", 2);
        result = new AndCondition(this, this.parseComplexCondition(parts[0].trim()), this.parseComplexCondition(parts[1].trim()));
        return result;
    }

    private Condition parseComplexNotCondition(String expression) {
        Condition result = null;
        result = NotCondition.createFromCondition(this.parseComplexCondition(expression.substring(1).trim()), this, this.installdata);
        return result;
    }

    protected Condition getConditionByExpr(StringBuffer conditionexpr) {
        Condition result = null;
        int index = 0;
        while (index < conditionexpr.length()) {
            char currentchar = conditionexpr.charAt(index);
            switch (currentchar) {
                case '+': {
                    Condition op1 = this.conditionsmap.get(conditionexpr.substring(0, index));
                    conditionexpr.delete(0, index + 1);
                    result = new AndCondition(this, op1, this.getConditionByExpr(conditionexpr));
                    break;
                }
                case '|': {
                    Condition op1 = this.conditionsmap.get(conditionexpr.substring(0, index));
                    conditionexpr.delete(0, index + 1);
                    result = new OrCondition(this, op1, this.getConditionByExpr(conditionexpr));
                    break;
                }
                case '\\': {
                    Condition op1 = this.conditionsmap.get(conditionexpr.substring(0, index));
                    conditionexpr.delete(0, index + 1);
                    result = new XorCondition(this, op1, this.getConditionByExpr(conditionexpr));
                    break;
                }
                case '!': {
                    if (index > 0) {
                        Debug.trace("error: ! operator only allowed at position 0");
                        break;
                    }
                    conditionexpr.deleteCharAt(index);
                    result = NotCondition.createFromCondition(this.getConditionByExpr(conditionexpr), this, this.installdata);
                }
            }
            ++index;
        }
        if (conditionexpr.length() > 0 && (result = this.conditionsmap.get(conditionexpr.toString())) != null) {
            result.setInstalldata(this.installdata);
            conditionexpr.delete(0, conditionexpr.length());
        }
        return result;
    }

    @Override
    public boolean isConditionTrue(String id, Properties variables) {
        Condition cond = this.getCondition(id);
        cond.setInstalldata(this.installdata);
        if (cond == null) {
            // empty if block
        }
        Debug.trace("Checking condition");
        try {
            return cond.isTrue();
        }
        catch (NullPointerException npe) {
            Debug.error("Nullpointerexception checking condition: " + id);
            return false;
        }
    }

    @Override
    public boolean isConditionTrue(Condition cond, Properties variables) {
        if (cond == null) {
            Debug.trace("Condition not found.");
            return true;
        }
        Debug.trace("Checking condition");
        return cond.isTrue();
    }

    @Override
    public boolean isConditionTrue(String id) {
        Condition cond = this.getCondition(id);
        if (cond != null) {
            cond.setInstalldata(this.installdata);
            return this.isConditionTrue(cond);
        }
        return false;
    }

    @Override
    public boolean isConditionTrue(Condition cond) {
        if (cond.getInstallData() == null) {
            cond.setInstalldata(this.installdata);
        }
        return cond.isTrue();
    }

    @Override
    public boolean canShowPanel(String panelid, Properties variables) {
        Debug.trace("can show panel with id " + panelid + " ?");
        if (!this.panelconditions.containsKey(panelid)) {
            Debug.trace("no condition, show panel");
            return true;
        }
        Debug.trace("there is a condition");
        Condition condition = this.getCondition(this.panelconditions.get(panelid));
        if (condition != null) {
            return condition.isTrue();
        }
        return false;
    }

    @Override
    public boolean canInstallPack(String packid, Properties variables) {
        if (packid == null) {
            return true;
        }
        Debug.trace("can install pack with id " + packid + "?");
        if (!this.packconditions.containsKey(packid)) {
            Debug.trace("no condition, can install pack");
            return true;
        }
        Debug.trace("there is a condition");
        Condition condition = this.getCondition(this.packconditions.get(packid));
        if (condition != null) {
            return condition.isTrue();
        }
        return false;
    }

    @Override
    public boolean canInstallPackOptional(String packid, Properties variables) {
        Debug.trace("can install pack optional with id " + packid + "?");
        if (!this.optionalpackconditions.containsKey(packid)) {
            Debug.trace("not in optionalpackconditions.");
            return false;
        }
        Debug.trace("optional install possible");
        return true;
    }

    @Override
    public void addCondition(Condition condition) {
        if (condition != null) {
            if (this.conditionsmap.containsKey(condition.getId())) {
                Debug.error("Condition already registered.");
            } else {
                this.conditionsmap.put(condition.getId(), condition);
            }
        } else {
            Debug.error("Cannot add condition. Condition was null.");
        }
    }

    @Override
    public void writeRulesXML(OutputStream out) {
        XMLWriter xmlOut = new XMLWriter();
        xmlOut.setOutput(out);
        XMLElementImpl conditionsel = new XMLElementImpl("conditions");
        for (Condition condition : this.conditionsmap.values()) {
            IXMLElement conditionEl = this.createConditionElement(condition, conditionsel);
            condition.makeXMLData(conditionEl);
            conditionsel.addChild(conditionEl);
        }
        Debug.trace("Writing generated conditions specification.");
        try {
            xmlOut.write(conditionsel);
        }
        catch (XMLException e) {
            throw new IzPackException(e);
        }
    }

    @Override
    public IXMLElement createConditionElement(Condition condition, IXMLElement root) {
        XMLElementImpl xml = new XMLElementImpl("condition", root);
        xml.setAttribute("id", condition.getId());
        xml.setAttribute("type", condition.getClass().getCanonicalName());
        return xml;
    }
}

