/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.event;

import com.izforge.izpack.api.data.LocaleDatabase;
import com.izforge.izpack.api.exception.NativeLibException;
import com.izforge.izpack.api.exception.WrappedNativeLibException;
import com.izforge.izpack.api.handler.AbstractUIProgressHandler;
import com.izforge.izpack.core.os.RegistryHandler;
import com.izforge.izpack.event.NativeUninstallerListener;
import com.izforge.izpack.util.TargetFactory;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.util.List;

public class RegistryUninstallerListener
extends NativeUninstallerListener {
    public RegistryUninstallerListener(LocaleDatabase langPack) {
        super(langPack);
    }

    @Override
    public void beforeDeletion(List files, AbstractUIProgressHandler handler) throws Exception {
        InputStream in = this.getClass().getResourceAsStream("/registryEntries");
        if (in == null) {
            return;
        }
        ObjectInputStream objIn = new ObjectInputStream(in);
        List allActions = (List)objIn.readObject();
        objIn.close();
        in.close();
        if (allActions == null || allActions.size() < 1) {
            return;
        }
        try {
            RegistryHandler registryHandler = this.initializeRegistryHandler();
            if (registryHandler == null) {
                return;
            }
            registryHandler.activateLogging();
            registryHandler.setLoggingInfo(allActions);
            registryHandler.rewind();
        }
        catch (Exception e) {
            if (e instanceof NativeLibException) {
                throw new WrappedNativeLibException(e);
            }
            throw e;
        }
    }

    private RegistryHandler initializeRegistryHandler() throws Exception {
        RegistryHandler registryHandler = null;
        try {
            registryHandler = (RegistryHandler)TargetFactory.getInstance().makeObject("com.izforge.izpack.core.os.RegistryHandler");
        }
        catch (Throwable exception) {
            exception.printStackTrace();
            registryHandler = null;
        }
        if (!(registryHandler == null || registryHandler.good() && registryHandler.doPerform())) {
            System.out.println("initializeRegistryHandler is Bad " + registryHandler.good() + registryHandler.doPerform());
            registryHandler = null;
        }
        return registryHandler;
    }
}

