/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.util.config;

import com.izforge.izpack.api.adaptator.IXMLElement;
import com.izforge.izpack.util.Debug;
import com.izforge.izpack.util.config.SingleConfigurableTask;
import java.io.IOException;
import org.ini4j.Reg;

public class RegistryTask
extends SingleConfigurableTask {
    protected String key;
    protected String fromKey;

    public void setKey(String key) {
        this.key = key;
    }

    public void setFromKey(String key) {
        this.fromKey = key;
    }

    @Override
    protected void readSourceConfigurable() throws Exception {
        if (this.fromKey != null) {
            try {
                Debug.log("Loading from registry: " + this.fromKey);
                this.fromConfigurable = new Reg(this.fromKey);
            }
            catch (IOException ioe) {
                throw new Exception(ioe.toString());
            }
        }
    }

    @Override
    protected void readConfigurable() throws Exception {
        if (this.key != null) {
            try {
                Debug.log("Loading from registry: " + this.key);
                this.configurable = new Reg(this.key);
            }
            catch (IOException ioe) {
                throw new Exception(ioe.toString());
            }
        }
    }

    @Override
    protected void writeConfigurable() throws Exception {
        if (this.configurable == null) {
            Debug.log("Registry key " + this.key + " did not exist and is not allowed to be created");
            return;
        }
        try {
            Reg r = (Reg)this.configurable;
            r.store();
        }
        catch (IOException ioe) {
            throw new Exception(ioe);
        }
    }

    @Override
    protected void checkAttributes() throws Exception {
        if (this.key == null) {
            throw new Exception("Key attribute must be set");
        }
    }

    @Override
    protected SingleConfigurableTask.Entry filterEntryFromXML(IXMLElement parent, SingleConfigurableTask.Entry entry) {
        entry.setSection(parent.getAttribute("key"));
        entry.setKey(parent.getAttribute("value"));
        entry.setValue(parent.getAttribute("data"));
        return entry;
    }
}

