/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.util.config;

import com.izforge.izpack.api.adaptator.IXMLElement;
import com.izforge.izpack.util.Debug;
import com.izforge.izpack.util.config.ConfigFileTask;
import com.izforge.izpack.util.config.SingleConfigurableTask;
import java.io.File;
import java.io.IOException;
import org.ini4j.Options;

public class SingleOptionFileTask
extends ConfigFileTask {
    @Override
    protected void readSourceConfigurable() throws Exception {
        if (this.oldFile != null) {
            try {
                if (!this.oldFile.exists()) {
                    Debug.log("Options file " + this.oldFile.getAbsolutePath() + " to patch from could not be found, no patches will be applied");
                    return;
                }
                Debug.log("Loading options file: " + this.oldFile.getAbsolutePath());
                this.fromConfigurable = new Options(this.oldFile);
            }
            catch (IOException ioe) {
                throw new Exception(ioe.toString());
            }
        }
    }

    @Override
    protected void readConfigurable() throws Exception {
        if (this.newFile != null) {
            try {
                if (!this.newFile.exists()) {
                    throw new Exception("Reference file " + this.newFile.getAbsolutePath() + " for patch cannot be found");
                }
                Debug.log("Loading options file: " + this.newFile.getAbsolutePath());
                this.configurable = new Options(this.newFile);
            }
            catch (IOException ioe) {
                throw new Exception(ioe.toString());
            }
        } else {
            this.configurable = new Options();
        }
    }

    @Override
    protected void writeConfigurable() throws Exception {
        try {
            if (!this.toFile.exists()) {
                if (this.createConfigurable) {
                    File parent = this.toFile.getParentFile();
                    if (parent != null && !parent.exists()) {
                        parent.mkdirs();
                    }
                    Debug.log("Creating empty properties file: " + this.toFile.getAbsolutePath());
                    this.toFile.createNewFile();
                } else {
                    Debug.log("Options file " + this.toFile.getAbsolutePath() + " did not exist and is not allowed to be created");
                    return;
                }
            }
            Options opts = (Options)this.configurable;
            opts.setFile(this.toFile);
            opts.setComment(this.getComment());
            opts.store();
        }
        catch (IOException ioe) {
            throw new Exception(ioe);
        }
        if (this.cleanup && this.oldFile.exists() && !this.oldFile.delete()) {
            Debug.log("File " + this.oldFile + " could not be cleant up");
        }
    }

    @Override
    protected SingleConfigurableTask.Entry filterEntryFromXML(IXMLElement parent, SingleConfigurableTask.Entry entry) {
        entry.setKey(parent.getAttribute("key"));
        entry.setValue(parent.getAttribute("value"));
        return entry;
    }
}

