/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.util.file;

import com.izforge.izpack.util.file.FileNameMapper;
import com.izforge.izpack.util.file.types.Mapper;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

public abstract class ContainerMapper
implements FileNameMapper {
    private List<FileNameMapper> mappers = new ArrayList<FileNameMapper>();

    public void addConfiguredMapper(Mapper mapper) throws Exception {
        this.add(mapper.getImplementation());
    }

    public synchronized void add(FileNameMapper fileNameMapper) {
        if (this == fileNameMapper || fileNameMapper instanceof ContainerMapper && ((ContainerMapper)fileNameMapper).contains(this)) {
            throw new IllegalArgumentException("Circular mapper containment condition detected");
        }
        this.mappers.add(fileNameMapper);
    }

    protected synchronized boolean contains(FileNameMapper fileNameMapper) {
        boolean foundit = false;
        Iterator<FileNameMapper> iter = this.mappers.iterator();
        while (iter.hasNext() && !foundit) {
            FileNameMapper next = iter.next();
            foundit |= next == fileNameMapper || next instanceof ContainerMapper && ((ContainerMapper)next).contains(fileNameMapper);
        }
        return foundit;
    }

    public synchronized List<FileNameMapper> getMappers() {
        return Collections.unmodifiableList(this.mappers);
    }

    @Override
    public void setFrom(String ignore) {
    }

    @Override
    public void setTo(String ignore) {
    }
}

