/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.util.file;

import com.izforge.izpack.util.OsVersion;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.DecimalFormat;
import java.text.StringCharacterIterator;
import java.util.Random;
import java.util.Stack;
import java.util.StringTokenizer;

public class FileUtils {
    private static final FileUtils PRIMARY_INSTANCE = new FileUtils();
    private static Random rand = new Random(System.currentTimeMillis() + Runtime.getRuntime().freeMemory());
    private static final int BUF_SIZE = 8192;
    private static boolean[] isSpecial = new boolean[256];
    private static char[] escapedChar1 = new char[256];
    private static char[] escapedChar2 = new char[256];
    public static final long FAT_FILE_TIMESTAMP_GRANULARITY = 2000L;
    public static final long UNIX_FILE_TIMESTAMP_GRANULARITY = 1000L;

    static {
        int i = 0;
        while (i <= 32) {
            FileUtils.isSpecial[i] = true;
            FileUtils.escapedChar1[i] = Character.forDigit(i >> 4, 16);
            FileUtils.escapedChar2[i] = Character.forDigit(i & 0xF, 16);
            ++i;
        }
        FileUtils.isSpecial[127] = true;
        FileUtils.escapedChar1[127] = 55;
        FileUtils.escapedChar2[127] = 70;
        char[] escChs = new char[]{'<', '>', '#', '%', '\"', '{', '}', '|', '\\', '^', '~', '[', ']', '`'};
        int len = escChs.length;
        int i2 = 0;
        while (i2 < len) {
            char ch = escChs[i2];
            FileUtils.isSpecial[ch] = true;
            FileUtils.escapedChar1[ch] = Character.forDigit(ch >> 4, 16);
            FileUtils.escapedChar2[ch] = Character.forDigit(ch & 0xF, 16);
            ++i2;
        }
    }

    public static File createTempFile(String prefix, String suffix) throws IOException {
        if (OsVersion.IS_OSX) {
            return File.createTempFile(prefix, suffix, new File("/tmp"));
        }
        return File.createTempFile(prefix, suffix);
    }

    public static FileUtils getFileUtils() {
        return PRIMARY_INSTANCE;
    }

    protected FileUtils() {
    }

    public URL getFileURL(File file) throws MalformedURLException {
        return new URL(this.toURI(file.getAbsolutePath()));
    }

    public void copyFile(String sourceFile, String destFile, boolean overwrite, boolean preserveLastModified) throws IOException {
        this.copyFile(new File(sourceFile), new File(destFile), overwrite, preserveLastModified);
    }

    public void copyFile(File sourceFile, File destFile) throws IOException {
        this.copyFile(sourceFile, destFile, false, false);
    }

    public void copyFile(File sourceFile, File destFile, boolean overwrite, boolean preserveLastModified) throws IOException {
        if (overwrite || !destFile.exists() || destFile.lastModified() < sourceFile.lastModified()) {
            File parent;
            if (destFile.exists() && destFile.isFile()) {
                destFile.delete();
            }
            if ((parent = destFile.getParentFile()) != null && !parent.exists()) {
                parent.mkdirs();
            }
            FileInputStream in = null;
            FileOutputStream out = null;
            try {
                in = new FileInputStream(sourceFile);
                out = new FileOutputStream(destFile);
                byte[] buffer = new byte[8192];
                int count = 0;
                do {
                    out.write(buffer, 0, count);
                } while ((count = in.read(buffer, 0, buffer.length)) != -1);
            }
            catch (Throwable throwable) {
                FileUtils.close(out);
                FileUtils.close(in);
                throw throwable;
            }
            FileUtils.close(out);
            FileUtils.close(in);
            if (preserveLastModified) {
                this.setFileLastModified(destFile, sourceFile.lastModified());
            }
        }
    }

    public void setFileLastModified(File file, long time) {
        file.setLastModified(time < 0L ? System.currentTimeMillis() : time);
    }

    public File resolveFile(File file, String filename) throws Exception {
        if (FileUtils.isAbsolutePath(filename = filename.replace('/', File.separatorChar).replace('\\', File.separatorChar))) {
            return this.normalize(filename);
        }
        if (file == null) {
            return new File(filename);
        }
        File helpFile = new File(file.getAbsolutePath());
        StringTokenizer tok = new StringTokenizer(filename, File.separator);
        while (tok.hasMoreTokens()) {
            String part = tok.nextToken();
            if (part.equals("..")) {
                if ((helpFile = helpFile.getParentFile()) != null) continue;
                String msg = "The file or path you specified (" + filename + ") is invalid relative to " + file.getPath();
                throw new Exception(msg);
            }
            if (part.equals(".")) continue;
            helpFile = new File(helpFile, part);
        }
        return new File(helpFile.getAbsolutePath());
    }

    public static boolean isAbsolutePath(String filename) {
        if (filename.startsWith(File.separator)) {
            return true;
        }
        return OsVersion.IS_WINDOWS && filename.length() >= 2 && Character.isLetter(filename.charAt(0)) && filename.charAt(1) == ':';
    }

    public File normalize(String path) throws Exception {
        int i;
        String orig = path;
        path = path.replace('/', File.separatorChar).replace('\\', File.separatorChar);
        int colon = path.indexOf(":");
        if (!FileUtils.isAbsolutePath(path)) {
            String msg = String.valueOf(path) + " is not an absolute path";
            throw new Exception(msg);
        }
        boolean dosWithDrive = false;
        String root = null;
        if (OsVersion.IS_WINDOWS && path.length() >= 2 && Character.isLetter(path.charAt(0)) && path.charAt(1) == ':') {
            dosWithDrive = true;
            char[] ca = path.replace('/', '\\').toCharArray();
            StringBuffer sbRoot = new StringBuffer();
            int i2 = 0;
            while (i2 < colon) {
                sbRoot.append(Character.toUpperCase(ca[i2]));
                ++i2;
            }
            sbRoot.append(':');
            if (colon + 1 < path.length()) {
                sbRoot.append(File.separatorChar);
            }
            root = sbRoot.toString();
            StringBuffer sbPath = new StringBuffer();
            i = colon + 1;
            while (i < ca.length) {
                if (ca[i] != '\\' || ca[i] == '\\' && ca[i - 1] != '\\') {
                    sbPath.append(ca[i]);
                }
                ++i;
            }
            path = sbPath.toString().replace('\\', File.separatorChar);
        } else if (path.length() == 1) {
            root = File.separator;
            path = "";
        } else if (path.charAt(1) == File.separatorChar) {
            root = String.valueOf(File.separator) + File.separator;
            path = path.substring(2);
        } else {
            root = File.separator;
            path = path.substring(1);
        }
        Stack<String> s = new Stack<String>();
        s.push(root);
        StringTokenizer tok = new StringTokenizer(path, File.separator);
        while (tok.hasMoreTokens()) {
            String thisToken = tok.nextToken();
            if (".".equals(thisToken)) continue;
            if ("..".equals(thisToken)) {
                if (s.size() < 2) {
                    throw new Exception("Cannot resolve path " + orig);
                }
                s.pop();
                continue;
            }
            s.push(thisToken);
        }
        StringBuffer sb = new StringBuffer();
        i = 0;
        while (i < s.size()) {
            if (i > 1) {
                sb.append(File.separatorChar);
            }
            sb.append((String)s.elementAt(i));
            ++i;
        }
        path = sb.toString();
        if (dosWithDrive) {
            path = path.replace('/', '\\');
        }
        return new File(path);
    }

    public String toVMSPath(File f) throws Exception {
        String path = this.normalize(f.getAbsolutePath()).getPath();
        String name = f.getName();
        boolean isAbsolute = path.charAt(0) == File.separatorChar;
        boolean isDirectory = f.isDirectory() && !name.regionMatches(true, name.length() - 4, ".DIR", 0, 4);
        String device = null;
        StringBuffer directory = null;
        String file = null;
        int index = 0;
        if (isAbsolute) {
            index = path.indexOf(File.separatorChar, 1);
            if (index == -1) {
                return String.valueOf(path.substring(1)) + ":[000000]";
            }
            device = path.substring(1, index++);
        }
        if (isDirectory) {
            directory = new StringBuffer(path.substring(index).replace(File.separatorChar, '.'));
        } else {
            int dirEnd = path.lastIndexOf(File.separatorChar, path.length());
            if (dirEnd == -1 || dirEnd < index) {
                file = path.substring(index);
            } else {
                directory = new StringBuffer(path.substring(index, dirEnd).replace(File.separatorChar, '.'));
                index = dirEnd + 1;
                if (path.length() > index) {
                    file = path.substring(index);
                }
            }
        }
        if (!isAbsolute && directory != null) {
            directory.insert(0, '.');
        }
        String osPath = String.valueOf(device != null ? String.valueOf(device) + ":" : "") + (directory != null ? "[" + directory + "]" : "") + (file != null ? file : "");
        return osPath;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public File createTempFile(String prefix, String suffix, File parentDir) {
        File result = null;
        String parent = parentDir == null ? System.getProperty("java.io.tmpdir") : parentDir.getPath();
        DecimalFormat fmt = new DecimalFormat("#####");
        Random random = rand;
        synchronized (random) {
            while ((result = new File(parent, String.valueOf(prefix) + fmt.format(Math.abs(rand.nextInt())) + suffix)).exists()) {
            }
        }
        return result;
    }

    public boolean contentEquals(File f1, File f2) throws Exception {
        return this.contentEquals(f1, f2, false);
    }

    public boolean contentEquals(File f1, File f2, boolean textfile) throws Exception {
        if (f1.exists() != f2.exists()) {
            return false;
        }
        if (!f1.exists()) {
            return true;
        }
        if (f1.isDirectory() || f2.isDirectory()) {
            return false;
        }
        if (this.fileNameEquals(f1, f2)) {
            return true;
        }
        return textfile ? this.textEquals(f1, f2) : this.binaryEquals(f1, f2);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean binaryEquals(File f1, File f2) throws IOException {
        BufferedInputStream in2;
        BufferedInputStream in1;
        block7: {
            block6: {
                if (f1.length() != f2.length()) {
                    return false;
                }
                in1 = null;
                in2 = null;
                try {
                    in1 = new BufferedInputStream(new FileInputStream(f1));
                    in2 = new BufferedInputStream(new FileInputStream(f2));
                    int expectedByte = ((InputStream)in1).read();
                    while (expectedByte != -1) {
                        if (expectedByte == ((InputStream)in2).read()) {
                            expectedByte = ((InputStream)in1).read();
                            continue;
                        }
                        break block6;
                    }
                    if (((InputStream)in2).read() == -1) break block7;
                }
                catch (Throwable throwable) {
                    FileUtils.close(in1);
                    FileUtils.close(in2);
                    throw throwable;
                }
            }
            FileUtils.close(in1);
            FileUtils.close(in2);
            return false;
        }
        FileUtils.close(in1);
        FileUtils.close(in2);
        return true;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean textEquals(File f1, File f2) throws IOException {
        BufferedReader in2;
        BufferedReader in1;
        block6: {
            block5: {
                in1 = null;
                in2 = null;
                try {
                    in1 = new BufferedReader(new FileReader(f1));
                    in2 = new BufferedReader(new FileReader(f2));
                    String expected = in1.readLine();
                    while (expected != null) {
                        if (expected.equals(in2.readLine())) {
                            expected = in1.readLine();
                            continue;
                        }
                        break block5;
                    }
                    if (in2.readLine() == null) break block6;
                }
                catch (Throwable throwable) {
                    FileUtils.close(in1);
                    FileUtils.close(in2);
                    throw throwable;
                }
            }
            FileUtils.close(in1);
            FileUtils.close(in2);
            return false;
        }
        FileUtils.close(in1);
        FileUtils.close(in2);
        return true;
    }

    public File getParentFile(File f) {
        return f == null ? null : f.getParentFile();
    }

    public static final String readFully(Reader rdr) throws IOException {
        return FileUtils.readFully(rdr, 8192);
    }

    public static final String readFully(Reader rdr, int bufferSize) throws IOException {
        if (bufferSize <= 0) {
            throw new IllegalArgumentException("Buffer size must be greater than 0");
        }
        char[] buffer = new char[bufferSize];
        int bufferLength = 0;
        StringBuffer textBuffer = null;
        while (bufferLength != -1) {
            bufferLength = rdr.read(buffer);
            if (bufferLength <= 0) continue;
            textBuffer = textBuffer == null ? new StringBuffer() : textBuffer;
            textBuffer.append(new String(buffer, 0, bufferLength));
        }
        return textBuffer == null ? null : textBuffer.toString();
    }

    public boolean createNewFile(File f) throws IOException {
        return f.createNewFile();
    }

    public boolean createNewFile(File f, boolean mkdirs) throws IOException {
        File parent = f.getParentFile();
        if (mkdirs && !parent.exists()) {
            parent.mkdirs();
        }
        return f.createNewFile();
    }

    public boolean isSymbolicLink(File parent, String name) throws IOException {
        File toTest;
        if (parent == null) {
            File f = new File(name);
            parent = f.getParentFile();
            name = f.getName();
        }
        return !(toTest = new File(parent.getCanonicalPath(), name)).getAbsolutePath().equals(toTest.getCanonicalPath());
    }

    public String removeLeadingPath(File leading, File path) throws Exception {
        String p;
        String l = this.normalize(leading.getAbsolutePath()).getAbsolutePath();
        if (l.equals(p = this.normalize(path.getAbsolutePath()).getAbsolutePath())) {
            return "";
        }
        if (!l.endsWith(File.separator)) {
            l = String.valueOf(l) + File.separator;
        }
        return p.startsWith(l) ? p.substring(l.length()) : p;
    }

    public String toURI(String path) {
        boolean isDir = new File(path).isDirectory();
        StringBuffer sb = new StringBuffer("file:");
        try {
            path = this.normalize(path).getAbsolutePath();
            sb.append("//");
            if (!path.startsWith(File.separator)) {
                sb.append("/");
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        path = path.replace('\\', '/');
        StringCharacterIterator iter = new StringCharacterIterator(path);
        char c = iter.first();
        while (c != '\uffff') {
            if (c < '\u0100' && isSpecial[c]) {
                sb.append('%');
                sb.append(escapedChar1[c]);
                sb.append(escapedChar2[c]);
            } else {
                sb.append(c);
            }
            c = iter.next();
        }
        if (isDir && !path.endsWith("/")) {
            sb.append('/');
        }
        return sb.toString();
    }

    public boolean fileNameEquals(File f1, File f2) throws Exception {
        return this.normalize(f1.getAbsolutePath()).equals(this.normalize(f2.getAbsolutePath()));
    }

    public void rename(File from, File to) throws IOException {
        if (to.exists() && !to.delete()) {
            throw new IOException("Failed to delete " + to + " while trying to rename " + from);
        }
        File parent = to.getParentFile();
        if (parent != null && !parent.exists() && !parent.mkdirs()) {
            throw new IOException("Failed to create directory " + parent + " while trying to rename " + from);
        }
        if (!from.renameTo(to)) {
            this.copyFile(from, to);
            if (!from.delete()) {
                throw new IOException("Failed to delete " + from + " while trying to rename it.");
            }
        }
    }

    public long getFileTimestampGranularity() {
        return OsVersion.IS_WINDOWS ? 2000L : 1000L;
    }

    public boolean isUpToDate(File source, File dest, long granularity) {
        if (!dest.exists()) {
            return false;
        }
        long sourceTime = source.lastModified();
        long destTime = dest.lastModified();
        return this.isUpToDate(sourceTime, destTime, granularity);
    }

    public boolean isUpToDate(File source, File dest) {
        return this.isUpToDate(source, dest, this.getFileTimestampGranularity());
    }

    public boolean isUpToDate(long sourceTime, long destTime, long granularity) {
        if (destTime == -1L) {
            return false;
        }
        return destTime >= sourceTime + granularity;
    }

    public boolean isUpToDate(long sourceTime, long destTime) {
        return this.isUpToDate(sourceTime, destTime, this.getFileTimestampGranularity());
    }

    public static void close(Writer device) {
        if (device != null) {
            try {
                device.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public static void close(Reader device) {
        if (device != null) {
            try {
                device.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public static void close(OutputStream device) {
        if (device != null) {
            try {
                device.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public static void close(InputStream device) {
        if (device != null) {
            try {
                device.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public static void delete(File file) {
        if (file != null) {
            file.delete();
        }
    }

    public static boolean deleteRecursively(File fileToDelete) {
        boolean retval = true;
        if (fileToDelete.isDirectory()) {
            File[] fileArray = fileToDelete.listFiles();
            int n = fileArray.length;
            int n2 = 0;
            while (n2 < n) {
                File fileInDir = fileArray[n2];
                retval &= FileUtils.deleteRecursively(fileInDir);
                ++n2;
            }
        }
        return retval &= fileToDelete.delete();
    }
}

