/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.common.fileconverter;

import ch.systemsx.cisd.common.exceptions.EnvironmentFailureException;
import ch.systemsx.cisd.common.fileconverter.IFileConversionMethod;
import ch.systemsx.cisd.common.fileconverter.IFileConversionStrategy;
import ch.systemsx.cisd.common.fileconverter.ImageMagickTiffCompressionConverter;
import ch.systemsx.cisd.common.fileconverter.TiffCpTiffCompressionConverter;
import java.io.File;
import org.apache.commons.io.FilenameUtils;

public class TiffCompressionStrategy
implements IFileConversionStrategy {
    private final IFileConversionMethod method;

    public TiffCompressionStrategy(TiffCompressionMethod methodId, String compressionType) {
        switch (methodId) {
            case IMAGEMAGICK_CONVERT: {
                this.method = new ImageMagickTiffCompressionConverter(compressionType);
                break;
            }
            case LIBTIFF_TIFFCP: {
                this.method = new TiffCpTiffCompressionConverter(compressionType);
                break;
            }
            default: {
                throw new IllegalArgumentException("methodId: " + methodId.name());
            }
        }
    }

    public TiffCompressionStrategy(TiffCompressionMethod methodId) {
        this(methodId, null);
    }

    public TiffCompressionStrategy() throws EnvironmentFailureException {
        TiffCpTiffCompressionConverter tiffCpConverter = new TiffCpTiffCompressionConverter();
        if (tiffCpConverter.isAvailable()) {
            this.method = tiffCpConverter;
        } else {
            ImageMagickTiffCompressionConverter convertConverter = new ImageMagickTiffCompressionConverter();
            if (convertConverter.isAvailable()) {
                this.method = convertConverter;
            } else {
                throw new EnvironmentFailureException("No suitable compression method found");
            }
        }
    }

    @Override
    public File tryCheckConvert(File inFile) {
        String ext = FilenameUtils.getExtension((String)inFile.getName()).toLowerCase();
        if ("tiff".equals(ext) || "tif".equals(ext)) {
            return inFile;
        }
        return null;
    }

    @Override
    public boolean deleteOriginalFile() {
        return false;
    }

    @Override
    public IFileConversionMethod getConverter() {
        return this.method;
    }

    public static enum TiffCompressionMethod {
        IMAGEMAGICK_CONVERT,
        LIBTIFF_TIFFCP;

    }
}

