/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.common.spring;

import ch.systemsx.cisd.common.logging.LogCategory;
import ch.systemsx.cisd.common.logging.LogFactory;
import ch.systemsx.cisd.common.reflection.MethodUtils;
import ch.systemsx.cisd.openbis.common.spring.IInvocationLoggerContext;
import ch.systemsx.cisd.openbis.common.spring.IInvocationLoggerFactory;
import java.io.Serializable;
import java.lang.reflect.Method;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.apache.commons.lang.time.StopWatch;
import org.apache.log4j.Logger;

public final class LogInterceptor
implements MethodInterceptor,
Serializable {
    private static final long serialVersionUID = 1L;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public final Object invoke(MethodInvocation invocation) throws Throwable {
        Object object;
        Object wrappedObject = invocation.getThis();
        if (!(wrappedObject instanceof IInvocationLoggerFactory)) {
            throw new IllegalArgumentException("Wrapped object isn't a " + IInvocationLoggerFactory.class.getName() + ": " + wrappedObject);
        }
        IInvocationLoggerFactory loggerFactory = (IInvocationLoggerFactory)wrappedObject;
        Object[] arguments = invocation.getArguments();
        String sessionTokenOrNull = this.tryToGetSessionToken(arguments);
        InvocationLoggerContext invocationLoggerContext = new InvocationLoggerContext(sessionTokenOrNull);
        Object logger = loggerFactory.createLogger(invocationLoggerContext);
        StopWatch timer = new StopWatch();
        try {
            timer.start();
            Object result = invocation.proceed();
            invocationLoggerContext.invocationSuccessful = true;
            object = result;
        }
        catch (Throwable th) {
            try {
                this.logError(invocation, wrappedObject, th);
                throw th;
            }
            catch (Throwable throwable) {
                timer.stop();
                invocationLoggerContext.elapsedTime = timer.getTime();
                Method method = invocation.getMethod();
                try {
                    method.invoke(logger, arguments);
                    throw throwable;
                }
                catch (IllegalArgumentException illegalArgumentException) {}
                throw throwable;
            }
        }
        timer.stop();
        invocationLoggerContext.elapsedTime = timer.getTime();
        Method method = invocation.getMethod();
        try {
            method.invoke(logger, arguments);
            return object;
        }
        catch (IllegalArgumentException illegalArgumentException) {}
        return object;
    }

    private void logError(MethodInvocation invocation, Object wrappedObject, Throwable th) {
        Class<?> clazz = wrappedObject.getClass();
        Logger operationLog = LogFactory.getLogger(LogCategory.OPERATION, clazz);
        String errorMsg = String.format("An exception has occurred while processing method: '%s'.", MethodUtils.describeMethod(invocation.getMethod()));
        try {
            operationLog.error(errorMsg, th);
        }
        catch (Exception ex) {
            operationLog.error(errorMsg);
            operationLog.error("It was not possible to log the exception which caused the problem", ex);
        }
    }

    private String tryToGetSessionToken(Object[] arguments) {
        if (arguments.length == 0) {
            return null;
        }
        Object firstArgument = arguments[0];
        return firstArgument instanceof String ? (String)firstArgument : null;
    }

    private static final class InvocationLoggerContext
    implements IInvocationLoggerContext {
        private final String sessionToken;
        boolean invocationSuccessful;
        long elapsedTime;

        InvocationLoggerContext(String sessionTokenOrNull) {
            this.sessionToken = sessionTokenOrNull;
        }

        @Override
        public String tryToGetSessionToken() {
            return this.sessionToken;
        }

        @Override
        public boolean invocationWasSuccessful() {
            return this.invocationSuccessful;
        }

        @Override
        public long getElapsedTime() {
            return this.elapsedTime;
        }
    }
}

